/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.api.config.PowerMultiplier;
import appeng.block.AEBaseItemBlock;
import appeng.block.AEBaseItemBlockChargeable;
import appeng.block.AEBaseTileBlock;
import appeng.client.render.blocks.RenderBlockEnergyCube;
import appeng.client.texture.ExtraBlockTextures;
import appeng.core.features.AEFeature;
import appeng.helpers.AEGlassMaterial;
import appeng.tile.networking.TileEnergyCell;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class BlockEnergyCell
extends AEBaseTileBlock {
    public BlockEnergyCell() {
        super(AEGlassMaterial.INSTANCE);
        this.setTileEntity(TileEnergyCell.class);
        this.setFeature(EnumSet.of(AEFeature.Core));
    }

    @SideOnly(value=Side.CLIENT)
    protected RenderBlockEnergyCube getRenderer() {
        return new RenderBlockEnergyCube();
    }

    @Override
    public IIcon func_149691_a(int direction, int metadata) {
        IIcon iIcon;
        switch (metadata) {
            case 0: {
                iIcon = ExtraBlockTextures.MEEnergyCell0.getIcon();
                break;
            }
            case 1: {
                iIcon = ExtraBlockTextures.MEEnergyCell1.getIcon();
                break;
            }
            case 2: {
                iIcon = ExtraBlockTextures.MEEnergyCell2.getIcon();
                break;
            }
            case 3: {
                iIcon = ExtraBlockTextures.MEEnergyCell3.getIcon();
                break;
            }
            case 4: {
                iIcon = ExtraBlockTextures.MEEnergyCell4.getIcon();
                break;
            }
            case 5: {
                iIcon = ExtraBlockTextures.MEEnergyCell5.getIcon();
                break;
            }
            case 6: {
                iIcon = ExtraBlockTextures.MEEnergyCell6.getIcon();
                break;
            }
            case 7: {
                iIcon = ExtraBlockTextures.MEEnergyCell7.getIcon();
                break;
            }
            default: {
                iIcon = super.func_149691_a(direction, metadata);
            }
        }
        return iIcon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> itemStacks) {
        super.getCheckedSubBlocks(item, tabs, itemStacks);
        ItemStack charged = new ItemStack((Block)this, 1);
        NBTTagCompound tag = Platform.openNbtData(charged);
        tag.func_74780_a("internalCurrentPower", this.getMaxPower());
        tag.func_74780_a("internalMaxPower", this.getMaxPower());
        itemStacks.add(charged);
    }

    public double getMaxPower() {
        return 200000.0 * PowerMultiplier.CONFIG.multiplier;
    }

    @Override
    public Class<? extends AEBaseItemBlock> getItemBlockClass() {
        return AEBaseItemBlockChargeable.class;
    }
}

