/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.gregtech;

import blockrenderer6343.api.utils.CreativeItemSource;
import blockrenderer6343.client.utils.TieredConstructable;
import blockrenderer6343.client.world.ClientFakePlayer;
import blockrenderer6343.client.world.DummyWorld;
import blockrenderer6343.integration.gregtech.GTGuiMultiblockHandler;
import blockrenderer6343.integration.gregtech.StructureHacks;
import blockrenderer6343.integration.nei.MultiblockHandler;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.mojang.authlib.GameProfile;
import gregtech.api.GregTechAPI;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.common.blocks.ItemCasingsAbstract;
import gregtech.common.blocks.ItemFrames;
import gregtech.common.blocks.ItemMachines;
import gtPlusPlus.xmod.gregtech.common.blocks.GregtechMetaItemCasingsAbstract;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GTNEIMultiblockHandler
extends MultiblockHandler {
    public static final List<IConstructable> multiblocksList = new ArrayList<IConstructable>();
    private static final ItemStackMap<ObjectSet<IConstructable>> casingForMulti;
    private static final GTGuiMultiblockHandler baseHandler;
    public static final String GT_NEI_MB_HANDLER_NAME = "gregtech.nei.multiblockhandler";

    public GTNEIMultiblockHandler() {
        super(baseHandler);
    }

    public String getOverlayIdentifier() {
        return GT_NEI_MB_HANDLER_NAME;
    }

    public TemplateRecipeHandler newInstance() {
        return new GTNEIMultiblockHandler();
    }

    @Override
    @NotNull
    public ItemStack getConstructableStack(IConstructable multiblock) {
        if (multiblock instanceof TieredConstructable) {
            TieredConstructable tiered = (TieredConstructable)multiblock;
            multiblock = tiered.getOriginal();
        }
        return ((IMetaTileEntity)multiblock).getStackForm(1L);
    }

    @Override
    @NotNull
    protected ObjectSet<IConstructable> tryLoadingMultiblocks(ItemStack candidate) {
        if (GTNEIMultiblockHandler.isValidItem(candidate.func_77973_b())) {
            return (ObjectSet)casingForMulti.getOrDefault((Object)candidate, (Object)ObjectSets.emptySet());
        }
        for (IConstructable multiblock : multiblocksList) {
            ItemStack stackForm = ((IMetaTileEntity)multiblock).getStackForm(1L);
            if (!NEIClientUtils.areStacksSameType((ItemStack)stackForm, (ItemStack)candidate)) continue;
            return ObjectSets.singleton((Object)multiblock);
        }
        return ObjectSets.emptySet();
    }

    @Override
    protected boolean isPotentialCandidate(ItemStack candidate) {
        return GTNEIMultiblockHandler.isValidItem(candidate.func_77973_b()) || candidate.func_77973_b() instanceof ItemMachines;
    }

    private static ItemStackMap<ObjectSet<IConstructable>> getCasingForMulti() {
        ItemStackMap result = new ItemStackMap();
        AutoPlaceEnvironment autoPlaceEnv = AutoPlaceEnvironment.fromLegacy((IItemSource)CreativeItemSource.instance, (EntityPlayer)new ClientFakePlayer(DummyWorld.INSTANCE, new GameProfile(UUID.randomUUID(), "GT_NEI_MultiblockHandler")), a -> {});
        for (IConstructable multi : multiblocksList) {
            IStructureDefinition structure = multi.getStructureDefinition();
            if (!(structure instanceof StructureDefinition)) continue;
            StructureDefinition structureDefinition = (StructureDefinition)structure;
            ObjectOpenHashSet checkedElements = new ObjectOpenHashSet();
            Iterator iterator = structureDefinition.getStructures().values().iterator();
            while (iterator.hasNext()) {
                IStructureElement[] elementArray;
                for (IStructureElement element : elementArray = (IStructureElement[])iterator.next()) {
                    Iterable<ItemStack> stacks;
                    if (!checkedElements.add((Object)element) || (stacks = StructureHacks.getStacksForElement(multi, (IStructureElement<IConstructable>)element, autoPlaceEnv)) == null) continue;
                    for (ItemStack stack : stacks) {
                        if (!GTNEIMultiblockHandler.isValidItem(stack.func_77973_b())) continue;
                        ObjectSet set = (ObjectSet)result.computeIfAbsent(stack, k -> new ObjectOpenHashSet());
                        if (stack.field_77994_a > 1) {
                            set.add((Object)new TieredConstructable(multi, stack.field_77994_a));
                            continue;
                        }
                        set.add((Object)multi);
                    }
                }
            }
        }
        return result;
    }

    static boolean isValidItem(Item candidate) {
        if (!(candidate instanceof ItemBlock)) {
            return false;
        }
        return candidate instanceof ItemCasingsAbstract || candidate instanceof ItemFrames || candidate instanceof GregtechMetaItemCasingsAbstract || StructureHacks.validGlass.contains(candidate);
    }

    static {
        baseHandler = new GTGuiMultiblockHandler();
        for (IMetaTileEntity mte : GregTechAPI.METATILEENTITIES) {
            if (!(mte instanceof IConstructable)) continue;
            IConstructable constructable = (IConstructable)mte;
            multiblocksList.add(constructable);
        }
        casingForMulti = GTNEIMultiblockHandler.getCasingForMulti();
    }
}

