/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import com.mitchej123.hodgepodge.config.FixesConfig;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S02PacketChat;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={S02PacketChat.class})
public abstract class MixinS02PacketChat {
    private static final Logger LOGGER = LogManager.getLogger((String)"ChatOverflowFix");
    @Shadow
    private IChatComponent field_148919_a;

    @Redirect(method={"writePacketData"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/PacketBuffer;writeStringToBuffer(Ljava/lang/String;)V"))
    public void hodgepodge$redirectSerialize(PacketBuffer instance, String s2) {
        byte[] bytes = s2.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > Short.MAX_VALUE) {
            if (FixesConfig.logHugeChat) {
                String incidentId = "" + System.currentTimeMillis() + ThreadLocalRandom.current().nextInt(1000);
                LOGGER.info("HUGE chat message caught. Incident ID {}. Serialized message {}.", new Object[]{incidentId, s2});
                bytes = IChatComponent.Serializer.func_150696_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Someone tried to sent you a huge chat message that would kick you. Ask your server admin to see details. Please provide these info while reporting: Incident ID " + EnumChatFormatting.UNDERLINE + incidentId + EnumChatFormatting.RESET + ". Start of original message: " + this.field_148919_a.func_150260_c().substring(0, 30))).getBytes(StandardCharsets.UTF_8);
            } else {
                LOGGER.info("HUGE chat message caught. Details are not logged here as requested in config.");
                bytes = IChatComponent.Serializer.func_150696_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Someone tried to sent you a huge chat message that would kick you. Ask your server admin to turn on logHugeChat in HodgePodge if you cannot identify the source of this and this keeps happening. " + EnumChatFormatting.RESET + "Start of original message: " + this.field_148919_a.func_150260_c().substring(0, 30))).getBytes(StandardCharsets.UTF_8);
            }
        }
        instance.func_150787_b(bytes.length);
        instance.writeBytes(bytes);
    }
}

