/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.io.nettyopis.handler.codec.http.websocketx;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import mcp.mobius.shadow.io.nettyopis.channel.Channel;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelFuture;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelFutureListener;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelHandler;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelHandlerContext;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelPipeline;
import mcp.mobius.shadow.io.nettyopis.channel.ChannelPromise;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.FullHttpRequest;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.FullHttpResponse;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.HttpContentCompressor;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.HttpHeaders;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.HttpObjectAggregator;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.HttpRequestDecoder;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.HttpResponseEncoder;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.HttpServerCodec;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.websocketx.CloseWebSocketFrame;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.websocketx.WebSocketFrameDecoder;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.websocketx.WebSocketFrameEncoder;
import mcp.mobius.shadow.io.nettyopis.handler.codec.http.websocketx.WebSocketVersion;
import mcp.mobius.shadow.io.nettyopis.util.internal.EmptyArrays;
import mcp.mobius.shadow.io.nettyopis.util.internal.StringUtil;
import mcp.mobius.shadow.io.nettyopis.util.internal.logging.InternalLogger;
import mcp.mobius.shadow.io.nettyopis.util.internal.logging.InternalLoggerFactory;

public abstract class WebSocketServerHandshaker {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker.class);
    private final String uri;
    private final String[] subprotocols;
    private final WebSocketVersion version;
    private final int maxFramePayloadLength;
    private String selectedSubprotocol;
    public static final String SUB_PROTOCOL_WILDCARD = "*";

    protected WebSocketServerHandshaker(WebSocketVersion version, String uri, String subprotocols, int maxFramePayloadLength) {
        this.version = version;
        this.uri = uri;
        if (subprotocols != null) {
            String[] subprotocolArray = StringUtil.split(subprotocols, ',');
            for (int i = 0; i < subprotocolArray.length; ++i) {
                subprotocolArray[i] = subprotocolArray[i].trim();
            }
            this.subprotocols = subprotocolArray;
        } else {
            this.subprotocols = EmptyArrays.EMPTY_STRINGS;
        }
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    public String uri() {
        return this.uri;
    }

    public Set<String> subprotocols() {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        Collections.addAll(ret, this.subprotocols);
        return ret;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public ChannelFuture handshake(Channel channel, FullHttpRequest req) {
        return this.handshake(channel, req, null, channel.newPromise());
    }

    public final ChannelFuture handshake(Channel channel, FullHttpRequest req, HttpHeaders responseHeaders, final ChannelPromise promise) {
        String encoderName;
        ChannelHandlerContext ctx;
        if (logger.isDebugEnabled()) {
            logger.debug("{} WebSocket version {} server handshake", (Object)channel, (Object)this.version());
        }
        FullHttpResponse response = this.newHandshakeResponse(req, responseHeaders);
        ChannelPipeline p = channel.pipeline();
        if (p.get(HttpObjectAggregator.class) != null) {
            p.remove(HttpObjectAggregator.class);
        }
        if (p.get(HttpContentCompressor.class) != null) {
            p.remove(HttpContentCompressor.class);
        }
        if ((ctx = p.context(HttpRequestDecoder.class)) == null) {
            ctx = p.context(HttpServerCodec.class);
            if (ctx == null) {
                promise.setFailure(new IllegalStateException("No HttpDecoder and no HttpServerCodec in the pipeline"));
                return promise;
            }
            p.addBefore(ctx.name(), "wsdecoder", this.newWebsocketDecoder());
            p.addBefore(ctx.name(), "wsencoder", this.newWebSocketEncoder());
            encoderName = ctx.name();
        } else {
            p.replace(ctx.name(), "wsdecoder", (ChannelHandler)this.newWebsocketDecoder());
            encoderName = p.context(HttpResponseEncoder.class).name();
            p.addBefore(encoderName, "wsencoder", this.newWebSocketEncoder());
        }
        channel.writeAndFlush(response).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ChannelPipeline p = future.channel().pipeline();
                    p.remove(encoderName);
                    promise.setSuccess();
                } else {
                    promise.setFailure(future.cause());
                }
            }
        });
        return promise;
    }

    protected abstract FullHttpResponse newHandshakeResponse(FullHttpRequest var1, HttpHeaders var2);

    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        return this.close(channel, frame, channel.newPromise());
    }

    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame, ChannelPromise promise) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        return channel.writeAndFlush(frame, promise).addListener(ChannelFutureListener.CLOSE);
    }

    protected String selectSubprotocol(String requestedSubprotocols) {
        String[] requestedSubprotocolArray;
        if (requestedSubprotocols == null || this.subprotocols.length == 0) {
            return null;
        }
        for (String p : requestedSubprotocolArray = StringUtil.split(requestedSubprotocols, ',')) {
            String requestedSubprotocol = p.trim();
            for (String supportedSubprotocol : this.subprotocols) {
                if (!SUB_PROTOCOL_WILDCARD.equals(supportedSubprotocol) && !requestedSubprotocol.equals(supportedSubprotocol)) continue;
                this.selectedSubprotocol = requestedSubprotocol;
                return requestedSubprotocol;
            }
        }
        return null;
    }

    public String selectedSubprotocol() {
        return this.selectedSubprotocol;
    }

    protected abstract WebSocketFrameDecoder newWebsocketDecoder();

    protected abstract WebSocketFrameEncoder newWebSocketEncoder();
}

