/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IFlower;
import forestry.apiculture.blocks.BlockApicultureType;
import forestry.apiculture.tiles.TileApiary;
import forestry.arboriculture.worldgen.BlockTypeLog;
import forestry.arboriculture.worldgen.BlockTypeVanillaStairs;
import forestry.arboriculture.worldgen.BlockTypeWood;
import forestry.arboriculture.worldgen.BlockTypeWoodStairs;
import forestry.core.blocks.BlockCoreType;
import forestry.core.tiles.TileUtil;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.BlockTypeTileForestry;
import forestry.core.worldgen.IBlockType;
import forestry.plugins.PluginApiculture;
import forestry.plugins.PluginCore;
import forestry.plugins.PluginManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class ComponentVillageBeeHouse
extends StructureVillagePieces.House1 {
    private static final Random random = new Random();
    private int averageGroundLevel = -1;
    private boolean isInDesert = false;
    private IBlockType planks;
    private IBlockType logs;
    private IBlockType stairs;
    private IBlockType fence;

    public ComponentVillageBeeHouse() {
        this.createBuildingBlocks(random);
    }

    public ComponentVillageBeeHouse(StructureVillagePieces.Start startPiece, int componentType, Random random, StructureBoundingBox boundingBox, int coordBaseMode) {
        super(startPiece, componentType, random, boundingBox, coordBaseMode);
        this.isInDesert = startPiece.field_74927_b;
        this.createBuildingBlocks(random);
    }

    private void createBuildingBlocks(Random random) {
        if (PluginManager.Module.ARBORICULTURE.isEnabled()) {
            boolean fireproof = random.nextInt(4) == 0;
            EnumWoodType roofWood = EnumWoodType.getRandom(random);
            EnumWoodType logWood = EnumWoodType.getRandom(random);
            EnumWoodType fenceWood = EnumWoodType.getRandom(random);
            this.logs = new BlockTypeLog(TreeManager.woodItemAccess.getLog(logWood, fireproof));
            this.planks = new BlockTypeWood(TreeManager.woodItemAccess.getPlanks(roofWood, fireproof));
            this.stairs = new BlockTypeWoodStairs(TreeManager.woodItemAccess.getStairs(roofWood, fireproof));
            this.fence = new BlockTypeWood(TreeManager.woodItemAccess.getFence(fenceWood, fireproof));
        } else {
            int roofMeta = random.nextInt(16);
            this.logs = new BlockType(Blocks.field_150364_r, random.nextInt(4));
            this.planks = new BlockType(Blocks.field_150344_f, roofMeta);
            this.stairs = new BlockTypeVanillaStairs(roofMeta);
            this.fence = new BlockType(Blocks.field_150422_aJ, 0);
        }
    }

    public static ComponentVillageBeeHouse buildComponent(StructureVillagePieces.Start startPiece, List par1List, Random random, int par3, int par4, int par5, int par6, int par7) {
        StructureBoundingBox bbox = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)10, (int)9, (int)11, (int)par6);
        if (!ComponentVillageBeeHouse.func_74895_a((StructureBoundingBox)bbox) || StructureComponent.func_74883_a((List)par1List, (StructureBoundingBox)bbox) != null) {
            return null;
        }
        return new ComponentVillageBeeHouse(startPiece, par7, random, bbox, par6);
    }

    public boolean func_74875_a(World world, Random random, StructureBoundingBox structBoundingBox) {
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, structBoundingBox);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 8 - 1, 0);
        }
        this.func_151549_a(world, structBoundingBox, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.func_151549_a(world, structBoundingBox, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
        this.buildGarden(world, structBoundingBox);
        this.fillBoxWith(world, structBoundingBox, 1, 1, 6, 1, 1, 10, this.fence, false);
        this.fillBoxWith(world, structBoundingBox, 8, 1, 6, 8, 1, 10, this.fence, false);
        this.fillBoxWith(world, structBoundingBox, 2, 1, 10, 7, 1, 10, this.fence, false);
        this.plantFlowerGarden(world, structBoundingBox, 2, 1, 5, 7, 1, 9);
        this.buildApiaries(world, structBoundingBox);
        this.func_151549_a(world, structBoundingBox, 1, 0, 1, 7, 0, 4, Blocks.field_150344_f, Blocks.field_150344_f, false);
        this.func_151549_a(world, structBoundingBox, 0, 0, 0, 0, 3, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
        this.func_151549_a(world, structBoundingBox, 8, 0, 0, 8, 3, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
        this.func_151549_a(world, structBoundingBox, 1, 0, 0, 7, 1, 0, Blocks.field_150347_e, Blocks.field_150347_e, false);
        this.func_151549_a(world, structBoundingBox, 1, 0, 5, 7, 1, 5, Blocks.field_150347_e, Blocks.field_150347_e, false);
        this.fillBoxWith(world, structBoundingBox, 1, 2, 0, 7, 3, 0, this.planks, false);
        this.fillBoxWith(world, structBoundingBox, 1, 2, 5, 7, 3, 5, this.planks, false);
        this.fillBoxWith(world, structBoundingBox, 0, 4, 1, 8, 4, 1, this.planks, false);
        this.fillBoxWith(world, structBoundingBox, 0, 4, 4, 8, 4, 4, this.planks, false);
        this.fillBoxWith(world, structBoundingBox, 0, 5, 2, 8, 5, 3, this.planks, false);
        this.placeBlockAtCurrentPosition(world, this.planks, 0, 4, 2, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.planks, 0, 4, 3, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.planks, 8, 4, 2, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.planks, 8, 4, 3, structBoundingBox);
        this.buildRoof(world, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.logs, 0, 2, 1, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.logs, 0, 2, 4, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.logs, 8, 2, 1, structBoundingBox);
        this.placeBlockAtCurrentPosition(world, this.logs, 8, 2, 4, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 0, 2, 2, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 0, 2, 3, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 8, 2, 2, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 8, 2, 3, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 2, 2, 5, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 3, 2, 5, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 4, 2, 5, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 5, 2, 0, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150410_aZ, 0, 6, 2, 5, structBoundingBox);
        if (random.nextInt(2) == 0) {
            BlockTypeTileForestry escritoireBlock = new BlockTypeTileForestry((Block)PluginCore.blocks.core, BlockCoreType.ESCRITOIRE.ordinal());
            escritoireBlock.setDirection(this.getRotatedDirection(ForgeDirection.EAST));
            this.placeBlockAtCurrentPosition(world, escritoireBlock, 1, 1, 3, structBoundingBox);
        }
        this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 1, 0, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150350_a, 0, 2, 2, 0, structBoundingBox);
        this.func_74881_a(world, structBoundingBox, random, 2, 1, 0, this.func_151555_a(Blocks.field_150466_ao, 1));
        if (this.isAirBlockAtCurrentPosition(world, 2, 0, -1, structBoundingBox) && !this.isAirBlockAtCurrentPosition(world, 2, -1, -1, structBoundingBox)) {
            this.func_151550_a(world, Blocks.field_150446_ar, this.func_151555_a(Blocks.field_150446_ar, 3), 2, 0, -1, structBoundingBox);
        }
        this.func_151550_a(world, Blocks.field_150350_a, 0, 6, 1, 5, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150350_a, 0, 6, 2, 5, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 2, 3, 4, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 6, 3, 4, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 2, 3, 1, structBoundingBox);
        this.func_151550_a(world, Blocks.field_150478_aa, 0, 6, 3, 1, structBoundingBox);
        this.func_74881_a(world, structBoundingBox, random, 6, 1, 5, this.func_151555_a(Blocks.field_150466_ao, 1));
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_74871_b(world, j, 7, i, structBoundingBox);
                this.func_151554_b(world, Blocks.field_150347_e, 0, j, -1, i, structBoundingBox);
            }
        }
        this.func_74879_a(world, structBoundingBox, random, 7, 1, 4, ChestGenHooks.getItems((String)"naturalistChest", (Random)random), random.nextInt(4) + random.nextInt(4) + 5);
        this.func_74893_a(world, this.field_74887_e, 7, 1, 1, 2);
        return true;
    }

    private void buildRoof(World world, StructureBoundingBox structBoundingBox) {
        for (int i = -1; i <= 2; ++i) {
            for (int j = 0; j <= 8; ++j) {
                this.stairs.setDirection(this.getRotatedDirection(ForgeDirection.NORTH));
                this.placeBlockAtCurrentPosition(world, this.stairs, j, 4 + i, i, structBoundingBox);
                this.stairs.setDirection(this.getRotatedDirection(ForgeDirection.SOUTH));
                this.placeBlockAtCurrentPosition(world, this.stairs, j, 4 + i, 5 - i, structBoundingBox);
            }
        }
    }

    private void buildGarden(World world, StructureBoundingBox box) {
        Block ground = Blocks.field_150346_d;
        if (this.isInDesert) {
            ground = Blocks.field_150354_m;
        }
        for (int i = 1; i <= 8; ++i) {
            for (int j = 6; j <= 10; ++j) {
                this.func_151554_b(world, ground, 0, i, 0, j, box);
            }
        }
    }

    private void plantFlowerGarden(World world, StructureBoundingBox box, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (this.isInDesert) {
            this.func_151550_a(world, Blocks.field_150434_aF, 0, 4, 1, 7, box);
            return;
        }
        for (int i = minY; i <= maxY; ++i) {
            for (int j = minX; j <= maxX; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    int zCoord;
                    int yCoord;
                    int xCoord;
                    if (!world.field_73012_v.nextBoolean() || !Blocks.field_150328_O.func_149718_j(world, xCoord = this.func_74865_a(j, k), yCoord = this.func_74862_a(i), zCoord = this.func_74873_b(j, k))) continue;
                    IFlower flower = FlowerManager.flowerRegistry.getRandomPlantableFlower("flowersVanilla", world.field_73012_v);
                    this.func_151550_a(world, flower.getBlock(), flower.getMeta(), j, i, k, box);
                }
            }
        }
    }

    private void buildApiaries(World world, StructureBoundingBox box) {
        this.populateApiary(world, box, 3, 1, 8);
        this.populateApiary(world, box, 6, 1, 8);
    }

    private void populateApiary(World world, StructureBoundingBox box, int x, int y, int z) {
        int zCoord;
        int yCoord;
        int xCoord = this.func_74865_a(x, z);
        if (!box.func_78890_b(xCoord, yCoord = this.func_74862_a(y), zCoord = this.func_74873_b(x, z))) {
            return;
        }
        Block block = world.func_147439_a(xCoord, yCoord, zCoord);
        if (PluginApiculture.blocks.apiculture == block || !world.func_72899_e(xCoord, yCoord - 1, zCoord)) {
            return;
        }
        world.func_147465_d(xCoord, yCoord, zCoord, (Block)PluginApiculture.blocks.apiculture, BlockApicultureType.APIARY.ordinal(), 2);
        PluginApiculture.blocks.apiculture.func_149726_b(world, xCoord, yCoord, zCoord);
        TileApiary apiary = TileUtil.getTile((IBlockAccess)world, xCoord, yCoord, zCoord, TileApiary.class);
        if (apiary == null) {
            return;
        }
        ItemStack randomVillagePrincess = ComponentVillageBeeHouse.getRandomVillageBeeStack(world, xCoord, yCoord, zCoord, EnumBeeType.PRINCESS);
        apiary.getBeeInventory().setQueen(randomVillagePrincess);
        ItemStack randomVillageDrone = ComponentVillageBeeHouse.getRandomVillageBeeStack(world, xCoord, yCoord, zCoord, EnumBeeType.DRONE);
        apiary.getBeeInventory().setDrone(randomVillageDrone);
        for (int i = 9; i < 12; ++i) {
            ItemStack randomFrame = ComponentVillageBeeHouse.getRandomFrame(world.field_73012_v);
            apiary.func_70299_a(i, randomFrame);
        }
    }

    private static ItemStack getRandomFrame(Random random) {
        float roll = random.nextFloat();
        if (roll < 0.2f) {
            return PluginApiculture.items.frameUntreated.getItemStack();
        }
        if (roll < 0.4f) {
            return PluginApiculture.items.frameImpregnated.getItemStack();
        }
        if ((double)roll < 0.6) {
            return PluginApiculture.items.frameProven.getItemStack();
        }
        return null;
    }

    private static ItemStack getRandomVillageBeeStack(World world, int xCoord, int yCoord, int zCoord, EnumBeeType beeType) {
        IBee randomVillageBee = ComponentVillageBeeHouse.getRandomVillageBee(world, xCoord, yCoord, zCoord);
        return BeeManager.beeRoot.getMemberStack(randomVillageBee, beeType.ordinal());
    }

    private static IBee getRandomVillageBee(World world, int xCoord, int yCoord, int zCoord) {
        BiomeGenBase biome = world.func_72807_a(xCoord, zCoord);
        ArrayList<IBeeGenome> candidates = BeeManager.villageBees[1] != null && BeeManager.villageBees[1].size() > 0 && world.field_73012_v.nextDouble() < 0.2 ? BeeManager.villageBees[1] : BeeManager.villageBees[0];
        EnumTemperature biomeTemperature = EnumTemperature.getFromBiome(biome, xCoord, yCoord, zCoord);
        EnumHumidity biomeHumidity = EnumHumidity.getFromValue(biome.field_76751_G);
        ArrayList<IBeeGenome> valid = new ArrayList<IBeeGenome>();
        for (IBeeGenome genome : candidates) {
            if (!ComponentVillageBeeHouse.checkBiomeHazard(genome, biomeTemperature, biomeHumidity)) continue;
            valid.add(genome);
        }
        if (valid.isEmpty()) {
            return BeeManager.beeRoot.getBee(world, BeeManager.villageBees[0].get(world.field_73012_v.nextInt(BeeManager.villageBees[0].size())));
        }
        return BeeManager.beeRoot.getBee(world, (IBeeGenome)valid.get(world.field_73012_v.nextInt(valid.size())));
    }

    private static boolean checkBiomeHazard(IBeeGenome genome, EnumTemperature biomeTemperature, EnumHumidity biomeHumidity) {
        IAlleleBeeSpecies species = genome.getPrimary();
        return AlleleManager.climateHelper.isWithinLimits(biomeTemperature, biomeHumidity, species.getTemperature(), genome.getToleranceTemp(), species.getHumidity(), genome.getToleranceHumid());
    }

    private void fillBoxWith(World world, StructureBoundingBox box, int par3, int par4, int par5, int par6, int par7, int par8, IBlockType block, boolean replace) {
        for (int var14 = par4; var14 <= par7; ++var14) {
            for (int var15 = par3; var15 <= par6; ++var15) {
                for (int var16 = par5; var16 <= par8; ++var16) {
                    if (replace && this.isAirBlockAtCurrentPosition(world, var15, var14, var16, box)) continue;
                    this.placeBlockAtCurrentPosition(world, block, var15, var14, var16, box);
                }
            }
        }
    }

    private void placeBlockAtCurrentPosition(World world, IBlockType block, int par4, int par5, int par6, StructureBoundingBox par7StructureBoundingBox) {
        int z;
        int y;
        int x = this.func_74865_a(par4, par6);
        if (par7StructureBoundingBox.func_78890_b(x, y = this.func_74862_a(par5), z = this.func_74873_b(par4, par6))) {
            block.setBlock(world, x, y, z);
        }
    }

    protected int func_74888_b(int villagerCount) {
        if (villagerCount <= 0) {
            return 80;
        }
        return 81;
    }

    private boolean isAirBlockAtCurrentPosition(World world, int x, int y, int z, StructureBoundingBox box) {
        return this.func_151548_a(world, x, y, z, box).isAir((IBlockAccess)world, x, y, z);
    }

    private ForgeDirection getRotatedDirection(ForgeDirection direction) {
        int stairDirection = 5 - direction.ordinal();
        int meta = this.func_151555_a(Blocks.field_150476_ad, stairDirection);
        return ForgeDirection.getOrientation((int)(5 - meta));
    }
}

