/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class AspectListVisitor
extends ClassVisitor {
    public AspectListVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("add") && desc.equals("(Lthaumcraft/api/aspects/Aspect;I)Lthaumcraft/api/aspects/AspectList;")) {
            TC4Transformer.log.debug("Visiting {}#{}", new Object[]{name, desc});
            return new AddVisitor(this.api, mv);
        }
        return mv;
    }

    private static class AddVisitor
    extends MethodVisitor {
        private final Label end = new Label();
        private int labels = 0;

        public AddVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitCode() {
            super.visitCode();
            TC4Transformer.log.trace("Adding if guard to HEAD");
            this.mv.visitVarInsn(25, 1);
            this.mv.visitJumpInsn(198, this.end);
        }

        public void visitLabel(Label label) {
            if (++this.labels == 5) {
                TC4Transformer.log.trace("Replacing L4 with our own");
                this.mv.visitLabel(this.end);
            } else {
                super.visitLabel(label);
            }
        }

        public void visitLineNumber(int line, Label start) {
            if (line == 197) {
                TC4Transformer.log.trace("Replacing label instance");
                super.visitLineNumber(line, this.end);
                TC4Transformer.log.trace("Adding F_SAME");
                this.mv.visitFrame(3, 0, null, 0, null);
            } else {
                super.visitLineNumber(line, start);
            }
        }
    }
}

