/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.core.integrations.pack.multimc;

import com.gitlab.cdagaming.craftpresence.core.integrations.pack.Pack;
import io.github.cdagaming.unicore.utils.OSUtils;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;

public class MultiMCUtils
extends Pack {
    public MultiMCUtils(Supplier<Boolean> isEnabled) {
        super(isEnabled);
    }

    public MultiMCUtils(boolean isEnabled) {
        super(isEnabled);
    }

    public MultiMCUtils() {
    }

    @Override
    public boolean load() {
        boolean result;
        boolean bl = result = this.findWithSystem() || this.findWithLegacy();
        if (result) {
            this.setPackType(this.getLauncherType());
        }
        return result;
    }

    @Override
    public void setPackIcon(String packIcon) {
        super.setPackIcon(this.parseIcon(packIcon));
    }

    private String parseIcon(String original) {
        String defaultIcon = this.getDefaultIcon();
        if (StringUtils.isNullOrEmpty((String)original)) {
            return defaultIcon;
        }
        return !original.equals("default") ? original : defaultIcon;
    }

    private String getDefaultIcon() {
        if (Objects.equals(this.getPackType(), "prism")) {
            return "prismlauncher";
        }
        return "infinity";
    }

    private boolean findWithSystem() {
        try {
            this.setPackData(System.getProperty("multimc.instance.title"), System.getProperty("multimc.instance.icon"));
        }
        catch (Exception ex) {
            this.printException(ex);
        }
        return this.hasPackName() && this.hasPackIcon();
    }

    private boolean findWithLegacy() {
        Path instanceFile = Paths.get(MultiMCUtils.jvmdowngrader$concat$findWithLegacy$1(new File(OSUtils.USER_DIR).getParent(), File.separator), new String[0]);
        if (Files.exists(instanceFile, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(instanceFile, new OpenOption[0]);){
                Properties configFile = new Properties();
                configFile.load(inputStream);
                this.setPackData(configFile.getProperty("name"), configFile.getProperty("iconKey"));
            }
            catch (Exception ex) {
                this.printException(ex);
            }
        }
        return this.hasPackName() && this.hasPackIcon();
    }

    private String getLauncherType() {
        try {
            File prismLocation = new File(MultiMCUtils.jvmdowngrader$concat$getLauncherType$1(String.valueOf(new File(OSUtils.USER_DIR).getParentFile().getParentFile().getParentFile()), File.separator));
            if (prismLocation.exists()) {
                return "prism";
            }
        }
        catch (Exception ex) {
            this.printException(ex);
        }
        return "multimc";
    }

    private static String jvmdowngrader$concat$findWithLegacy$1(String string, String string2) {
        return string + string2 + "instance.cfg";
    }

    private static String jvmdowngrader$concat$getLauncherType$1(String string, String string2) {
        return string + string2 + "prismlauncher.cfg";
    }
}

