/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.hatch;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GTRenderedTexture;
import gtnhlanth.common.beamline.BeamLinePacket;
import gtnhlanth.common.beamline.IConnectsToBeamline;
import gtnhlanth.common.beamline.MTEBeamlinePipe;
import gtnhlanth.common.hatch.MTEHatchBeamlineConnector;
import gtnhlanth.common.hatch.MTEHatchInputBeamline;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.util.TTUtility;

public class MTEHatchOutputBeamline
extends MTEHatchBeamlineConnector<BeamLinePacket>
implements IConnectsToBeamline {
    private static final String activeIconPath = "iconsets/OVERLAY_BO_ACTIVE";
    private static final String sideIconPath = "iconsets/OVERLAY_BO_SIDES";
    private static final String connIconPath = "iconsets/BO_CONN";
    private static final Textures.BlockIcons.CustomIcon activeIcon = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_BO_ACTIVE");
    private static final Textures.BlockIcons.CustomIcon sideIcon = new Textures.BlockIcons.CustomIcon("iconsets/OVERLAY_BO_SIDES");
    private static final Textures.BlockIcons.CustomIcon connIcon = new Textures.BlockIcons.CustomIcon("iconsets/BO_CONN");

    public MTEHatchOutputBeamline(int id, String name, String nameRegional, int tier) {
        super(id, name, nameRegional, tier, "");
        TTUtility.setTier(tier, this);
    }

    public MTEHatchOutputBeamline(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GTRenderedTexture(activeIcon, Dyes.getModulation(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL.getRGBA())), new GTRenderedTexture(connIcon)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GTRenderedTexture(sideIcon, Dyes.getModulation(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL.getRGBA())), new GTRenderedTexture(connIcon)};
    }

    @Override
    public IConnectsToBeamline getNext(IConnectsToBeamline source) {
        IGregTechTileEntity base = this.getBaseMetaTileEntity();
        IGregTechTileEntity next = base.getIGregTechTileEntityAtSide(base.getFrontFacing());
        if (next == null) {
            return null;
        }
        IMetaTileEntity meta = next.getMetaTileEntity();
        if (meta instanceof MTEBeamlinePipe) {
            ((MTEBeamlinePipe)meta).markUsed();
            return (IConnectsToBeamline)meta;
        }
        if (meta instanceof MTEHatchInputBeamline && ((MTEHatchInputBeamline)meta).canConnect(base.getFrontFacing().getOpposite())) {
            return (IConnectsToBeamline)meta;
        }
        return null;
    }

    @Override
    public void moveAround(IGregTechTileEntity aBaseMetaTileEntity) {
        MTEHatchOutputBeamline current = this;
        MTEHatchOutputBeamline source = this;
        boolean range = false;
        ForgeDirection front = this.getBaseMetaTileEntity().getFrontFacing();
        for (int distance = 1; distance <= 129; ++distance) {
            IGregTechTileEntity nextTE = (IGregTechTileEntity)this.getBaseMetaTileEntity().getTileEntityAtSideAndDistance(front, distance);
            if (nextTE == null) {
                return;
            }
            IMetaTileEntity nextMeta = nextTE.getMetaTileEntity();
            if (!(nextMeta instanceof IConnectsToBeamline)) {
                return;
            }
            if (nextMeta instanceof MTEHatchInputBeamline) {
                ((MTEHatchInputBeamline)nextMeta).setContents((BeamLinePacket)this.q);
                break;
            }
            if (nextMeta instanceof MTEBeamlinePipe) {
                if (!((MTEBeamlinePipe)nextMeta).isDataInputFacing(front.getOpposite())) {
                    return;
                }
            } else {
                return;
            }
            ((MTEBeamlinePipe)nextMeta).markUsed();
        }
        this.q = null;
    }

    @Override
    protected BeamLinePacket loadPacketFromNBT(NBTTagCompound nbt) {
        return new BeamLinePacket(nbt);
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        return this.isOutputFacing(side);
    }

    @Override
    public boolean isDataInputFacing(ForgeDirection side) {
        return this.isInputFacing(side);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection aSide) {
        return false;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public String[] getDescription() {
        return null;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new MTEHatchOutputBeamline(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }
}

