/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.blocks.BlockCasings8;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class MTENanoForge
extends MTEExtendedPowerMultiBlockBase<MTENanoForge>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String STRUCTURE_PIECE_TIER2 = "tier2";
    private static final String STRUCTURE_PIECE_TIER3 = "tier3";
    private static final IStructureDefinition<MTENanoForge> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"         ", "         ", "    F    ", "    C    ", "    C    ", "    C    ", "    C    ", "    F    ", "         ", "         "}, {"         ", "         ", "    F    ", "    C    ", "    C    ", "    C    ", "    C    ", "    F    ", "         ", "         "}, {"         ", "         ", "    F    ", "    C    ", "    C    ", "    C    ", "    C    ", "    F    ", "         ", "         "}, {"         ", "         ", "    F    ", "    C    ", "    C    ", "    C    ", "    C    ", "    F    ", "         ", "         "}, {"         ", "         ", "    F    ", "    C    ", "    C    ", "    C    ", "    C    ", "    F    ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "   FCF   ", "  FC CF  ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "  FC CF  ", "   FCF   ", "         "}, {"         ", "   FCF   ", "  FC CF  ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "  FC CF  ", "   FCF   ", "         "}, {"         ", "   FCF   ", "  FC CF  ", "  C   C  ", "  C   C  ", "  C   C  ", "  C   C  ", "  FC CF  ", "   FCF   ", "         "}, {"         ", "   FCF   ", "  FC CF  ", "  C   C  ", "  C   C  ", "  C   C  ", "  C   C  ", "  FC CF  ", "   FCF   ", "         "}, {"    C    ", "   FCF   ", "  CC CC  ", "  C   C  ", "  C   C  ", "  C   C  ", "  C   C  ", "  CC CC  ", "   FCF   ", "    C    "}, {"    C    ", "   FCF   ", "  CC CC  ", "  C   C  ", "  C   C  ", "  C   C  ", "  C   C  ", "  CC CC  ", "   FCF   ", "    C    "}, {"    C    ", "   FCF   ", "  CC CC  ", "  C   C  ", "  C   C  ", "  C   C  ", "  C   C  ", "  CC CC  ", "   FCF   ", "    C    "}, {"    C    ", "   FCF   ", "  CC CC  ", " CC   CC ", " CC   CC ", " CC   CC ", " CC   CC ", "  CC CC  ", "   FCF   ", "    C    "}, {"    C    ", "   FCF   ", "  CC CC  ", " CC   CC ", " CC   CC ", " CC   CC ", " CC   CC ", "  CC CC  ", "   FCF   ", "    C    "}, {"    C    ", "   FCF   ", "  CC CC  ", "  C   C  ", "  C   C  ", "  C   C  ", "  C   C  ", "  CC CC  ", "   FCF   ", "    C    "}, {"    C    ", "   FCF   ", "  CC CC  ", "  C   C  ", "  C   C  ", "  C   C  ", "  C   C  ", "  CC CC  ", "   FCF   ", "    C    "}, {"    C    ", "   FCF   ", "  CC CC  ", "  C   C  ", "  C   C  ", "  C   C  ", "  C   C  ", "  CC CC  ", "   FCF   ", "    C    "}, {"         ", "   FCF   ", "  FC CF  ", "  C   C  ", "  C   C  ", "  C   C  ", "  C   C  ", "  FC CF  ", "   FCF   ", "         "}, {"         ", "   FCF   ", "  FC CF  ", "  C   C  ", "  C   C  ", "  C   C  ", "  C   C  ", "  FC CF  ", "   FCF   ", "         "}, {"         ", "   FCF   ", "  FC CF  ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "  FC CF  ", "   FCF   ", "         "}, {"         ", "   FCF   ", "  FC CF  ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "  FC CF  ", "   FCF   ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "         ", "   FCF   ", "   C C   ", "   C C   ", "   C C   ", "   C C   ", "   FCF   ", "         ", "         "}, {"         ", "  BB~BB  ", " BBBBBBB ", "BBBBBBBBB", "BBBBBBBBB", "BBBBBBBBB", "BBBBBBBBB", " BBBBBBB ", "  BBBBB  ", "         "}})).addShape("tier2", StructureUtility.transpose((String[][])new String[][]{{"        ", "        ", "   CC   ", "  CCCC  ", "  CCCC  ", "   CC   ", "        ", "        "}, {"        ", "        ", "   AA   ", "  ACCA  ", "  ACCA  ", "   AA   ", "        ", "        "}, {"        ", "        ", "   CC   ", "  CCCC  ", "  CCCC  ", "   CC   ", "        ", "        "}, {"        ", "        ", "        ", "   CC   ", "   CC   ", "        ", "        ", "        "}, {"        ", "        ", "        ", "   CC   ", "   CC   ", "        ", "        ", "        "}, {"        ", "        ", "        ", "   CC   ", "   CC   ", "        ", "        ", "        "}, {"        ", "        ", "        ", "   CC   ", "   CC   ", "        ", "        ", "        "}, {"        ", "        ", "   CC   ", "  CCCC  ", "  CCCC  ", "   CC   ", "        ", "        "}, {"        ", "        ", "   AA   ", "  ACCA  ", "  ACCA  ", "   AA   ", "        ", "        "}, {"        ", "        ", "   CC   ", "  CCCC  ", "  CCCC  ", "   CC   ", "        ", "        "}, {"        ", "        ", "        ", "   CC   ", "   CC   ", "        ", "        ", "        "}, {"        ", "        ", "        ", "   CC   ", "   CC   ", "        ", "        ", "        "}, {"        ", "        ", "        ", "   CC   ", "   CC   ", "        ", "        ", "        "}, {"        ", "        ", "        ", "   CC   ", "   CC   ", "        ", "        ", "        "}, {" CCCCCC ", "CCCCCCCC", "CCCCCCCC", "CCCCCCCC", "CCCCCCCC", "CCCCCCCC", "CCCCCCCC", " CCCCCC "}})).addShape("tier3", StructureUtility.transpose((String[][])new String[][]{{"        ", "        ", "   CC   ", "  CCCC  ", "  CCCC  ", "   CC   ", "        ", "        "}, {"        ", "        ", " FFAA   ", "  ACCA  ", "  ACCA  ", "   AAFF ", "        ", "        "}, {"        ", "        ", "F  CC   ", "F CCCC  ", "  CCCC F", "   CC  F", "        ", "        "}, {"        ", "        ", "       F", "   CC  F", "F  CC   ", "F       ", "        ", "        "}, {"        ", "      F ", "        ", "   CC   ", "   CC   ", "        ", " F      ", "        "}, {"    FF  ", "        ", "        ", "   CC   ", "   CC   ", "        ", "        ", "  FF    "}, {"  FF    ", "        ", "        ", "   CC   ", "   CC   ", "        ", "        ", "    FF  "}, {"        ", " F      ", "        ", "   CC   ", "   CC   ", "        ", "      F ", "        "}, {"        ", "        ", "F       ", "F  CC   ", "   CC  F", "       F", "        ", "        "}, {"        ", "        ", "   CC  F", "  CCCC F", "F CCCC  ", "F  CC   ", "        ", "        "}, {"        ", "      F ", "   CC   ", "  CCCC  ", "  CCCC  ", "   CC   ", " F      ", "        "}, {"    FF  ", "        ", "   CC   ", "  CCCC  ", "  CCCC  ", "   CC   ", "        ", "  FF    "}, {"  FF    ", "        ", "   CC   ", "  CCCC  ", "  CCCC  ", "   CC   ", "        ", "    FF  "}, {"        ", " F      ", "        ", "   CC   ", "   CC   ", "        ", "      F ", "        "}, {"        ", "        ", "F       ", "F  CC   ", "   CC  F", "       F", "        ", "        "}, {"        ", "        ", "       F", "   CC  F", "F  CC   ", "F       ", "        ", "        "}, {"        ", "      F ", "        ", "   CC   ", "   CC   ", "        ", " F      ", "        "}, {"    FF  ", "        ", "        ", "   CC   ", "   CC   ", "        ", "        ", "  FF    "}, {"  FF    ", "        ", "        ", "   CC   ", "   CC   ", "        ", "        ", "    FF  "}, {"        ", " F      ", "        ", "   CC   ", "   CC   ", "        ", "      F ", "        "}, {"        ", "        ", "F  CC   ", "F CCCC  ", "  CCCC F", "   CC  F", "        ", "        "}, {"        ", "        ", "   AA  F", "  ACCA F", "F ACCA  ", "F  AA   ", "        ", "        "}, {"        ", "      F ", "   CC   ", "  CCCC  ", "  CCCC  ", "   CC   ", " F      ", "        "}, {"    FF  ", "        ", "        ", "   CC   ", "   CC   ", "        ", "        ", "  FF    "}, {"  FF    ", "        ", "        ", "   CC   ", "   CC   ", "        ", "        ", "    FF  "}, {"        ", " F      ", "        ", "   CC   ", "   CC   ", "        ", "      F ", "        "}, {" CCCCCC ", "CCCCCCCC", "CCCCCCCC", "CCCCCCCC", "CCCCCCCC", "CCCCCCCC", "CCCCCCCC", " CCCCCC "}})).addElement('F', GTStructureUtility.ofFrame(Materials.StellarAlloy)).addElement('C', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings8, (int)10)).addElement('A', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)5)).addElement('B', GTStructureUtility.buildHatchAdder(MTENanoForge.class).atLeast(HatchElement.InputHatch, HatchElement.OutputBus, HatchElement.InputBus, HatchElement.Maintenance, HatchElement.Energy.or(HatchElement.ExoticEnergy)).dot(1).casingIndex(((BlockCasings8)GregTechAPI.sBlockCasings8).getTextureIndex(10)).buildAndChain(GregTechAPI.sBlockCasings8, 10)).build();
    private byte mSpecialTier = 0;

    public MTENanoForge(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTENanoForge(String aName) {
        super(aName);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.nanoForgeRecipes;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 4, 37, 1);
        if (stackSize.field_77994_a > 1) {
            this.buildPiece(STRUCTURE_PIECE_TIER2, stackSize, hintsOnly, -7, 14, 4);
        }
        if (stackSize.field_77994_a > 2) {
            this.buildPiece(STRUCTURE_PIECE_TIER3, stackSize, hintsOnly, 14, 26, 4);
        }
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTENanoForge(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings8, 10)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings8, 10)), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings8, 10))};
    }

    @Override
    public IStructureDefinition<MTENanoForge> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GTRecipe recipe) {
                return recipe.mSpecialValue <= MTENanoForge.this.mSpecialTier ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.NO_RECIPE;
            }

            @Override
            @Nonnull
            protected OverclockCalculator createOverclockCalculator(@Nonnull GTRecipe recipe) {
                return super.createOverclockCalculator(recipe).setDurationDecreasePerOC(MTENanoForge.this.mSpecialTier > recipe.mSpecialValue ? 4.0 : 2.0);
            }
        };
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(this.getMaxInputEu());
        logic.setAvailableAmperage(1L);
        logic.setAmperageOC(false);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mUpdate <= -150) {
            this.mUpdate = 50;
        }
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mSpecialTier = 0;
        if (this.checkPiece(STRUCTURE_PIECE_MAIN, 4, 37, 1) && aStack != null) {
            if (aStack.func_77969_a(Materials.Carbon.getNanite(1))) {
                this.mSpecialTier = 1;
            }
            if (aStack.func_77969_a(Materials.Neutronium.getNanite(1)) && this.checkPiece(STRUCTURE_PIECE_TIER2, -7, 14, 4)) {
                this.mSpecialTier = (byte)2;
            }
            if (aStack.func_77969_a(MaterialsUEVplus.TranscendentMetal.getNanite(1)) && this.checkPiece(STRUCTURE_PIECE_TIER2, -7, 14, 4) && this.checkPiece(STRUCTURE_PIECE_TIER3, 14, 26, 4)) {
                this.mSpecialTier = (byte)3;
            }
        }
        if (this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        if (!this.checkExoticAndNormalEnergyHatches()) {
            return false;
        }
        return this.mSpecialTier > 0;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int built = this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 4, 37, 1, elementBudget, env, false, true);
        if (built >= 0) {
            return built;
        }
        if (stackSize.field_77994_a > 1) {
            built += this.survivialBuildPiece(STRUCTURE_PIECE_TIER2, stackSize, -7, 14, 4, elementBudget, env, false, true);
        }
        if (stackSize.field_77994_a > 2) {
            built += this.survivialBuildPiece(STRUCTURE_PIECE_TIER3, stackSize, 14, 26, 4, elementBudget, env, false, true);
        }
        return built;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("mSpecialTier", this.mSpecialTier);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_74764_b("mSeparate")) {
            this.inputSeparation = aNBT.func_74767_n("mSeparate");
        }
        this.mSpecialTier = aNBT.func_74771_c("mSpecialTier");
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        super.drawTexts(screenElements, inventorySlot);
        ((Column)screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.gui.button.tier") + " " + this.mSpecialTier).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.getBaseMetaTileEntity().getErrorDisplayID() == 0))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.mSpecialTier, val -> {
            this.mSpecialTier = (byte)(val % 127);
        }));
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Nanite Fabricator").addInfo("Requires insane amounts of power to create nanites. Each tier").addInfo("the multi gains a new building next to it. The nanite in the").addInfo("controller slot controls the tier.").addSeparator().addInfo("Requires a Carbon Nanite to use tier " + EnumChatFormatting.DARK_PURPLE + 1).addInfo("Requires a Neutronium Nanite to use tier " + EnumChatFormatting.DARK_PURPLE + 2).addInfo("Requires a Transcendent Metal Nanite to use tier " + EnumChatFormatting.DARK_PURPLE + 3).addSeparator().addInfo("If a recipe's tier is lower than the tier of the Nano Forge").addInfo("it gains " + EnumChatFormatting.RED + "perfect overclock" + EnumChatFormatting.GRAY + ".").addTecTechHatchInfo().beginStructureBlock(30, 38, 13, false).addStructureInfo("Tier " + EnumChatFormatting.DARK_PURPLE + 1 + EnumChatFormatting.GRAY).addStructureInfo(EnumChatFormatting.GOLD + "527" + EnumChatFormatting.GRAY + " Radiant Naquadah Alloy Casing").addStructureInfo(EnumChatFormatting.GOLD + "171" + EnumChatFormatting.GRAY + " Stellar Alloy Frame Box").addStructureInfo("").addStructureInfo("Tier " + EnumChatFormatting.DARK_PURPLE + 2 + EnumChatFormatting.GRAY).addStructureInfo(EnumChatFormatting.GOLD + "148" + EnumChatFormatting.GRAY + " Radiant Naquadah Alloy Casing").addStructureInfo(EnumChatFormatting.GOLD + "16" + EnumChatFormatting.GRAY + " Assembly Line Casing").addStructureInfo("").addStructureInfo("Tier " + EnumChatFormatting.DARK_PURPLE + 3 + EnumChatFormatting.GRAY).addStructureInfo(EnumChatFormatting.GOLD + "228" + EnumChatFormatting.GRAY + " Radiant Naquadah Alloy Casing").addStructureInfo(EnumChatFormatting.GOLD + "84" + EnumChatFormatting.GRAY + " Stellar Alloy Frame Box").addStructureInfo(EnumChatFormatting.GOLD + "16" + EnumChatFormatting.GRAY + " Assembly Line Casing").addStructureInfo("").addStructureInfo("Requires " + EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "-" + EnumChatFormatting.GOLD + "2" + EnumChatFormatting.GRAY + " energy hatches or " + EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " TT energy hatch.").addStructureInfo("Requires " + EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + " maintenance hatch.").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + "+" + EnumChatFormatting.GRAY + " input hatches.").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 0 + EnumChatFormatting.GRAY + "+" + EnumChatFormatting.GRAY + " output hatches.").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + "+" + EnumChatFormatting.GRAY + " input busses.").addStructureInfo("Requires " + EnumChatFormatting.GOLD + 1 + EnumChatFormatting.GRAY + "+" + EnumChatFormatting.GRAY + " output busses.").toolTipFinisher(GTValues.AuthorBlueWeabo);
        return tt;
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.inputSeparation = !this.inputSeparation;
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.separatebus") + " " + this.inputSeparation);
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        boolean bl = this.batchMode = !this.batchMode;
        if (this.batchMode) {
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
        } else {
            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
        }
        return true;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }
}

