/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.GTMod;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.maps.LargeBoilerFuelBackend;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class MTELargeBoiler
extends MTEEnhancedMultiBlockBase<MTELargeBoiler>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final ClassValue<IStructureDefinition<MTELargeBoiler>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<MTELargeBoiler>>(){

        @Override
        protected IStructureDefinition<MTELargeBoiler> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(MTELargeBoiler.STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"ccc", "ccc", "ccc"}, {"ccc", "cPc", "ccc"}, {"ccc", "cPc", "ccc"}, {"ccc", "cPc", "ccc"}, {"f~f", "fff", "fff"}})).addElement('P', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getPipeBlock(), (int)t.getPipeMeta()))).addElement('c', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder(MTELargeBoiler.class).atLeast(HatchElement.OutputHatch).casingIndex(t.getCasingTextureIndex()).dot(2).buildAndChain(StructureUtility.onElementPass(rec$ -> ((MTELargeBoiler)rec$).onCasingAdded(), (IStructureElement)StructureUtility.ofBlock((Block)t.getCasingBlock(), (int)t.getCasingMeta()))))).addElement('f', (IStructureElement)StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder(MTELargeBoiler.class).atLeast(HatchElement.Maintenance, HatchElement.InputHatch, HatchElement.InputBus, HatchElement.Muffler).casingIndex(t.getFireboxTextureIndex()).dot(1).buildAndChain(StructureUtility.onElementPass(rec$ -> ((MTELargeBoiler)rec$).onFireboxAdded(), (IStructureElement)StructureUtility.ofBlock((Block)t.getFireboxBlock(), (int)t.getFireboxMeta()))))).build();
        }
    };
    private boolean firstRun = true;
    private int mSuperEfficencyIncrease = 0;
    private int integratedCircuitConfig = 0;
    private int excessWater = 0;
    private int excessFuel = 0;
    private int excessProjectedEU = 0;
    private int mCasingAmount;
    private int mFireboxAmount;
    protected int pollutionPerSecond = 1;
    private final int superToNormalSteam = 3;

    public MTELargeBoiler(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargeBoiler(String aName) {
        super(aName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Boiler");
        if (this.isSuperheated()) {
            tt.addInfo("Produces " + GTUtility.formatNumbers((float)(this.getEUt() * 40) * ((float)this.runtimeBoost(20) / 20.0f / 3.0f)) + "L of Superheated Steam with 1 Coal at " + GTUtility.formatNumbers((long)this.getEUt() * 40L / 3L) + "L/s").addInfo("A programmed circuit in the main block throttles the boiler (-1000L/s per config)").addInfo("Only some solid fuels are allowed (check the NEI Large Boiler tab for details)").addInfo("If there are any disallowed fuels in the input bus, the boiler won't run!");
        } else {
            tt.addInfo("Produces " + GTUtility.formatNumbers((float)(this.getEUt() * 40) * ((float)this.runtimeBoost(20) / 20.0f)) + "L of Steam with 1 Coal at " + GTUtility.formatNumbers((long)this.getEUt() * 40L) + "L/s").addInfo("A programmed circuit in the main block throttles the boiler (-1000L/s per config)").addInfo("Solid Fuels with a burn value that is too high or too low will not work");
        }
        tt.addInfo(String.format("Diesel fuels have 1/4 efficiency - Takes %s seconds to heat up", GTUtility.formatNumbers(500.0 / (double)this.getEfficiencyIncrease()))).addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 5, 3, false).addController("Front bottom").addCasingInfoRange(this.getCasingMaterial() + " " + this.getCasingBlockType() + " Casing", 24, 31, false).addOtherStructurePart(this.getCasingMaterial() + " Fire Boxes", "Bottom layer, 3 minimum").addOtherStructurePart(this.getCasingMaterial() + " Pipe Casing Blocks", "Inner 3 blocks").addMaintenanceHatch("Any firebox", 1).addMufflerHatch("Any firebox", 1).addInputBus("Solid fuel, Any firebox", 1).addInputHatch("Liquid fuel, Any firebox", 1).addStructureInfo("You can use either, or both").addInputHatch("Water, Any firebox", 1).addOutputHatch("Steam, any casing", 2).toolTipFinisher(new String[0]);
        return tt;
    }

    public abstract String getCasingMaterial();

    public abstract Block getCasingBlock();

    public abstract String getCasingBlockType();

    public abstract byte getCasingMeta();

    public abstract byte getCasingTextureIndex();

    public abstract Block getPipeBlock();

    public abstract byte getPipeMeta();

    public abstract Block getFireboxBlock();

    public abstract byte getFireboxMeta();

    public abstract byte getFireboxTextureIndex();

    public abstract int getEUt();

    public abstract int getEfficiencyIncrease();

    public int getIntegratedCircuitConfig() {
        return this.integratedCircuitConfig;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return Math.max(0, (int)((double)this.pollutionPerSecond * (1.0 - GTMod.gregtechproxy.mPollutionReleasedByThrottle * (double)this.getIntegratedCircuitConfig())));
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureIndex()), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureIndex()), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.getCasingTextureIndex())};
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    boolean isFuelValid() {
        if (!this.isSuperheated()) {
            return true;
        }
        for (ItemStack input : this.getStoredInputs()) {
            if (LargeBoilerFuelBackend.isAllowedSolidFuel(input) || ItemList.Circuit_Integrated.isStackEqual(input, true, true)) continue;
            this.mMaxProgresstime = 0;
            this.mEUt = 0;
            return false;
        }
        return true;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.largeBoilerFakeFuels;
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        ArrayList<ItemStack> tInputList;
        if (!this.isFuelValid()) {
            return CheckRecipeResultRegistry.NO_FUEL_FOUND;
        }
        if (ItemList.Circuit_Integrated.isStackEqual(this.mInventory[1], true, true)) {
            int circuit_config = this.mInventory[1].func_77960_j();
            if (circuit_config >= 1 && circuit_config <= 25) {
                this.integratedCircuitConfig = circuit_config;
            }
        } else {
            this.integratedCircuitConfig = 0;
        }
        this.mSuperEfficencyIncrease = 0;
        if (!this.isSuperheated()) {
            FluidStack tFluid;
            for (GTRecipe tRecipe : RecipeMaps.dieselFuels.getAllRecipes()) {
                tFluid = GTUtility.getFluidForFilledItem(tRecipe.getRepresentativeInput(0), true);
                if (tFluid == null || tRecipe.mSpecialValue <= 1) continue;
                tFluid.amount = 1000;
                if (!this.depleteInput(tFluid)) continue;
                this.mEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease() * 4;
                this.mMaxProgresstime = this.adjustBurnTimeForConfig(this.runtimeBoost(tRecipe.mSpecialValue / 2));
                this.mEUt = this.adjustEUtForConfig(this.getEUt());
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
            for (GTRecipe tRecipe : RecipeMaps.denseLiquidFuels.getAllRecipes()) {
                tFluid = GTUtility.getFluidForFilledItem(tRecipe.getRepresentativeInput(0), true);
                if (tFluid == null) continue;
                tFluid.amount = 1000;
                if (!this.depleteInput(tFluid)) continue;
                this.mEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease();
                this.mMaxProgresstime = this.adjustBurnTimeForConfig(Math.max(1, this.runtimeBoost(tRecipe.mSpecialValue * 2)));
                this.mEUt = this.adjustEUtForConfig(this.getEUt());
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        }
        if (!(tInputList = this.getStoredInputs()).isEmpty()) {
            if (this.isSuperheated()) {
                for (ItemStack tInput : tInputList) {
                    if (tInput == GTOreDictUnificator.get(OrePrefixes.bucket, Materials.Lava, 1L) || GTUtility.getFluidForFilledItem(tInput, true) != null || (this.mMaxProgresstime = GTModHandler.getFuelValue(tInput) / 80) <= 0) continue;
                    this.excessFuel += GTModHandler.getFuelValue(tInput) % 80;
                    this.mMaxProgresstime += this.excessFuel / 80;
                    this.excessFuel %= 80;
                    this.mEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease();
                    this.mMaxProgresstime = this.adjustBurnTimeForConfig(this.runtimeBoost(this.mMaxProgresstime));
                    this.mEUt = this.adjustEUtForConfig(this.getEUt());
                    this.mOutputItems = new ItemStack[]{GTUtility.getContainerItem(tInput, true)};
                    --tInput.field_77994_a;
                    this.updateSlots();
                    if (this.mEfficiencyIncrease > 5000) {
                        this.mEfficiencyIncrease = 0;
                        this.mSuperEfficencyIncrease = 20;
                    }
                    return CheckRecipeResultRegistry.SUCCESSFUL;
                }
            } else {
                for (ItemStack tInput : tInputList) {
                    if (tInput == GTOreDictUnificator.get(OrePrefixes.bucket, Materials.Lava, 1L) || GTUtility.getFluidForFilledItem(tInput, true) != null || (this.mMaxProgresstime = GTModHandler.getFuelValue(tInput) / 80) <= 0 || (long)GTModHandler.getFuelValue(tInput) * 2L / (long)this.getEUt() <= 1L) continue;
                    this.excessFuel += GTModHandler.getFuelValue(tInput) % 80;
                    this.mMaxProgresstime += this.excessFuel / 80;
                    this.excessFuel %= 80;
                    this.mEfficiencyIncrease = this.mMaxProgresstime * this.getEfficiencyIncrease();
                    this.mMaxProgresstime = this.adjustBurnTimeForConfig(this.runtimeBoost(this.mMaxProgresstime));
                    this.mEUt = this.adjustEUtForConfig(this.getEUt());
                    this.mOutputItems = new ItemStack[]{GTUtility.getContainerItem(tInput, true)};
                    --tInput.field_77994_a;
                    this.updateSlots();
                    if (this.mEfficiencyIncrease > 5000) {
                        this.mEfficiencyIncrease = 0;
                        this.mSuperEfficencyIncrease = 20;
                    }
                    return CheckRecipeResultRegistry.SUCCESSFUL;
                }
            }
        }
        this.mMaxProgresstime = 0;
        this.mEUt = 0;
        return CheckRecipeResultRegistry.NO_FUEL_FOUND;
    }

    abstract int runtimeBoost(int var1);

    abstract boolean isSuperheated();

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt > 0) {
            int tGeneratedEU;
            int maxEff = this.getCorrectedMaxEfficiency(this.mInventory[1]);
            if (this.mSuperEfficencyIncrease > 0 && this.mEfficiency < maxEff) {
                this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mSuperEfficencyIncrease, maxEff));
            }
            if ((tGeneratedEU = (int)((long)this.mEUt * 2L * (long)this.mEfficiency / 10000L)) > 0) {
                long amount = (tGeneratedEU + 160) / 160;
                this.excessWater = (int)((long)this.excessWater + (amount * 160L - (long)tGeneratedEU));
                amount -= (long)(this.excessWater / 160);
                this.excessWater %= 160;
                this.startRecipeProcessing();
                if (this.isSuperheated()) {
                    if (this.depleteInput(Materials.Water.getFluid(amount / 3L)) || this.depleteInput(GTModHandler.getDistilledWater(amount / 3L))) {
                        this.addOutput(FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)(tGeneratedEU / 3)));
                    } else {
                        GTLog.exp.println("Boiler " + this.mName + " had no Water!");
                        this.explodeMultiblock();
                    }
                } else if (this.depleteInput(Materials.Water.getFluid(amount)) || this.depleteInput(GTModHandler.getDistilledWater(amount))) {
                    this.addOutput(GTModHandler.getSteam(tGeneratedEU));
                } else {
                    GTLog.exp.println("Boiler " + this.mName + " had no Water!");
                    this.explodeMultiblock();
                }
                this.endRecipeProcessing();
            }
            return true;
        }
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("excessFuel", this.excessFuel);
        aNBT.func_74768_a("excessWater", this.excessWater);
        aNBT.func_74768_a("excessProjectedEU", this.excessProjectedEU);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.excessFuel = aNBT.func_74762_e("excessFuel");
        this.excessWater = aNBT.func_74762_e("excessWater");
        this.excessProjectedEU = aNBT.func_74762_e("excessProjectedEU");
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.mProgresstime > 0 && this.firstRun) {
            this.firstRun = false;
            GTMod.achievements.issueAchievement(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), "extremepressure");
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public IStructureDefinition<MTELargeBoiler> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    private void onFireboxAdded() {
        ++this.mFireboxAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasingAmount = 0;
        this.mFireboxAmount = 0;
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 4, 0) && this.mCasingAmount >= 24 && this.mFireboxAmount >= 3 && this.mMaintenanceHatches.size() == 1 && !this.mMufflerHatches.isEmpty();
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private int adjustEUtForConfig(int rawEUt) {
        int adjustedSteamOutput = rawEUt - (this.isSuperheated() ? 75 : 25) * this.integratedCircuitConfig;
        return Math.max(adjustedSteamOutput, 25);
    }

    private int getCorrectedMaxEfficiency(ItemStack itemStack) {
        return this.getMaxEfficiency(itemStack) - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
    }

    private int adjustBurnTimeForConfig(int rawBurnTime) {
        if (this.mEfficiencyIncrease <= 5000 && this.mEfficiency < this.getCorrectedMaxEfficiency(this.mInventory[1])) {
            return rawBurnTime;
        }
        int adjustedEUt = Math.max(25, this.getEUt() - (this.isSuperheated() ? 75 : 25) * this.integratedCircuitConfig);
        int adjustedBurnTime = (int)((long)rawBurnTime * (long)this.getEUt() / (long)adjustedEUt);
        this.excessProjectedEU += this.getEUt() * rawBurnTime - adjustedEUt * adjustedBurnTime;
        this.excessProjectedEU %= adjustedEUt;
        return adjustedBurnTime += this.excessProjectedEU / adjustedEUt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 4, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 1, 4, 0, elementBudget, env, false, true);
    }
}

