/*
 * Decompiled with CFR 0.152.
 */
package gregtech;

import appeng.api.AEApi;
import com.google.common.base.Stopwatch;
import com.google.common.collect.SetMultimap;
import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import galacticgreg.SpaceDimRegisterer;
import gregtech.api.GregTechAPI;
import gregtech.api.enchants.EnchantmentEnderDamage;
import gregtech.api.enchants.EnchantmentHazmat;
import gregtech.api.enchants.EnchantmentRadioactivity;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.interfaces.internal.IGTMod;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.objects.XSTR;
import gregtech.api.registries.LHECoolantRegistry;
import gregtech.api.threads.RunnableMachineUpdate;
import gregtech.api.util.AssemblyLineServer;
import gregtech.api.util.GTForestryCompat;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeRegistrator;
import gregtech.api.util.GTSpawnEventHandler;
import gregtech.api.util.GTUtility;
import gregtech.common.GTDummyWorld;
import gregtech.common.GTNetwork;
import gregtech.common.GTProxy;
import gregtech.common.RecipeAdder;
import gregtech.common.config.Client;
import gregtech.common.config.Gregtech;
import gregtech.common.config.MachineStats;
import gregtech.common.config.OPStuff;
import gregtech.common.config.Other;
import gregtech.common.config.Worldgen;
import gregtech.common.covers.CoverFacadeAE;
import gregtech.common.misc.GTCommand;
import gregtech.common.misc.spaceprojects.commands.SPCommand;
import gregtech.common.misc.spaceprojects.commands.SPMCommand;
import gregtech.common.misc.spaceprojects.commands.SpaceProjectCommand;
import gregtech.common.tileentities.machines.MTEHatchCraftingInputME;
import gregtech.common.tileentities.storage.MTEDigitalChestBase;
import gregtech.crossmod.holoinventory.HoloInventory;
import gregtech.crossmod.waila.Waila;
import gregtech.loaders.load.CoverBehaviorLoader;
import gregtech.loaders.load.FuelLoader;
import gregtech.loaders.load.GTItemIterator;
import gregtech.loaders.load.MTERecipeLoader;
import gregtech.loaders.load.SonictronLoader;
import gregtech.loaders.misc.CoverLoader;
import gregtech.loaders.misc.GTAchievements;
import gregtech.loaders.misc.GTBees;
import gregtech.loaders.postload.BlockResistanceLoader;
import gregtech.loaders.postload.BookAndLootLoader;
import gregtech.loaders.postload.CraftingRecipeLoader;
import gregtech.loaders.postload.CropLoader;
import gregtech.loaders.postload.FakeRecipeLoader;
import gregtech.loaders.postload.GTPostLoad;
import gregtech.loaders.postload.GTWorldgenloader;
import gregtech.loaders.postload.ItemMaxStacksizeLoader;
import gregtech.loaders.postload.MachineRecipeLoader;
import gregtech.loaders.postload.MachineTooltipsLoader;
import gregtech.loaders.postload.MinableRegistrator;
import gregtech.loaders.postload.PosteaTransformers;
import gregtech.loaders.postload.RecyclerBlacklistLoader;
import gregtech.loaders.postload.ScrapboxDropLoader;
import gregtech.loaders.preload.GTPreLoad;
import gregtech.loaders.preload.GT_Loader_MultiTileEntities;
import gregtech.loaders.preload.LoaderCircuitBehaviors;
import gregtech.loaders.preload.LoaderGTBlockFluid;
import gregtech.loaders.preload.LoaderGTItemData;
import gregtech.loaders.preload.LoaderGTOreDictionary;
import gregtech.loaders.preload.LoaderMetaTileEntities;
import gregtech.loaders.preload.LoaderOreProcessing;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="gregtech", name="GregTech", version="MC1710", guiFactory="gregtech.client.GTGuiFactory", dependencies=" required-after:IC2; required-after:structurelib; required-after:gtnhlib@[0.2.1,); required-after:modularui@[1.1.12,); required-after:appliedenergistics2@[rv3-beta-258,); after:dreamcraft; after:Forestry; after:PFAAGeologica; after:Thaumcraft; after:Railcraft; after:ThermalExpansion; after:TwilightForest; after:harvestcraft; after:magicalcrops; after:Botania; after:BuildCraft|Transport; after:BuildCraft|Silicon; after:BuildCraft|Factory; after:BuildCraft|Energy; after:BuildCraft|Core; after:BuildCraft|Builders; after:GalacticraftCore; after:GalacticraftMars; after:GalacticraftPlanets; after:ThermalExpansion|Transport; after:ThermalExpansion|Energy; after:ThermalExpansion|Factory; after:RedPowerCore; after:RedPowerBase; after:RedPowerMachine; after:RedPowerCompat; after:RedPowerWiring; after:RedPowerLogic; after:RedPowerLighting; after:RedPowerWorld; after:RedPowerControl; after:UndergroundBiomes; after:TConstruct; after:Translocator; after:gendustry;")
public class GTMod
implements IGTMod {
    public static final int NBT_VERSION;
    @Mod.Instance(value="gregtech")
    public static GTMod instance;
    @SidedProxy(modId="gregtech", clientSide="gregtech.common.GTClient", serverSide="gregtech.common.GTServer")
    public static GTProxy gregtechproxy;
    public static final boolean DEBUG;
    public static GTAchievements achievements;
    @Deprecated
    public static final String aTextGeneral = "general";
    public static final String aTextIC2 = "ic2_";
    public static final Logger GT_FML_LOGGER;

    public GTMod() {
        int i;
        GTValues.GT = this;
        GTValues.DW = new GTDummyWorld();
        GTValues.NW = new GTNetwork();
        GTValues.RA = new RecipeAdder();
        for (i = 0; i < 4; ++i) {
            GregTechAPI.registerTileEntityConstructor(i, i2 -> GregTechAPI.constructBaseMetaTileEntity());
        }
        for (i = 4; i < 12; ++i) {
            GregTechAPI.registerTileEntityConstructor(i, i2 -> new BaseMetaPipeEntity());
        }
        GregTechAPI.sRecipeAdder = GTValues.RA;
        Textures.BlockIcons.VOID.name();
        Textures.ItemIcons.VOID.name();
    }

    public static int calculateTotalGTVersion(int majorVersion, int minorVersion) {
        return GTMod.calculateTotalGTVersion(majorVersion, minorVersion, 0);
    }

    public static int calculateTotalGTVersion(int majorVersion, int minorVersion, int patchVersion) {
        return majorVersion * 1000000 + minorVersion * 1000 + patchVersion;
    }

    @Mod.EventHandler
    public void onPreLoad(FMLPreInitializationEvent aEvent) {
        Locale.setDefault(Locale.ENGLISH);
        if (GregTechAPI.sPreloadStarted) {
            return;
        }
        for (Runnable tRunnable : GregTechAPI.sBeforeGTPreload) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GTLog.err);
            }
        }
        GTPreLoad.getConfiguration(aEvent.getModConfigurationDirectory());
        GTPreLoad.createLogFiles(aEvent.getModConfigurationDirectory().getParentFile());
        gregtechproxy.onPreLoad();
        GTLog.out.println("GTMod: Setting Configs");
        GTPreLoad.loadConfig();
        new EnchantmentHazmat();
        new EnchantmentEnderDamage();
        new EnchantmentRadioactivity();
        Materials.init();
        GTPreLoad.initLocalization(aEvent.getModConfigurationDirectory().getParentFile());
        GTPreLoad.adjustScrap();
        AEApi.instance().registries().interfaceTerminal().register(MTEHatchCraftingInputME.class);
        GTPreLoad.runMineTweakerCompat();
        new LoaderOreProcessing().run();
        new LoaderGTOreDictionary().run();
        new LoaderGTItemData().run();
        new LoaderGTBlockFluid().run();
        new LoaderMetaTileEntities().run();
        if (GTValues.enableMultiTileEntities) {
            new GT_Loader_MultiTileEntities().run();
        }
        new LoaderCircuitBehaviors().run();
        new CoverBehaviorLoader().run();
        new SonictronLoader().run();
        new GTSpawnEventHandler();
        GTRecipe.setItemStacks();
        GTPreLoad.sortToTheEnd();
        GregTechAPI.sPreloadFinished = true;
        GTLog.out.println("GTMod: Preload-Phase finished!");
        GTLog.ore.println("GTMod: Preload-Phase finished!");
        GTUIInfos.init();
        for (Runnable tRunnable : GregTechAPI.sAfterGTPreload) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GTLog.err);
            }
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            AssemblyLineServer.fillMap(aEvent);
        }
    }

    @Mod.EventHandler
    public void onLoad(FMLInitializationEvent aEvent) {
        if (GregTechAPI.sLoadStarted) {
            return;
        }
        for (Runnable tRunnable : GregTechAPI.sBeforeGTLoad) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GTLog.err);
            }
        }
        if (Mods.Forestry.isModLoaded()) {
            new GTBees();
        }
        if (!GTMod.gregtechproxy.mEnableCleanroom) {
            GTMod.gregtechproxy.mLowGravProcessing = false;
        }
        gregtechproxy.onLoad();
        GregTechAPI.registerCircuitProgrammer(new Predicate<ItemStack>(){
            private final int screwdriverOreId = OreDictionary.getOreID((String)"craftingToolScrewdriver");

            @Override
            public boolean test(ItemStack stack) {
                for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
                    if (i != this.screwdriverOreId) continue;
                    return true;
                }
                return false;
            }
        }, true);
        new MTERecipeLoader().run();
        new GTItemIterator().run();
        gregtechproxy.registerUnificationEntries();
        new FuelLoader().run();
        if (Mods.Waila.isModLoaded()) {
            Waila.init();
        }
        if (Mods.HoloInventory.isModLoaded()) {
            HoloInventory.init();
        }
        LHECoolantRegistry.registerBaseCoolants();
        GT_FML_LOGGER.debug("Registering SpaceDimensions");
        SpaceDimRegisterer.register();
        GregTechAPI.sLoadFinished = true;
        GTLog.out.println("GTMod: Load-Phase finished!");
        GTLog.ore.println("GTMod: Load-Phase finished!");
        for (Runnable tRunnable : GregTechAPI.sAfterGTLoad) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GTLog.err);
            }
        }
    }

    @Mod.EventHandler
    public void onPostLoad(FMLPostInitializationEvent aEvent) {
        if (GregTechAPI.sPostloadStarted) {
            return;
        }
        for (Runnable tRunnable : GregTechAPI.sBeforeGTPostload) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GTLog.err);
            }
        }
        gregtechproxy.onPostLoad();
        if (DEBUG) {
            int bound = GregTechAPI.METATILEENTITIES.length;
            for (int i1 = 1; i1 < bound; ++i1) {
                if (GregTechAPI.METATILEENTITIES[i1] == null) continue;
                GTLog.out.printf("META %d %s\n", i1, GregTechAPI.METATILEENTITIES[i1].getMetaName());
            }
        }
        gregtechproxy.registerUnificationEntries();
        new BookAndLootLoader().run();
        new ItemMaxStacksizeLoader().run();
        new BlockResistanceLoader().run();
        new RecyclerBlacklistLoader().run();
        new MinableRegistrator().run();
        new FakeRecipeLoader().run();
        new MachineRecipeLoader().run();
        new ScrapboxDropLoader().run();
        new CropLoader().run();
        new GTWorldgenloader().run();
        new CoverLoader().run();
        GTRecipeRegistrator.registerUsagesForMaterials(null, false, new ItemStack(Blocks.field_150344_f, 1), new ItemStack(Blocks.field_150347_e, 1), new ItemStack(Blocks.field_150348_b, 1), new ItemStack(Items.field_151116_aA, 1));
        GTOreDictUnificator.addItemData(GTModHandler.getRecipeOutput(null, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Tin, 1L), null, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Tin, 1L), null, GTOreDictUnificator.get(OrePrefixes.ingot, Materials.Tin, 1L), null, null, null), new ItemData(Materials.Tin, 10886400L, new MaterialStack[0]));
        GTModHandler.removeRecipe(new ItemStack(Items.field_151114_aO, 1), new ItemStack(Items.field_151114_aO, 1), null, new ItemStack(Items.field_151114_aO, 1), new ItemStack(Items.field_151114_aO, 1));
        GTModHandler.removeRecipeDelayed(new ItemStack((Block)Blocks.field_150376_bx, 1, 0), new ItemStack((Block)Blocks.field_150376_bx, 1, 1), new ItemStack((Block)Blocks.field_150376_bx, 1, 2));
        GTModHandler.addCraftingRecipe(new ItemStack((Block)Blocks.field_150376_bx, 6, 0), GTModHandler.RecipeBits.NOT_REMOVABLE | GTModHandler.RecipeBits.BUFFERED, new Object[]{"WWW", Character.valueOf('W'), new ItemStack(Blocks.field_150344_f, 1, 0)});
        Map<IRecipeInput, RecipeOutput> aMaceratorRecipeList = GTModHandler.getMaceratorRecipeList();
        Map<IRecipeInput, RecipeOutput> aCompressorRecipeList = GTModHandler.getCompressorRecipeList();
        Map<IRecipeInput, RecipeOutput> aExtractorRecipeList = GTModHandler.getExtractorRecipeList();
        Map<IRecipeInput, RecipeOutput> aOreWashingRecipeList = GTModHandler.getOreWashingRecipeList();
        Map<IRecipeInput, RecipeOutput> aThermalCentrifugeRecipeList = GTModHandler.getThermalCentrifugeRecipeList();
        GTLog.out.println("GTMod: Activating OreDictionary Handler, this can take some time, as it scans the whole OreDictionary");
        GT_FML_LOGGER.info("If your Log stops here, you were too impatient. Wait a bit more next time, before killing Minecraft with the Task Manager.");
        GTPostLoad.activateOreDictHandler();
        GTPostLoad.replaceVanillaMaterials();
        GTPostLoad.removeIc2Recipes(aMaceratorRecipeList, aCompressorRecipeList, aExtractorRecipeList, aOreWashingRecipeList, aThermalCentrifugeRecipeList);
        if (GTValues.D1) {
            GTModHandler.sSingleNonBlockDamagableRecipeList.forEach(iRecipe -> GTLog.out.println("=> " + iRecipe.func_77571_b().func_82833_r()));
        }
        new CraftingRecipeLoader().run();
        GTModHandler.removeRecipeByOutput(ItemList.IC2_ForgeHammer.getWildcard(1L, new Object[0]));
        GTModHandler.removeRecipeByOutput(GTModHandler.getIC2Item("machine", 1L));
        GTModHandler.addCraftingRecipe(GTModHandler.getIC2Item("machine", 1L), GTModHandler.RecipeBits.BUFFERED | GTModHandler.RecipeBits.NOT_REMOVABLE | GTModHandler.RecipeBits.REVERSIBLE, new Object[]{"RRR", "RwR", "RRR", Character.valueOf('R'), OrePrefixes.plate.get(Materials.Iron)});
        GTPostLoad.registerFluidCannerRecipes();
        if (Mods.Forestry.isModLoaded()) {
            GTForestryCompat.transferCentrifugeRecipes();
            GTForestryCompat.transferSqueezerRecipes();
        }
        MTEDigitalChestBase.registerAEIntegration();
        ItemStack facade = (ItemStack)AEApi.instance().definitions().items().facade().maybeItem().transform(i -> new ItemStack(i, 1, Short.MAX_VALUE)).orNull();
        if (facade != null) {
            GregTechAPI.registerCover(facade, null, new CoverFacadeAE());
        }
        Arrays.stream(new String[]{"blastfurnace", "blockcutter", "inductionFurnace", "generator", "windMill", "waterMill", "solarPanel", "centrifuge", "electrolyzer", "compressor", "electroFurnace", "extractor", "macerator", "recycler", "metalformer", "orewashingplant", "massFabricator", "replicator"}).map(tName -> GTModHandler.getIC2Item(tName, 1L)).forEach(GTModHandler::removeRecipeByOutputDelayed);
        GTPostLoad.nerfVanillaTools();
        new PosteaTransformers().run();
        Stopwatch stopwatch = Stopwatch.createStarted();
        GTLog.out.println("GTMod: Adding buffered Recipes.");
        GTModHandler.stopBufferingCraftingRecipes();
        GT_FML_LOGGER.info("Executed delayed Crafting Recipes (" + stopwatch.stop() + "). Have a Cake.");
        GTLog.out.println("GTMod: Saving Lang File.");
        new MachineTooltipsLoader().run();
        GTLanguageManager.sEnglishFile.save();
        GregTechAPI.sPostloadFinished = true;
        GTLog.out.println("GTMod: PostLoad-Phase finished!");
        GTLog.ore.println("GTMod: PostLoad-Phase finished!");
        for (Runnable tRunnable : GregTechAPI.sAfterGTPostload) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GTLog.err);
            }
        }
        GTPostLoad.addFakeRecipes();
        if (GregTechAPI.mOutputRF || GregTechAPI.mInputRF) {
            GTUtility.checkAvailabilities();
            if (!GTUtility.RF_CHECK) {
                GregTechAPI.mOutputRF = false;
                GregTechAPI.mInputRF = false;
            }
        }
        GTPostLoad.addSolidFakeLargeBoilerFuels();
        GTPostLoad.identifyAnySteam();
        achievements = new GTAchievements();
        GTRecipe.GTppRecipeHelper = true;
        GTLog.out.println("GTMod: Loading finished, de-allocating temporary Init Variables.");
        GregTechAPI.sBeforeGTPreload = null;
        GregTechAPI.sAfterGTPreload = null;
        GregTechAPI.sBeforeGTLoad = null;
        GregTechAPI.sAfterGTLoad = null;
        GregTechAPI.sBeforeGTPostload = null;
        GregTechAPI.sAfterGTPostload = null;
        GTPostLoad.createGTtoolsCreativeTab();
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent aEvent) {
        gregtechproxy.onLoadComplete();
        for (Runnable tRunnable : GregTechAPI.sGTCompleteLoad) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GTLog.err);
            }
        }
        GregTechAPI.sGTCompleteLoad = null;
        GregTechAPI.sFullLoadFinished = true;
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartedEvent aEvent) {
        gregtechproxy.onServerStarted();
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent aEvent) {
        gregtechproxy.onServerAboutToStart();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent aEvent) {
        for (Runnable tRunnable : GregTechAPI.sBeforeGTServerstart) {
            try {
                tRunnable.run();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(GTLog.err);
            }
        }
        gregtechproxy.onServerStarting();
        GTModHandler.removeAllIC2Recipes();
        GTLog.out.println("GTMod: Unificating outputs of all known Recipe Types.");
        ArrayList<Object> tStacks = new ArrayList<Object>(10000);
        GTLog.out.println("GTMod: IC2 Machines");
        Recipes.cannerBottle.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.centrifuge.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.compressor.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.extractor.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.macerator.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.metalformerCutting.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.metalformerExtruding.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.metalformerRolling.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.matterAmplifier.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        Recipes.oreWashing.getRecipes().values().stream().map(t -> t.items).forEach(tStacks::addAll);
        GTLog.out.println("GTMod: Dungeon Loot");
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"dungeonChest").getItems((Random)new XSTR())) {
            tStacks.add(tContent.field_76297_b);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"bonusChest").getItems((Random)new XSTR())) {
            tStacks.add(tContent.field_76297_b);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"villageBlacksmith").getItems((Random)new XSTR())) {
            tStacks.add(tContent.field_76297_b);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"strongholdCrossing").getItems((Random)new XSTR())) {
            tStacks.add(tContent.field_76297_b);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"strongholdLibrary").getItems((Random)new XSTR())) {
            tStacks.add(tContent.field_76297_b);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"strongholdCorridor").getItems((Random)new XSTR())) {
            tStacks.add(tContent.field_76297_b);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"pyramidJungleDispenser").getItems((Random)new XSTR())) {
            tStacks.add(tContent.field_76297_b);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"pyramidJungleChest").getItems((Random)new XSTR())) {
            tStacks.add(tContent.field_76297_b);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"pyramidDesertyChest").getItems((Random)new XSTR())) {
            tStacks.add(tContent.field_76297_b);
        }
        for (WeightedRandomChestContent tContent : ChestGenHooks.getInfo((String)"mineshaftCorridor").getItems((Random)new XSTR())) {
            tStacks.add(tContent.field_76297_b);
        }
        GTLog.out.println("GTMod: Smelting");
        tStacks.addAll(FurnaceRecipes.func_77602_a().func_77599_b().values());
        if (GTMod.gregtechproxy.mCraftingUnification) {
            GTLog.out.println("GTMod: Crafting Recipes");
            for (IRecipe iRecipe : CraftingManager.func_77594_a().func_77592_b()) {
                if (!(iRecipe instanceof IRecipe)) continue;
                tStacks.add(iRecipe.func_77571_b());
            }
        }
        for (ItemStack itemStack : tStacks) {
            if (!GTMod.gregtechproxy.mRegisteredOres.contains(itemStack)) {
                GTOreDictUnificator.setStack(itemStack);
                continue;
            }
            GTMod.logMultilineError(GT_FML_LOGGER, GTMod.generateGTErr01Message(itemStack));
            itemStack.func_151001_c("ERROR! PLEASE CHECK YOUR LOG FOR 'GT-ERR-01'!");
        }
        GregTechAPI.mServerStarted = true;
        GTLog.out.println("GTMod: ServerStarting-Phase finished!");
        GTLog.ore.println("GTMod: ServerStarting-Phase finished!");
        for (Runnable runnable : GregTechAPI.sAfterGTServerstart) {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GTLog.err);
            }
        }
        aEvent.registerServerCommand((ICommand)new GTCommand());
        aEvent.registerServerCommand((ICommand)new SPCommand());
        aEvent.registerServerCommand((ICommand)new SPMCommand());
        aEvent.registerServerCommand((ICommand)new SpaceProjectCommand());
        RunnableMachineUpdate.initExecutorService();
    }

    @Override
    public boolean isServerSide() {
        return gregtechproxy.isServerSide();
    }

    @Override
    public boolean isClientSide() {
        return gregtechproxy.isClientSide();
    }

    @Override
    public boolean isBukkitSide() {
        return gregtechproxy.isBukkitSide();
    }

    @Override
    public EntityPlayer getThePlayer() {
        return gregtechproxy.getThePlayer();
    }

    @Override
    public int addArmor(String aArmorPrefix) {
        return gregtechproxy.addArmor(aArmorPrefix);
    }

    @Override
    public void doSonictronSound(ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        gregtechproxy.doSonictronSound(aStack, aWorld, aX, aY, aZ);
    }

    @Mod.EventHandler
    public void onIDChangingEvent(FMLModIdMappingEvent aEvent) {
        GTUtility.reInit();
        GTRecipe.reInit();
        try {
            for (Map<?, ?> map : GregTechAPI.sItemStackMappings) {
                GTUtility.reMap(map);
            }
            for (SetMultimap setMultimap : GregTechAPI.itemStackMultiMaps) {
                GTUtility.reMap(setMultimap);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GTLog.err);
        }
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent aEvent) {
        for (Runnable tRunnable : GregTechAPI.sBeforeGTServerstop) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GTLog.err);
            }
        }
        gregtechproxy.onServerStopping();
        for (Runnable tRunnable : GregTechAPI.sAfterGTServerstop) {
            try {
                tRunnable.run();
            }
            catch (Throwable e) {
                e.printStackTrace(GTLog.err);
            }
        }
        RunnableMachineUpdate.shutdownExecutorService();
    }

    public static void logStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        GT_FML_LOGGER.error((Object)sw);
    }

    private static String[] generateGTErr01Message(ItemStack stack) {
        return new String[]{"GT-ERR-01 at " + stack.func_77977_a() + "   " + stack.func_82833_r(), "A recipe used an OreDict item as output directly, without copying the item before that. This is a typical CallByReference/CallByValue error.", "The said item will be renamed to make the invalid recipe visible.", "Please check all recipes that output this item, and report them to the mod that introduced the recipes."};
    }

    private static void logMultilineError(Logger logger, String[] errorMessageLines) {
        for (String errorMessage : errorMessageLines) {
            logger.error(errorMessage);
        }
    }

    static {
        try {
            ConfigurationManager.registerConfig(Client.class);
            ConfigurationManager.registerConfig(Gregtech.class);
            ConfigurationManager.registerConfig(MachineStats.class);
            ConfigurationManager.registerConfig(OPStuff.class);
            ConfigurationManager.registerConfig(Other.class);
            ConfigurationManager.registerConfig(Worldgen.class);
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
        NBT_VERSION = GTMod.calculateTotalGTVersion(509, 50, 79);
        DEBUG = Boolean.getBoolean("gt.debug");
        GT_FML_LOGGER = LogManager.getLogger((String)"GregTech GTNH");
    }
}

