/*
 * Decompiled with CFR 0.152.
 */
package bwcrossmod.tectech.tileentites.tiered;

import bartworks.util.BWTooltipReference;
import bwcrossmod.tectech.tileentites.tiered.LowPowerLaser;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTECable;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.CoverBehavior;
import gregtech.common.GTClient;
import ic2.core.Ic2Items;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class MTELowPowerLaserPipe
extends MTECable
implements LowPowerLaser {
    public MTELowPowerLaserPipe(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 0.25f, Materials.BorosilicateGlass, 0L, 0L, 0L, false, false);
    }

    public MTELowPowerLaserPipe(String aName, float aThickNess, Materials aMaterial, long aCableLossPerMeter, long aAmperage, long aVoltage, boolean aInsulated, boolean aCanShock) {
        super(aName, aThickNess, aMaterial, aCableLossPerMeter, aAmperage, aVoltage, aInsulated, aCanShock);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTELowPowerLaserPipe(this.mName, this.mThickNess, this.mMaterial, this.mCableLossPerMeter, this.mAmperage, this.mVoltage, this.mInsulated, this.mCanShock);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aTick % 20L == 13L && aBaseMetaTileEntity.isClientSide() && GTClient.changeDetected == 4) {
            aBaseMetaTileEntity.issueTextureUpdate();
        }
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection siide, byte aConnections, int aColorIndex, boolean aConnected, boolean aRedstone) {
        return new ITexture[]{TextureFactory.of(Block.func_149634_a((Item)Ic2Items.glassFiberCableBlock.func_77973_b()), Ic2Items.glassFiberCableBlock.func_77960_j(), siide)};
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Primitive Laser Cable intended for Low Power Applications", "Does not auto-connect", "Does not turn or bend", EnumChatFormatting.WHITE + "Must be " + EnumChatFormatting.YELLOW + "c" + EnumChatFormatting.RED + "o" + EnumChatFormatting.BLUE + "l" + EnumChatFormatting.DARK_PURPLE + "o" + EnumChatFormatting.GOLD + "r" + EnumChatFormatting.DARK_RED + "e" + EnumChatFormatting.DARK_GREEN + "d" + EnumChatFormatting.WHITE + " in order to work", BWTooltipReference.ADDED_BY_BARTIMAEUSNEK_VIA_BARTWORKS.get()};
    }

    @Override
    public boolean isSender() {
        return false;
    }

    @Override
    public boolean isReceiver() {
        return false;
    }

    @Override
    public boolean isTunnel() {
        return true;
    }

    @Override
    public boolean canConnect(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isGivingInformation() {
        return false;
    }

    @Override
    public boolean isConnectedCorrectly(ForgeDirection side) {
        return this.isConnectedAtSide(side) && this.isConnectedAtSide(side.getOpposite());
    }

    @Override
    public boolean shouldJoinIc2Enet() {
        return false;
    }

    @Override
    public long injectEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        return 0L;
    }

    @Override
    @Deprecated
    public long transferElectricity(ForgeDirection side, long aVoltage, long aAmperage, ArrayList<TileEntity> aAlreadyPassedTileEntityList) {
        return 0L;
    }

    @Override
    public long transferElectricity(ForgeDirection side, long aVoltage, long aAmperage, HashSet<TileEntity> aAlreadyPassedSet) {
        return 0L;
    }

    @Override
    public boolean letsIn(CoverBehavior coverBehavior, ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsOut(CoverBehavior coverBehavior, ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }
}

