/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.guiadvanced.subpart;

import de.eydamos.guiadvanced.misc.AbstractGuiPart;
import de.eydamos.guiadvanced.util.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class Icon
implements AbstractGuiPart {
    protected int xPosition;
    protected int yPosition;
    protected int uPosition;
    protected int vPosition;
    protected int relativePositionX;
    protected int relativePositionY;
    protected int width;
    protected int height;
    protected ResourceLocation image;

    public Icon(int posX, int posY, int widthHeight) {
        this(null, 0, 0, posX, posY, widthHeight, widthHeight);
    }

    public Icon(int posX, int posY, int width, int height) {
        this(null, 0, 0, posX, posY, width, height);
    }

    public Icon(int u, int v, int posX, int posY, int width, int height) {
        this(null, u, v, posX, posY, width, height);
    }

    public Icon(ResourceLocation graphic, int posX, int posY, int width, int height) {
        this(graphic, 0, 0, posX, posY, width, height);
    }

    public Icon(ResourceLocation graphic, int u, int v, int posX, int posY, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        this.relativePositionX = posX;
        this.relativePositionY = posY;
        this.image = graphic;
        this.uPosition = u;
        this.vPosition = v;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int value) {
        this.width = value;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int value) {
        this.height = value;
    }

    @Override
    public void draw(Minecraft mc, int mouseX, int mouseY, float something) {
        Rectangle icon = new Rectangle(this.width, this.height);
        if (this.image != null) {
            icon.setBackground(this.image);
        }
        icon.setBackgroundPosition(this.uPosition, this.vPosition);
        icon.setBackgroundSize(this.width, this.height);
        icon.draw(this.xPosition, this.yPosition);
    }

    @Override
    public void setAbsolutePosition(int guiLeft, int guiTop) {
        this.xPosition = guiLeft + this.relativePositionX;
        this.yPosition = guiTop + this.relativePositionY;
    }
}

