/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.gen;

import chylex.hee.init.BlockList;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import chylex.hee.world.structure.util.pregen.LargeStructureWorld;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;

public class CaveGenerator {
    private static double[] distanceValues = new double[64];
    private final int centerX;
    private final int centerY;
    private final int centerZ;
    private final int radX;
    private final int radY;
    private final int radZ;
    private final Set<BlockPosM> airList = new HashSet<BlockPosM>();
    private final Set<BlockPosM> clusterList = new HashSet<BlockPosM>();

    public CaveGenerator(int centerX, int centerY, int centerZ, int radX, int radY, int radZ) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.radX = radX;
        this.radY = radY;
        this.radZ = radZ;
    }

    public void setup(Random rand, IslandBiomeBase biome) {
        int caveAmount = (int)(biome.getCaveAmountMultiplier() * (8.0f + rand.nextFloat() * 5.5f));
        for (int a = 0; a < caveAmount; ++a) {
            int x = this.centerX + (int)(Math.sin(rand.nextDouble() * 2.0 * Math.PI) * (double)this.radX * (rand.nextDouble() * 0.1 + 0.9));
            int z = this.centerZ + (int)(Math.cos(rand.nextDouble() * 2.0 * Math.PI) * (double)this.radY * (rand.nextDouble() * 0.1 + 0.9));
            int y = this.centerY + rand.nextInt(this.radY * 2) - this.radY;
            this.generateNode(rand, x, y, z, rand.nextFloat() * 0.45f + 2.65f, biome.getCaveBranchingChance(), Vec3.func_72443_a((double)(rand.nextBoolean() ? (double)(this.centerX - x) : (double)(x - this.centerX)), (double)((double)(this.centerY - y) * rand.nextDouble() * 4.0), (double)(rand.nextBoolean() ? (double)(this.centerZ - z) : (double)(z - this.centerZ))).func_72432_b(), 0);
        }
    }

    public void generate(LargeStructureWorld world) {
        for (BlockPosM loc : this.airList) {
            world.setBlock(loc.x, loc.y, loc.z, Blocks.field_150350_a);
        }
        for (BlockPosM loc : this.clusterList) {
            boolean foundSolid = false;
            for (int py = loc.y - 5; py <= loc.y + 5; ++py) {
                if (world.isAir(loc.x, py, loc.z)) continue;
                foundSolid = true;
                break;
            }
            if (!foundSolid) continue;
            world.setBlock(loc.x, loc.y, loc.z, BlockList.energy_cluster);
        }
    }

    private void generateNode(Random rand, float x, float y, float z, float rad, float branchingChance, Vec3 vec, int iteration) {
        if (iteration == 3) {
            return;
        }
        int cycle = 0;
        while (++cycle < 150) {
            vec.field_72450_a += (double)0.65f * (rand.nextDouble() - 0.5);
            vec.field_72448_b += (double)0.4f * (rand.nextDouble() - 0.5);
            vec.field_72449_c += (double)0.65f * (rand.nextDouble() - 0.5);
            x = (float)((double)x + vec.field_72450_a);
            y = (float)((double)y + vec.field_72448_b);
            z = (float)((double)z + vec.field_72449_c);
            if (!this.createAirBlob(rand, MathUtil.floor(x), MathUtil.floor(y), MathUtil.floor(z), rad)) break;
            if (!(rand.nextFloat() < branchingChance)) continue;
            this.generateNode(rand, x, y, z, rad - rand.nextFloat() * 0.15f, branchingChance * 0.75f, Vec3.func_72443_a((double)(vec.field_72450_a + (double)0.8f * (rand.nextDouble() - 0.5)), (double)(vec.field_72448_b + (double)0.4f * (rand.nextDouble() - 0.5)), (double)(vec.field_72449_c + (double)0.8f * (rand.nextDouble() - 0.5))), iteration + 1);
        }
    }

    private boolean createAirBlob(Random rand, int x, int y, int z, float rad) {
        int zz;
        int yy;
        int xx;
        rad += rand.nextFloat() * 0.2f;
        if (rand.nextInt(30) == 0) {
            rad *= 1.5f;
        }
        boolean onePlaced = false;
        int intrad = MathUtil.ceil(rad);
        for (xx = x - intrad; xx <= x + intrad; ++xx) {
            for (yy = y - intrad; yy <= y + intrad; ++yy) {
                for (zz = z - intrad; zz <= z + intrad; ++zz) {
                    if (xx <= this.centerX - this.radX || xx >= this.centerX + this.radX || yy <= this.centerY - this.radY || yy >= this.centerY + this.radY || zz <= this.centerZ - this.radZ || zz >= this.centerZ + this.radZ || !(CaveGenerator.getDistance(xx - x, yy - y, zz - z) < (double)(rad + rand.nextFloat() * 0.15f))) continue;
                    onePlaced = true;
                    this.airList.add(new BlockPosM(xx, yy, zz));
                }
            }
        }
        if (rand.nextInt(120) == 0 && (CaveGenerator.getDistance((xx = x + rand.nextInt(intrad) - rand.nextInt(intrad)) - x, (yy = y + rand.nextInt(intrad) - rand.nextInt(intrad)) - y, (zz = z + rand.nextInt(intrad) - rand.nextInt(intrad)) - z) < (double)(rad * 0.5f) || rand.nextInt(8) == 0)) {
            this.clusterList.add(new BlockPosM(xx, yy, zz));
        }
        return onePlaced;
    }

    public static double getDistance(int xdiff, int ydiff, int zdiff) {
        if (xdiff < 0) {
            xdiff *= -1;
        }
        if (ydiff < 0) {
            ydiff *= -1;
        }
        if (zdiff < 0) {
            zdiff *= -1;
        }
        if (xdiff > 3 || ydiff > 3 || zdiff > 3) {
            return Math.sqrt(xdiff * xdiff + ydiff * ydiff + zdiff * zdiff);
        }
        return distanceValues[16 * xdiff + 4 * ydiff + zdiff];
    }

    static {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    CaveGenerator.distanceValues[16 * x + 4 * y + z] = Math.sqrt(x * x + y * y + z * z);
                }
            }
        }
    }
}

