/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.panel.http;

import argo.jdom.JsonNodeBuilder;
import argo.jdom.JsonNodeBuilders;
import argo.jdom.JsonObjectNodeBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.panel.http.Request;

public class HttpCardSender {
    private static final String ID_URL_TEMPLATE = "http://sensors.modstats.org/api/v1/register?p=";
    private static final String DATA_URL_TEMPLATE = "http://sensors.modstats.org/api/v1/report";
    public static HttpCardSender instance = new HttpCardSender();
    private final ConcurrentHashMap<Long, JsonNodeBuilder> unsent = new ConcurrentHashMap();
    public ConcurrentLinkedQueue<Long> availableIds = new ConcurrentLinkedQueue();
    private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(64));

    private HttpCardSender() {
    }

    public void requestId() {
        try {
            this.executor.submit(new Request(new URL(ID_URL_TEMPLATE + IC2NuclearControl.instance.httpSensorKey), null));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void send() {
        try {
            this.executor.submit(new Request(new URL(DATA_URL_TEMPLATE), this.unsent));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void add(NBTTagCompound cardData, UUID cardType, Long id) {
        JsonObjectNodeBuilder builder = JsonNodeBuilders.anObjectBuilder();
        builder.withField("id", JsonNodeBuilders.aNumberBuilder((String)id.toString()));
        builder.withField("type", JsonNodeBuilders.aStringBuilder((String)cardType.toString().replace("-", "")));
        for (String s : cardData.func_150296_c()) {
            NBTBase tag = cardData.func_74781_a(s);
            if (s.equals("_webSensorId")) continue;
            if (s.equals("energyL") || s.equals("maxStorageL")) {
                builder.withField(s, JsonNodeBuilders.aStringBuilder((String)String.valueOf(Double.valueOf(tag.toString()).longValue())));
                continue;
            }
            builder.withField(s, JsonNodeBuilders.aStringBuilder((String)tag.toString()));
        }
        this.unsent.put(id, (JsonNodeBuilder)builder);
    }
}

