/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls;

import com.creativemd.creativecore.client.rendering.RenderHelper2D;
import com.creativemd.creativecore.common.gui.controls.GuiControl;
import com.creativemd.creativecore.common.gui.event.ControlChangedEvent;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector4d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiAnalogeSlider
extends GuiControl {
    public static final ResourceLocation buttonTextures = new ResourceLocation("textures/gui/widgets.png");
    public float maxValue;
    public float minValue;
    public float value;
    public boolean grabbedSlider;

    public GuiAnalogeSlider(String name, int x, int y, int width, int height, int rotation, float value, float minValue, float maxValue) {
        super(name, x, y, width, height, rotation);
        this.value = value;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public GuiAnalogeSlider(String name, int x, int y, int width, int height, float value, float minValue, float maxValue) {
        this(name, x, y, width, height, 0, value, minValue, maxValue);
    }

    public String getTextByValue() {
        return this.value + "";
    }

    @Override
    public void drawControl(FontRenderer renderer) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(buttonTextures);
        int mouseEvent = 1;
        Vector2d mouse = this.parent.getMousePos();
        if (this.isMouseOver((int)mouse.x, (int)mouse.y)) {
            mouseEvent = 2;
        }
        if (!this.enabled) {
            mouseEvent = 0;
        }
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glBlendFunc((int)770, (int)771);
        Vector4d black = new Vector4d(0.0, 0.0, 0.0, 255.0);
        RenderHelper2D.drawGradientRect(0, 0, this.width, this.height, black, black);
        Vector4d color = new Vector4d(60.0, 60.0, 60.0, 255.0);
        RenderHelper2D.drawGradientRect(1, 1, this.width - 1, this.height - 1, color, color);
        int sliderWidth = 4;
        float percent = (this.value - this.minValue) / (this.maxValue - this.minValue);
        int posX = 1 + (int)((float)(this.width - (1 + sliderWidth)) * percent);
        Vector4d white = new Vector4d(255.0, 255.0, 255.0, 255.0);
        RenderHelper2D.drawGradientRect(posX, 1, posX + 4, this.height - 1, white, white);
        String text = this.getTextByValue();
        renderer.func_78261_a(text, this.width / 2 - renderer.func_78256_a(text) / 2, (this.height - 8) / 2, 0xE0E0E0);
    }

    @Override
    public boolean mousePressed(int posX, int posY, int button) {
        Vector2d mouse = this.parent.getMousePos();
        if (button == 0) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            this.grabbedSlider = true;
            return true;
        }
        return false;
    }

    public void setValue(float value) {
        this.value = Math.max(this.minValue, value);
        this.value = Math.min(this.maxValue, this.value);
        this.raiseEvent(new ControlChangedEvent(this));
    }

    @Override
    public void mouseMove(int posX, int posY, int button) {
        Vector2d mouse = this.parent.getMousePos();
        if (this.grabbedSlider) {
            this.value = mouse.x < (double)this.posX ? this.minValue : (mouse.x > (double)(this.posX + this.width) ? this.maxValue : this.minValue + (this.maxValue - this.minValue) * ((float)(mouse.x - (double)this.posX) / (float)this.width));
            this.setValue(this.value);
        }
    }

    @Override
    public void mouseReleased(int posX, int posY, int button) {
        if (this.grabbedSlider) {
            this.grabbedSlider = false;
        }
    }
}

