/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.api.utils;

import com.kuba6000.mobsinfo.MobsInfo;
import com.kuba6000.mobsinfo.mixin.minecraft.ASMEventHandlerAccessor;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.ASMEventHandler;
import cpw.mods.fml.common.eventhandler.IEventListener;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import net.minecraft.entity.EntityList;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class ModUtils {
    public static final boolean isDeobfuscatedEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    public static boolean isClientSided = false;
    private static final HashMap<String, ModContainer> classNamesToModContainer = new HashMap();
    private static final Map.Entry<String, ModContainer> nullEntry = new AbstractMap.SimpleEntry<String, Object>("", null);
    private static String modListVersion = null;
    private static String modListVersionIgnoringModVersions = null;

    public static boolean isClientThreaded() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    private static void initClassNamesToMods() {
        if (classNamesToModContainer.size() == 0) {
            classNamesToModContainer.put("net.minecraft", (ModContainer)Loader.instance().getMinecraftModContainer());
            Loader.instance().getActiveModList().forEach(m -> {
                Object Mod2 = m.getMod();
                if (Mod2 != null) {
                    Package modPackage = Mod2.getClass().getPackage();
                    if (modPackage == null) {
                        MobsInfo.warn("Mod " + m.getModId() + " package is not loaded yet!");
                        return;
                    }
                    classNamesToModContainer.put(modPackage.getName(), (ModContainer)m);
                }
            });
        }
    }

    public static String getModNameFromClassName(String classname) {
        ModUtils.initClassNamesToMods();
        Map.Entry entry = classNamesToModContainer.entrySet().stream().filter(e -> classname.startsWith((String)e.getKey())).findAny().orElse(null);
        if (entry == null) {
            return "Unknown";
        }
        return ((ModContainer)entry.getValue()).getName();
    }

    public static ModContainer getModContainerFromClassName(String classname) {
        ModUtils.initClassNamesToMods();
        return classNamesToModContainer.entrySet().stream().filter(e -> classname.startsWith((String)e.getKey())).findAny().orElse(nullEntry).getValue();
    }

    public static String getModListVersion() {
        IEventListener[] listeners;
        if (modListVersion != null) {
            return modListVersion;
        }
        HashSet<ModContainer> modsWithEntities = new HashSet<ModContainer>();
        for (IEventListener[] value : EntityList.field_75625_b.values()) {
            ModContainer mod = ModUtils.getModContainerFromClassName(value.getName());
            if (mod == null) continue;
            modsWithEntities.add(mod);
        }
        for (IEventListener listener : listeners = new LivingDeathEvent(null, null).getListenerList().getListeners(0)) {
            if (!(listener instanceof ASMEventHandler)) continue;
            modsWithEntities.add(((ASMEventHandlerAccessor)listener).getOwner());
        }
        for (IEventListener listener : listeners = new LivingDropsEvent(null, null, null, 0, false, 0).getListenerList().getListeners(0)) {
            if (!(listener instanceof ASMEventHandler)) continue;
            modsWithEntities.add(((ASMEventHandlerAccessor)listener).getOwner());
        }
        String sortedList = modsWithEntities.stream().filter(m -> m.getMod() != null).sorted(Comparator.comparing(ModContainer::getModId)).collect(StringBuilder::new, (a, b) -> a.append(b.getModId()).append(b.getVersion()), (a, b) -> a.append(", ").append((CharSequence)b)).toString();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            modListVersion = DatatypeConverter.printHexBinary((byte[])md.digest(sortedList.getBytes(StandardCharsets.UTF_8))).toUpperCase();
            return modListVersion;
        }
        catch (Exception e) {
            modListVersion = sortedList;
            return sortedList;
        }
    }

    public static String getModListVersionIgnoringModVersions() {
        IEventListener[] listeners;
        if (modListVersionIgnoringModVersions != null) {
            return modListVersionIgnoringModVersions;
        }
        HashSet<ModContainer> modsWithEntities = new HashSet<ModContainer>();
        for (IEventListener[] value : EntityList.field_75625_b.values()) {
            ModContainer mod = ModUtils.getModContainerFromClassName(value.getName());
            if (mod == null) continue;
            modsWithEntities.add(mod);
        }
        for (IEventListener listener : listeners = new LivingDeathEvent(null, null).getListenerList().getListeners(0)) {
            if (!(listener instanceof ASMEventHandler)) continue;
            modsWithEntities.add(((ASMEventHandlerAccessor)listener).getOwner());
        }
        for (IEventListener listener : listeners = new LivingDropsEvent(null, null, null, 0, false, 0).getListenerList().getListeners(0)) {
            if (!(listener instanceof ASMEventHandler)) continue;
            modsWithEntities.add(((ASMEventHandlerAccessor)listener).getOwner());
        }
        String sortedList = modsWithEntities.stream().filter(m -> m.getMod() != null).sorted(Comparator.comparing(ModContainer::getModId)).collect(StringBuilder::new, (a, b) -> a.append(b.getModId()), (a, b) -> a.append(", ").append((CharSequence)b)).toString();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            modListVersionIgnoringModVersions = DatatypeConverter.printHexBinary((byte[])md.digest(sortedList.getBytes(StandardCharsets.UTF_8))).toUpperCase();
            return modListVersionIgnoringModVersions;
        }
        catch (Exception e) {
            modListVersionIgnoringModVersions = sortedList;
            return sortedList;
        }
    }

    @FunctionalInterface
    public static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }
}

