/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.BoP;

import biomesoplenty.api.content.BOPCItems;
import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicBerryCrop;
import ic2.api.crops.ICropTile;
import net.minecraft.item.ItemStack;

public class BoPBerryCrop
extends BasicBerryCrop {
    public String name() {
        return "Berry";
    }

    @Override
    public int tier() {
        return 2;
    }

    @Override
    public int stat(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < this.maxSize();
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() >= this.maxSize();
    }

    @Override
    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        return crop.getSize() == 2 ? 200 : 700;
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        return 2;
    }

    @Override
    public int maxSize() {
        return 3;
    }

    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(BOPCItems.food, 3, 0);
    }

    public String[] attributes() {
        return new String[]{"Berry", "Food", "Red", "Ingredient"};
    }

    @Override
    public String discoveredBy() {
        return "bartimaeusnek";
    }

    @Override
    public ItemStack getDisplayItem() {
        return new ItemStack(BOPCItems.food, 3, 0);
    }
}

