/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forestry;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.plugins.forestry.ApothecariesBackpack;
import mods.railcraft.common.plugins.forestry.BaseBackpack;
import mods.railcraft.common.plugins.forestry.IceManTickHandler;
import mods.railcraft.common.plugins.forestry.IcemanBackpack;
import mods.railcraft.common.plugins.forestry.TrackmanBackpack;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ForestryPlugin {
    public static Item trackmanBackpackT1;
    public static Item trackmanBackpackT2;
    public static Item icemanBackpackT1;
    public static Item icemanBackpackT2;
    public static Item apothecariesBackpackT1;
    public static Item apothecariesBackpackT2;
    public static Boolean modLoaded;
    private static ForestryPlugin instance;

    public static ForestryPlugin instance() {
        if (instance == null) {
            instance = ForestryPlugin.isForestryInstalled() ? new ForestryPluginInstalled() : new ForestryPlugin();
        }
        return instance;
    }

    public static boolean isForestryInstalled() {
        if (modLoaded == null) {
            modLoaded = Loader.isModLoaded((String)"Forestry");
        }
        return modLoaded;
    }

    public static ItemStack getItem(String tag) {
        if (!ForestryPlugin.isForestryInstalled()) {
            return null;
        }
        Item item = GameRegistry.findItem((String)"Forestry", (String)tag);
        if (item == null) {
            return null;
        }
        return new ItemStack(item, 1);
    }

    public static void addBackpackItem(String pack, ItemStack stack) {
        if (stack == null) {
            return;
        }
        ForestryPlugin.addBackpackItem(pack, stack.func_77973_b(), stack.func_77960_j());
    }

    public static void addBackpackItem(String pack, Item item) {
        ForestryPlugin.sendBackpackMessage(String.format("%s@%s:*", pack, GameRegistry.findUniqueIdentifierFor((Item)item)));
    }

    public static void addBackpackItem(String pack, Item item, int damage) {
        ForestryPlugin.sendBackpackMessage(String.format("%s@%s:%d", pack, GameRegistry.findUniqueIdentifierFor((Item)item), damage));
    }

    public static void addBackpackItem(String pack, Block block) {
        ForestryPlugin.sendBackpackMessage(String.format("%s@%s:*", pack, GameRegistry.findUniqueIdentifierFor((Block)block)));
    }

    public static void addBackpackItem(String pack, Block block, int meta) {
        ForestryPlugin.sendBackpackMessage(String.format("%s@%s:%d", pack, GameRegistry.findUniqueIdentifierFor((Block)block), meta));
    }

    private static void sendBackpackMessage(String message) {
        if (message.contains("null")) {
            throw new IllegalArgumentException("Attempting to register broken item with Forestry Backpack!");
        }
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)message);
    }

    public void registerBackpacks() {
    }

    public void setupBackpackContents() {
    }

    public void addCarpenterRecipe(String recipeTag, int packagingTime, FluidStack liquid, ItemStack box, ItemStack product, Object ... materials) {
    }

    static {
        modLoaded = null;
    }

    private static class ForestryPluginInstalled
    extends ForestryPlugin {
        private ForestryPluginInstalled() {
        }

        @Override
        @Optional.Method(modid="Forestry")
        public void registerBackpacks() {
            try {
                ItemStack output;
                ItemStack silk;
                ItemStack output2;
                if (BackpackManager.backpackInterface == null) {
                    return;
                }
                String tag = "railcraft.backpack.trackman.t1";
                if (RailcraftConfig.isItemEnabled(tag)) {
                    trackmanBackpackT1 = this.registerBackpack(TrackmanBackpack.getInstance(), EnumBackpackType.T1, tag);
                    output2 = new ItemStack(trackmanBackpackT1);
                    this.addBackpackTooltip(output2);
                    CraftingPlugin.addShapedRecipe(output2, "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('V'), new ItemStack(Blocks.field_150448_aq), Character.valueOf('X'), Items.field_151007_F, Character.valueOf('Y'), "chestWood");
                }
                if (RailcraftConfig.isItemEnabled(tag = "railcraft.backpack.trackman.t2")) {
                    trackmanBackpackT2 = this.registerBackpack(TrackmanBackpack.getInstance(), EnumBackpackType.T2, tag);
                    silk = ForestryPluginInstalled.getItem("craftingMaterial");
                    if (silk != null) {
                        silk.func_77964_b(3);
                        output = new ItemStack(trackmanBackpackT2);
                        this.addBackpackTooltip(output);
                        RecipeManagers.carpenterManager.addRecipe(200, Fluids.WATER.get(1000), null, output, new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), "gemDiamond", Character.valueOf('W'), silk, Character.valueOf('T'), trackmanBackpackT1});
                    }
                }
                if (RailcraftConfig.isItemEnabled(tag = "railcraft.backpack.iceman.t1")) {
                    icemanBackpackT1 = this.registerBackpack(IcemanBackpack.getInstance(), EnumBackpackType.T1, tag);
                    output2 = new ItemStack(icemanBackpackT1);
                    this.addBackpackTooltip(output2);
                    CraftingPlugin.addShapedRecipe(output2, "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('V'), new ItemStack(Blocks.field_150433_aE), Character.valueOf('X'), Items.field_151007_F, Character.valueOf('Y'), "chestWood");
                }
                if (RailcraftConfig.isItemEnabled(tag = "railcraft.backpack.iceman.t2")) {
                    icemanBackpackT2 = this.registerBackpack(IcemanBackpack.getInstance(), EnumBackpackType.T2, tag);
                    silk = ForestryPluginInstalled.getItem("craftingMaterial");
                    if (silk != null) {
                        silk.func_77964_b(3);
                        output = new ItemStack(icemanBackpackT2);
                        this.addBackpackTooltip(output);
                        RecipeManagers.carpenterManager.addRecipe(200, Fluids.WATER.get(1000), null, output, new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), "gemDiamond", Character.valueOf('W'), silk, Character.valueOf('T'), icemanBackpackT1});
                    }
                }
                if (icemanBackpackT1 != null || icemanBackpackT2 != null) {
                    FMLCommonHandler.instance().bus().register((Object)new IceManTickHandler());
                }
                if (RailcraftConfig.isItemEnabled(tag = "railcraft.backpack.apothecary.t1")) {
                    apothecariesBackpackT1 = this.registerBackpack(ApothecariesBackpack.getInstance(), EnumBackpackType.T1, tag);
                    output2 = new ItemStack(apothecariesBackpackT1);
                    this.addBackpackTooltip(output2);
                    CraftingPlugin.addShapedRecipe(output2, "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('V'), new ItemStack((Item)Items.field_151068_bn, 1, 8197), Character.valueOf('X'), Items.field_151007_F, Character.valueOf('Y'), "chestWood");
                    CraftingPlugin.addShapedRecipe(output2, "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('V'), new ItemStack((Item)Items.field_151068_bn, 1, 8261), Character.valueOf('X'), Items.field_151007_F, Character.valueOf('Y'), "chestWood");
                    CraftingPlugin.addShapedRecipe(output2, "X#X", "VYV", "X#X", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('V'), new ItemStack((Item)Items.field_151068_bn, 1, 8229), Character.valueOf('X'), Items.field_151007_F, Character.valueOf('Y'), "chestWood");
                }
                if (RailcraftConfig.isItemEnabled(tag = "railcraft.backpack.apothecary.t2")) {
                    apothecariesBackpackT2 = this.registerBackpack(ApothecariesBackpack.getInstance(), EnumBackpackType.T2, tag);
                    silk = ForestryPluginInstalled.getItem("craftingMaterial");
                    if (silk != null) {
                        silk.func_77964_b(3);
                        output = new ItemStack(apothecariesBackpackT2);
                        this.addBackpackTooltip(output);
                        RecipeManagers.carpenterManager.addRecipe(200, Fluids.WATER.get(1000), null, output, new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), "gemDiamond", Character.valueOf('W'), silk, Character.valueOf('T'), apothecariesBackpackT1});
                    }
                }
            }
            catch (Throwable error) {
                Game.logErrorAPI("Forestry", error, BackpackManager.class);
            }
        }

        @Optional.Method(modid="Forestry")
        private Item registerBackpack(BaseBackpack backpack, EnumBackpackType type, String tag) {
            Item item = BackpackManager.backpackInterface.addBackpack((IBackpackDefinition)backpack, type).func_77637_a(CreativePlugin.RAILCRAFT_TAB).func_77655_b(tag);
            RailcraftRegistry.registerInit(item);
            return item;
        }

        @Optional.Method(modid="Forestry")
        private void addBackpackTooltip(ItemStack stack) {
            InvTools.addItemToolTip(stack, "\u00a77\u00a7o" + LocalizationPlugin.translate("item.railcraft.backpack.tip"));
        }

        @Override
        @Optional.Method(modid="Forestry")
        public void setupBackpackContents() {
            try {
                if (BackpackManager.backpackInterface == null) {
                    return;
                }
                TrackmanBackpack.getInstance().setup();
                IcemanBackpack.getInstance().setup();
                ApothecariesBackpack.getInstance().setup();
            }
            catch (Throwable error) {
                Game.logErrorAPI("Forestry", error, BackpackManager.class);
            }
        }

        @Override
        @Optional.Method(modid="Forestry")
        public void addCarpenterRecipe(String recipeTag, int packagingTime, FluidStack liquid, ItemStack box, ItemStack product, Object ... materials) {
            try {
                if (RecipeManagers.carpenterManager != null && RailcraftConfig.getRecipeConfig("forestry.carpenter." + recipeTag)) {
                    RecipeManagers.carpenterManager.addRecipe(packagingTime, liquid, null, product, materials);
                }
            }
            catch (Throwable error) {
                Game.logErrorAPI("Forestry", error, RecipeManagers.class);
            }
        }
    }
}

