/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.pbr.loader;

import com.google.common.collect.Lists;
import com.gtnewhorizons.angelica.compat.mojang.NativeImage;
import com.gtnewhorizons.angelica.glsm.texture.TextureInfo;
import com.gtnewhorizons.angelica.glsm.texture.TextureInfoCache;
import com.gtnewhorizons.angelica.mixins.early.shaders.accessors.AnimationMetadataSectionAccessor;
import com.gtnewhorizons.angelica.mixins.early.shaders.accessors.TextureAtlasSpriteAccessor;
import com.gtnewhorizons.angelica.mixins.early.shaders.accessors.TextureMapAccessor;
import com.gtnewhorizons.angelica.mixins.interfaces.ISpriteExt;
import com.gtnewhorizons.angelica.shadow.javax.annotation.Nullable;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import net.coderbot.iris.Iris;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatLoader;
import net.coderbot.iris.texture.mipmap.ChannelMipmapGenerator;
import net.coderbot.iris.texture.mipmap.CustomMipmapGenerator;
import net.coderbot.iris.texture.mipmap.LinearBlendFunction;
import net.coderbot.iris.texture.pbr.PBRAtlasTexture;
import net.coderbot.iris.texture.pbr.PBRSpriteHolder;
import net.coderbot.iris.texture.pbr.PBRType;
import net.coderbot.iris.texture.pbr.TextureAtlasSpriteExtension;
import net.coderbot.iris.texture.pbr.loader.PBRTextureLoader;
import net.coderbot.iris.texture.pbr.loader.TextureAtlasSpriteInfo;
import net.coderbot.iris.texture.util.ImageManipulationUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class AtlasPBRLoader
implements PBRTextureLoader<TextureMap> {
    public static final ChannelMipmapGenerator LINEAR_MIPMAP_GENERATOR = new ChannelMipmapGenerator(LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE, LinearBlendFunction.INSTANCE);

    @Override
    public void load(TextureMap texMap, IResourceManager resourceManager, PBRTextureLoader.PBRTextureConsumer pbrTextureConsumer) {
        TextureInfo textureInfo = TextureInfoCache.INSTANCE.getInfo(texMap.func_110552_b());
        int atlasWidth = textureInfo.getWidth();
        int atlasHeight = textureInfo.getHeight();
        int mipLevel = AtlasPBRLoader.fetchAtlasMipLevel(texMap);
        PBRAtlasTexture normalAtlas = null;
        PBRAtlasTexture specularAtlas = null;
        for (TextureAtlasSprite sprite : ((TextureMapAccessor)texMap).getMapUploadedSprites().values()) {
            PBRSpriteHolder pbrSpriteHolder;
            if (sprite.func_94215_i().equals("missingno")) continue;
            TextureAtlasSprite normalSprite = this.createPBRSprite(sprite, resourceManager, texMap, atlasWidth, atlasHeight, mipLevel, PBRType.NORMAL);
            TextureAtlasSprite specularSprite = this.createPBRSprite(sprite, resourceManager, texMap, atlasWidth, atlasHeight, mipLevel, PBRType.SPECULAR);
            if (normalSprite != null) {
                if (normalAtlas == null) {
                    normalAtlas = new PBRAtlasTexture(texMap, PBRType.NORMAL);
                }
                normalAtlas.addSprite(normalSprite);
                pbrSpriteHolder = ((TextureAtlasSpriteExtension)sprite).getOrCreatePBRHolder();
                pbrSpriteHolder.setNormalSprite(normalSprite);
            }
            if (specularSprite == null) continue;
            if (specularAtlas == null) {
                specularAtlas = new PBRAtlasTexture(texMap, PBRType.SPECULAR);
            }
            specularAtlas.addSprite(specularSprite);
            pbrSpriteHolder = ((TextureAtlasSpriteExtension)sprite).getOrCreatePBRHolder();
            pbrSpriteHolder.setSpecularSprite(specularSprite);
        }
        if (normalAtlas != null && normalAtlas.tryUpload(atlasWidth, atlasHeight, mipLevel, ((TextureMapAccessor)texMap).getAnisotropicFiltering())) {
            pbrTextureConsumer.acceptNormalTexture(normalAtlas);
        }
        if (specularAtlas != null && specularAtlas.tryUpload(atlasWidth, atlasHeight, mipLevel, ((TextureMapAccessor)texMap).getAnisotropicFiltering())) {
            pbrTextureConsumer.acceptSpecularTexture(specularAtlas);
        }
    }

    protected static int fetchAtlasMipLevel(TextureMap texMap) {
        return ((TextureMapAccessor)texMap).getMipmapLevels();
    }

    @Nullable
    protected TextureAtlasSprite createPBRSprite(TextureAtlasSprite sprite, IResourceManager resourceManager, TextureMap texMap, int atlasWidth, int atlasHeight, int mipLevel, PBRType pbrType) {
        ResourceLocation spriteName = new ResourceLocation(sprite.func_94215_i());
        ResourceLocation imageLocation = texMap.func_147634_a(spriteName, 0);
        ResourceLocation pbrImageLocation = pbrType.appendToFileLocation(imageLocation);
        PBRTextureAtlasSprite pbrSprite = null;
        try {
            IResource resource = resourceManager.func_110536_a(pbrImageLocation);
            NativeImage nativeImage = NativeImage.read(resource.func_110527_b());
            AnimationMetadataSection animationMetadata = (AnimationMetadataSection)resource.func_110526_a("animation");
            if (animationMetadata == null) {
                animationMetadata = new AnimationMetadataSection((List)Lists.newArrayList(), -1, -1, -1);
            }
            Pair<Integer, Integer> frameSize = this.getFrameSize(nativeImage.getWidth(), nativeImage.getHeight(), animationMetadata);
            int frameWidth = (Integer)frameSize.getLeft();
            int frameHeight = (Integer)frameSize.getRight();
            int targetFrameWidth = sprite.func_94211_a();
            int targetFrameHeight = sprite.func_94216_b();
            if (frameWidth != targetFrameWidth || frameHeight != targetFrameHeight) {
                int imageWidth = nativeImage.getWidth();
                int imageHeight = nativeImage.getHeight();
                int targetImageWidth = imageWidth / frameWidth * targetFrameWidth;
                int targetImageHeight = imageHeight / frameHeight * targetFrameHeight;
                NativeImage scaledImage = targetImageWidth % imageWidth == 0 && targetImageHeight % imageHeight == 0 ? ImageManipulationUtil.scaleNearestNeighbor(nativeImage, targetImageWidth, targetImageHeight) : ImageManipulationUtil.scaleBilinear(nativeImage, targetImageWidth, targetImageHeight);
                nativeImage = scaledImage;
                frameWidth = targetFrameWidth;
                frameHeight = targetFrameHeight;
                if (!animationMetadata.equals(new AnimationMetadataSection((List)Lists.newArrayList(), -1, -1, -1))) {
                    AnimationMetadataSectionAccessor animationAccessor = (AnimationMetadataSectionAccessor)animationMetadata;
                    int internalFrameWidth = animationAccessor.getFrameHeight();
                    int internalFrameHeight = animationAccessor.getFrameHeight();
                    if (internalFrameWidth != -1) {
                        animationAccessor.setFrameWidth(frameWidth);
                    }
                    if (internalFrameHeight != -1) {
                        animationAccessor.setFrameHeight(frameHeight);
                    }
                }
            }
            ResourceLocation pbrSpriteName = new ResourceLocation(spriteName.func_110624_b(), spriteName.func_110623_a() + pbrType.getSuffix());
            PBRTextureAtlasSpriteInfo pbrSpriteInfo = new PBRTextureAtlasSpriteInfo(pbrSpriteName, frameWidth, frameHeight, animationMetadata, pbrType);
            int x = sprite.func_130010_a();
            int y = sprite.func_110967_i();
            pbrSprite = new PBRTextureAtlasSprite(pbrSpriteInfo, animationMetadata, atlasWidth, atlasHeight, x, y, nativeImage, texMap, mipLevel);
            this.syncAnimation(sprite, pbrSprite);
        }
        catch (FileNotFoundException resource) {
        }
        catch (RuntimeException e) {
            Iris.logger.error("Unable to parse metadata from {} : {}", pbrImageLocation, e);
        }
        catch (IOException e) {
            Iris.logger.error("Unable to load {} : {}", pbrImageLocation, e);
        }
        return pbrSprite;
    }

    protected void syncAnimation(TextureAtlasSprite source, TextureAtlasSprite target) {
        int time;
        if (!((ISpriteExt)source).isAnimation() || !((ISpriteExt)target).isAnimation()) {
            return;
        }
        TextureAtlasSpriteAccessor sourceAccessor = (TextureAtlasSpriteAccessor)source;
        AnimationMetadataSection sourceMetadata = sourceAccessor.getMetadata();
        int ticks = 0;
        for (int f = 0; f < sourceAccessor.getFrame(); ++f) {
            ticks += sourceMetadata.func_110472_a(f);
        }
        TextureAtlasSpriteAccessor targetAccessor = (TextureAtlasSpriteAccessor)target;
        AnimationMetadataSection targetMetadata = targetAccessor.getMetadata();
        int cycleTime = 0;
        int frameCount = targetMetadata.func_110473_c();
        for (int f = 0; f < frameCount; ++f) {
            cycleTime += targetMetadata.func_110472_a(f);
        }
        ticks %= cycleTime;
        int targetFrame = 0;
        while (ticks >= (time = targetMetadata.func_110472_a(targetFrame))) {
            ++targetFrame;
            ticks -= time;
        }
        targetAccessor.setFrame(targetFrame);
        targetAccessor.setSubFrame(ticks + sourceAccessor.getSubFrame());
    }

    private Pair<Integer, Integer> getFrameSize(int i, int j, AnimationMetadataSection animationMetadataSection) {
        Pair<Integer, Integer> pair = this.calculateFrameSize(i, j, animationMetadataSection);
        int k = (Integer)pair.getLeft();
        int l = (Integer)pair.getRight();
        if (AtlasPBRLoader.isDivisionInteger(i, k) && AtlasPBRLoader.isDivisionInteger(j, l)) {
            return pair;
        }
        throw new IllegalArgumentException(String.format("Image size %s,%s is not multiply of frame size %s,%s", i, j, k, l));
    }

    private Pair<Integer, Integer> calculateFrameSize(int i, int j, AnimationMetadataSection animationMetadataSection) {
        if (animationMetadataSection.func_110474_b() != -1) {
            return animationMetadataSection.func_110471_a() != -1 ? Pair.of((Object)animationMetadataSection.func_110474_b(), (Object)animationMetadataSection.func_110471_a()) : Pair.of((Object)animationMetadataSection.func_110474_b(), (Object)j);
        }
        if (animationMetadataSection.func_110471_a() != -1) {
            return Pair.of((Object)i, (Object)animationMetadataSection.func_110471_a());
        }
        int k = Math.min(i, j);
        return Pair.of((Object)k, (Object)k);
    }

    private static boolean isDivisionInteger(int i, int j) {
        return i / j * j == i;
    }

    protected static class PBRTextureAtlasSpriteInfo
    extends TextureAtlasSpriteInfo {
        protected final PBRType pbrType;

        public PBRTextureAtlasSpriteInfo(ResourceLocation name, int width, int height, AnimationMetadataSection metadata, PBRType pbrType) {
            super(name, width, height, metadata);
            this.pbrType = pbrType;
        }
    }

    public static class PBRTextureAtlasSprite
    extends TextureAtlasSprite
    implements CustomMipmapGenerator.Provider {
        protected PBRTextureAtlasSprite(TextureAtlasSpriteInfo info, AnimationMetadataSection animationMetaDataSection, int atlasWidth, int atlasHeight, int x, int y, NativeImage nativeImage, TextureMap texMap, int miplevel) {
            super(info.name().toString());
            super.func_110971_a(atlasWidth, atlasHeight, x, y, false);
            super.func_147964_a((BufferedImage[])this.getMipmapGenerator(info, atlasWidth, atlasHeight).generateMipLevels(nativeImage, miplevel), animationMetaDataSection, (float)((TextureMapAccessor)texMap).getAnisotropicFiltering() > 1.0f);
        }

        @Override
        public CustomMipmapGenerator getMipmapGenerator(TextureAtlasSpriteInfo info, int atlasWidth, int atlasHeight) {
            if (info instanceof PBRTextureAtlasSpriteInfo) {
                CustomMipmapGenerator generator;
                PBRTextureAtlasSpriteInfo pbrInfo = (PBRTextureAtlasSpriteInfo)info;
                PBRType pbrType = pbrInfo.pbrType;
                TextureFormat format = TextureFormatLoader.getFormat();
                if (format != null && (generator = format.getMipmapGenerator(pbrType)) != null) {
                    return generator;
                }
            }
            return LINEAR_MIPMAP_GENERATOR;
        }
    }
}

