/*
 * Decompiled with CFR 0.152.
 */
package mist475.mcpatcherforge.asm.mappings;

import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mist475.mcpatcherforge.asm.mappings.NamerSrg;
import mist475.mcpatcherforge.asm.mappings.Names;

public class NamerMcp
extends NamerSrg {
    @Override
    public void setNames() {
        this.setNamesSrg();
        String confPath = System.getProperty("net.minecraftforge.gradle.GradleStart.csvDir", "../conf") + "/";
        this.lookupReobfName(confPath);
        this.rename(confPath);
    }

    public void rename(String confPath) {
        String s;
        Map<String, String> nameMap = this.loadNameMapCSV(confPath + "fields.csv");
        for (Names.Fiel f : this.af) {
            s = nameMap.get(f.name);
            if (s == null) continue;
            f.name = s;
        }
        nameMap = this.loadNameMapCSV(confPath + "methods.csv");
        for (Names.Meth m : this.am) {
            s = nameMap.get(m.name);
            if (s == null) continue;
            m.name = s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> loadNameMapCSV(String fileName) {
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader rd = null;
        try {
            String line;
            rd = new BufferedReader(new FileReader(fileName));
            rd.readLine();
            while ((line = rd.readLine()) != null) {
                String[] tokens = line.split(",");
                if (tokens.length <= 1) continue;
                map.put(tokens[0], tokens[1]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return map;
    }

    void lookupReobfName(String confPath) {
        String s;
        Map<String, String> nameMap = this.loadReobfMap(confPath + "packaged.srg");
        for (Names.Clas c : this.ac) {
            s = nameMap.get(c.name);
            AngelicaTweaker.LOGGER.trace("C {} {}", new Object[]{c.name, s});
        }
        for (Names.Fiel f : this.af) {
            s = nameMap.get(f.clas + "/" + f.name);
            AngelicaTweaker.LOGGER.trace("F {} {}", new Object[]{f.name, s});
        }
        for (Names.Meth m : this.am) {
            s = nameMap.get(m.clas + "/" + m.name + m.desc);
            AngelicaTweaker.LOGGER.trace("M {} {}", new Object[]{m.name, s});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> loadReobfMap(String fileName) {
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader rd = null;
        try {
            String line;
            rd = new BufferedReader(new FileReader(fileName));
            while ((line = rd.readLine()) != null) {
                String[] tokens = line.split(" ");
                if (tokens.length <= 1) continue;
                if ("CL:".equals(tokens[0])) {
                    map.put(tokens[2], tokens[1]);
                    continue;
                }
                if ("FD:".equals(tokens[0])) {
                    map.put(tokens[2], tokens[1]);
                    continue;
                }
                if (!"MD:".equals(tokens[0])) continue;
                map.put(tokens[3] + tokens[4], tokens[1].substring(tokens[1].lastIndexOf(47) + 1));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return map;
    }
}

