/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.loading;

import com.gtnewhorizons.angelica.config.AngelicaConfig;
import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import com.gtnewhorizons.angelica.transform.BlockTransformer;
import com.gtnewhorizons.angelica.transform.RedirectorTransformer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class MixinCompatHackTweaker
implements ITweaker {
    public static final boolean DISABLE_OPTIFINE_AND_FASTCRAFT = true;

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        this.verifyDependencies();
        AngelicaTweaker.LOGGER.info("Disabling Optifine and Fastcraft (if present)");
        this.disableOptifineAndFastcraft();
    }

    private void verifyDependencies() {
        if (MixinCompatHackTweaker.class.getResource("/it/unimi/dsi/fastutil/ints/Int2ObjectMap.class") == null) {
            throw new RuntimeException("Missing dependency: Angelica requires GTNHLib 0.2.1 or newer! Download: https://modrinth.com/mod/gtnhlib");
        }
    }

    private void disableOptifineAndFastcraft() {
        try {
            LaunchClassLoader lcl = Launch.classLoader;
            Field xformersField = lcl.getClass().getDeclaredField("transformers");
            xformersField.setAccessible(true);
            List xformers = (List)xformersField.get(lcl);
            for (int idx = xformers.size() - 1; idx >= 0; --idx) {
                String name = ((IClassTransformer)xformers.get(idx)).getClass().getName();
                if (!name.startsWith("optifine") && !name.startsWith("fastcraft")) continue;
                AngelicaTweaker.LOGGER.info("Removing transformer " + name);
                xformers.remove(idx);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            Field injectedContainersField = Loader.class.getDeclaredField("injectedContainers");
            injectedContainersField.setAccessible(true);
            List containers = (List)injectedContainersField.get(Loader.class);
            for (int idx = containers.size() - 1; idx >= 0; --idx) {
                String name = (String)containers.get(idx);
                if (!name.startsWith("optifine") && !name.startsWith("fastcraft")) continue;
                AngelicaTweaker.LOGGER.info("Removing mod container " + name);
                containers.remove(idx);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
    }

    public String getLaunchTarget() {
        return null;
    }

    public String[] getLaunchArguments() {
        if (FMLLaunchHandler.side().isClient()) {
            boolean rfbLoaded;
            boolean bl = rfbLoaded = Launch.blackboard.getOrDefault("angelica.rfbPluginLoaded", Boolean.FALSE) == Boolean.TRUE;
            if (!rfbLoaded) {
                Launch.classLoader.registerTransformer(RedirectorTransformer.class.getName());
            }
            if (AngelicaConfig.enableSodium) {
                Launch.classLoader.registerTransformer(BlockTransformer.class.getName());
            }
        }
        return new String[0];
    }
}

