/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import io.github.cdagaming.unicore.impl.Pair;
import io.github.cdagaming.unicore.impl.Tuple;
import io.github.cdagaming.unicore.utils.MathUtils;
import javax.annotation.Nonnull;
import net.minecraft.class_1600;

public class SliderControl
extends ExtendedButtonControl {
    private final float minValue;
    private final float maxValue;
    private final float valueStep;
    private final String windowTitle;
    private float sliderValue;
    private float denormalizedSlideValue;
    private boolean dragging;
    private Runnable onSlideEvent;

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString) {
        super(buttonId, (int)positionData.getFirst(), (int)positionData.getSecond(), (int)dimensions.getFirst(), (int)dimensions.getSecond(), "", new String[0]);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueStep = valueStep;
        this.windowTitle = displayString;
        this.setSliderValue(startValue);
    }

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Runnable onPushEvent) {
        this(buttonId, positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString);
        this.setOnClick(onPushEvent);
    }

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Pair<Runnable, Runnable> events) {
        this(buttonId, positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, events.getFirst());
        this.setOnHover(events.getSecond());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString) {
        this(ExtendedScreen.getNextIndex(), positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, new Pair<Runnable, Runnable>());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Runnable onPushEvent) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString);
        this.setOnClick(onPushEvent);
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Pair<Runnable, Runnable> events) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, events.getFirst());
        this.setOnHover(events.getSecond());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Tuple<Runnable, Runnable, Runnable> events) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, new Pair<Runnable, Runnable>(events.getFirst(), events.getSecond()));
        this.setOnSlide(events.getThird());
    }

    public int method_892(boolean mouseOver) {
        return 0;
    }

    @Override
    protected void method_893(@Nonnull class_1600 mc, int mouseX, int mouseY) {
        if (this.isControlVisible()) {
            super.method_893(mc, mouseX, mouseY);
            if (this.dragging) {
                this.setValueFromMouse(mouseX);
            }
            int hoverState = super.method_892(this.isHoveringOrFocusingOver());
            int hoverValue = 46 + hoverState * 20;
            RenderUtils.renderButton(mc, this.getControlPosX() + (int)(this.sliderValue * (float)(this.getControlWidth() - 8)), this.getControlPosY(), 0.0, hoverValue, 196.0, hoverValue, 4.0, 20.0, this.getZLevel(), RenderUtils.getButtonTextures());
        }
    }

    @Override
    public boolean method_894(@Nonnull class_1600 mc, int mouseX, int mouseY) {
        if (super.method_894(mc, mouseX, mouseY)) {
            this.setValueFromMouse(mouseX);
            this.dragging = true;
            return true;
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((float)(mouseX - (double)(this.getControlPosX() + 4)) / (float)(this.getControlWidth() - 8), true);
    }

    public void setSliderValue(float newValue, boolean useNormal) {
        if (useNormal) {
            this.sliderValue = MathUtils.clamp(newValue, 0.0f, 1.0f);
            this.denormalizedSlideValue = MathUtils.denormalizeValue(newValue, this.valueStep, this.minValue, this.maxValue);
        } else {
            this.sliderValue = MathUtils.normalizeValue(newValue, this.valueStep, this.minValue, this.maxValue);
            this.denormalizedSlideValue = MathUtils.clamp(newValue, this.minValue, this.maxValue);
        }
        this.onSlide();
    }

    public float getSliderValue(boolean useNormal) {
        return useNormal ? this.sliderValue : this.denormalizedSlideValue;
    }

    public float getSliderValue() {
        return this.getSliderValue(false);
    }

    public void setSliderValue(float newValue) {
        this.setSliderValue(newValue, false);
    }

    public void method_890(int mouseX, int mouseY) {
        this.dragging = false;
    }

    public void setOnSlide(Runnable event) {
        this.onSlideEvent = event;
    }

    public void onSlide() {
        if (this.onSlideEvent != null) {
            this.onSlideEvent.run();
        }
        this.setControlMessage(this.windowTitle + ": " + this.denormalizedSlideValue);
    }
}

