/*
 * Decompiled with CFR 0.152.
 */
package external.net.lenni0451.reflect.stream.constructor;

import external.net.lenni0451.reflect.Constructors;
import external.net.lenni0451.reflect.stream.RStream;
import external.net.lenni0451.reflect.stream.constructor.ConstructorStream;
import external.net.lenni0451.reflect.stream.general.ModifierWrapper;
import java.lang.reflect.Constructor;

public class ConstructorWrapper {
    private final ConstructorStream parent;
    private final Constructor<?> constructor;
    private final ModifierWrapper modifier;

    public ConstructorWrapper(ConstructorStream parent, Constructor<?> constructor) {
        this.parent = parent;
        this.constructor = constructor;
        this.modifier = new ModifierWrapper(constructor.getModifiers());
    }

    public ConstructorStream parent() {
        return this.parent;
    }

    public Constructor<?> raw() {
        return this.constructor;
    }

    public Class<?>[] parameterTypes() {
        return this.constructor.getParameterTypes();
    }

    public int parameterCount() {
        return this.constructor.getParameterCount();
    }

    public Class<?> owner() {
        return this.constructor.getDeclaringClass();
    }

    public ModifierWrapper modifier() {
        return this.modifier;
    }

    public <T> T newInstance(Object ... args) {
        return (T)Constructors.invoke(this.constructor, args);
    }

    public RStream streamInstance(Object ... args) {
        return RStream.of(this.newInstance(args));
    }

    public RStream streamInstance(Class<?> clazz, Object ... args) {
        return RStream.of(clazz, this.newInstance(args));
    }
}

