/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.nei;

import binnie.core.nei.RecipeHandlerBase;
import binnie.genetics.Genetics;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.item.ItemSerumArray;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class DatabaseRecipeHandler
extends RecipeHandlerBase {
    private static final List<DatabaseRecipe> recipes = new ArrayList<DatabaseRecipe>();

    @Override
    public void prepare() {
        recipes.add(new DatabaseRecipe(new ItemStack(Genetics.itemSerum, 1, Short.MAX_VALUE)));
        recipes.add(new DatabaseRecipe(new ItemStack((Item)Genetics.itemSerumArray, 1, Short.MAX_VALUE)));
    }

    public String getOverlayIdentifier() {
        return "genetics.database";
    }

    public String getGuiTexture() {
        return "genetics:textures/gui/nei/database.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"genetics.item.database.0.name");
    }

    public void loadTransferRects() {
        this.addTransferRect(75, 7, 24, 17);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)74);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(75, 7, 176, 0, 24, 17, 40, 0);
        List desc = GuiDraw.fontRenderer.func_78271_c(StatCollector.func_74837_a((String)"genetics.nei.tip.databaseDesc", (Object[])new Object[0]), 140);
        for (int i = 0; i < desc.size(); ++i) {
            GuiDraw.drawStringC((String)((String)desc.get(i)), (int)88, (int)(44 + 12 * (i - 1)), (int)0xFFFFFF);
        }
    }

    @Override
    public void loadAllRecipes() {
        for (DatabaseRecipe recipe : recipes) {
            this.arecipes.add(new CachedDatabaseRecipe(recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (DatabaseRecipe recipe : recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getSerum(), (ItemStack)result)) continue;
            this.arecipes.add(new CachedDatabaseRecipe(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (DatabaseRecipe recipe : recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getEmptySerum(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new CachedDatabaseRecipe(recipe));
        }
    }

    public class CachedDatabaseRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedStack serum;
        public PositionedStack emptySerum;

        public CachedDatabaseRecipe(DatabaseRecipe recipe) {
            if (recipe.getSerum() != null) {
                ArrayList<ItemStack> serums = new ArrayList<ItemStack>();
                for (ItemStack serumStack : ItemList.itemMap.get((Object)recipe.getSerum().func_77973_b())) {
                    if (serumStack.func_77978_p() == null) continue;
                    ItemStack temp = serumStack.func_77946_l();
                    temp.func_77964_b(temp.func_77958_k());
                    serums.add(temp);
                }
                this.emptySerum = new PositionedStack((Object)recipe.getEmptySerum(), 53, 7);
                this.serum = new PositionedStack(serums, 105, 7);
            }
        }

        public PositionedStack getIngredient() {
            this.serum.setPermutationToRender(DatabaseRecipeHandler.this.cycleticks / 40 % this.serum.items.length);
            return this.serum;
        }

        public PositionedStack getResult() {
            return this.emptySerum;
        }
    }

    private static class DatabaseRecipe {
        private final ItemStack serum;

        public DatabaseRecipe(ItemStack serum) {
            this.serum = serum;
        }

        public ItemStack getSerum() {
            return this.serum;
        }

        public ItemStack getEmptySerum() {
            return this.serum.func_77973_b() instanceof ItemSerumArray ? GeneticsItems.EmptyGenome.get(1) : GeneticsItems.EmptySerum.get(1);
        }
    }
}

