/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature.blobs.populators;

import chylex.hee.system.util.BlockPosM;
import chylex.hee.world.feature.blobs.BlobPopulator;
import chylex.hee.world.feature.util.DecoratorFeatureGenerator;
import chylex.hee.world.util.IRandomAmount;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class BlobPopulatorPlant
extends BlobPopulator {
    private Block plant;
    private IRandomAmount amountGen = IRandomAmount.exact;
    private byte minAttempts;
    private byte maxAttempts;
    private byte minPlantAmount;
    private byte maxPlantAmount;
    private boolean knownBlockLocations;

    public BlobPopulatorPlant(int weight) {
        super(weight);
    }

    public BlobPopulatorPlant block(Block plant) {
        this.plant = plant;
        return this;
    }

    public BlobPopulatorPlant attempts(int minAttempts, int maxAttempts) {
        this.minAttempts = (byte)minAttempts;
        this.maxAttempts = (byte)maxAttempts;
        return this;
    }

    public BlobPopulatorPlant blockAmount(IRandomAmount amountGen, int minPlantAmount, int maxPlantAmount) {
        this.amountGen = amountGen;
        this.minPlantAmount = (byte)minPlantAmount;
        this.maxPlantAmount = (byte)maxPlantAmount;
        return this;
    }

    public BlobPopulatorPlant knownBlockLocations() {
        this.knownBlockLocations = true;
        return this;
    }

    @Override
    public void generate(DecoratorFeatureGenerator gen, Random rand) {
        int blocks = this.amountGen.generate(rand, this.minPlantAmount, this.maxPlantAmount);
        List<BlockPosM> locs = this.knownBlockLocations ? gen.getUsedLocations() : null;
        int attempts = this.minAttempts + rand.nextInt(this.maxAttempts - this.minAttempts + 1);
        for (int attempt = 0; attempt < attempts && blocks > 0; ++attempt) {
            int z;
            int y;
            int x;
            if (this.knownBlockLocations) {
                if (locs.isEmpty()) {
                    return;
                }
                BlockPosM loc = locs.get(rand.nextInt(locs.size()));
                x = loc.x;
                y = loc.y;
                z = loc.z;
            } else {
                x = rand.nextInt(32) - 16;
                y = rand.nextInt(32) - 16;
                z = rand.nextInt(32) - 16;
            }
            if (gen.getBlock(x, y + 1, z) != Blocks.field_150350_a || gen.getBlock(x, y, z) != Blocks.field_150377_bs) continue;
            gen.setBlock(x, y + 1, z, this.plant);
            --blocks;
        }
    }
}

