/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe;

import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MoltenCellLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (!werkstoff.hasItemType(OrePrefixes.cellMolten)) {
            return;
        }
        if (!werkstoff.hasItemType(OrePrefixes.ingot)) {
            if (!werkstoff.hasItemType(OrePrefixes.dust)) {
                return;
            }
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.dust)}).fluidOutputs(new FluidStack[]{werkstoff.getMolten(144)}).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.dustSmall)}).fluidOutputs(new FluidStack[]{werkstoff.getMolten(36)}).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.dustTiny)}).fluidOutputs(new FluidStack[]{werkstoff.getMolten(16)}).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
        } else {
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.ingot)}).fluidOutputs(new FluidStack[]{werkstoff.getMolten(144)}).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.nugget)}).fluidOutputs(new FluidStack[]{werkstoff.getMolten(16)}).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Ingot.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.ingot)}).fluidInputs(new FluidStack[]{werkstoff.getMolten(144)}).duration((int)werkstoff.getStats().getMass()).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Nugget.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.nugget)}).fluidInputs(new FluidStack[]{werkstoff.getMolten(16)}).duration((int)((double)werkstoff.getStats().getMass() / 9.0)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Block.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.block)}).fluidInputs(new FluidStack[]{werkstoff.getMolten(1296)}).duration((int)werkstoff.getStats().getMass() * 9).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
            if (!werkstoff.hasItemType(OrePrefixes.plate)) {
                return;
            }
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.stickLong)}).fluidOutputs(new FluidStack[]{werkstoff.getMolten(144)}).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.plate)}).fluidOutputs(new FluidStack[]{werkstoff.getMolten(144)}).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.stick)}).fluidOutputs(new FluidStack[]{werkstoff.getMolten(72)}).duration(300).eut(2).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
        }
        if (werkstoff.getGenerationFeatures().hasMetalCraftingSolidifierRecipes()) {
            if (!werkstoff.hasItemType(OrePrefixes.plate)) {
                return;
            }
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Rod_Long.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.stickLong)}).fluidInputs(new FluidStack[]{werkstoff.getMolten(144)}).duration((int)Math.max(werkstoff.getStats().getMass(), 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Rod.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.stick)}).fluidInputs(new FluidStack[]{werkstoff.getMolten(72)}).duration((int)Math.max(werkstoff.getStats().getMass() / 2L, 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Plate.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.plate)}).fluidInputs(new FluidStack[]{werkstoff.getMolten(144)}).duration((int)Math.max(werkstoff.getStats().getMass(), 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
        }
        if (werkstoff.getGenerationFeatures().hasMetaSolidifierRecipes()) {
            if (!werkstoff.hasItemType(OrePrefixes.screw)) {
                return;
            }
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Screw.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.screw)}).fluidInputs(new FluidStack[]{werkstoff.getMolten(18)}).duration((int)Math.max(werkstoff.getStats().getMass() / 8L, 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Gear.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.gearGt)}).fluidInputs(new FluidStack[]{werkstoff.getMolten(576)}).duration((int)Math.max(werkstoff.getStats().getMass() / 4L, 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Gear_Small.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.gearGtSmall)}).fluidInputs(new FluidStack[]{werkstoff.getMolten(144)}).duration((int)Math.max(werkstoff.getStats().getMass(), 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Bolt.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.bolt)}).fluidInputs(new FluidStack[]{werkstoff.getMolten(18)}).duration((int)Math.max(werkstoff.getStats().getMass() / 8L, 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Ring.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.ring)}).fluidInputs(new FluidStack[]{werkstoff.getMolten(36)}).duration((int)Math.max(werkstoff.getStats().getMass() / 4L, 1L)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
            if (WerkstoffLoader.rotorMold == null) {
                return;
            }
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemList.Shape_Mold_Rotor.get(0L, new Object[0])}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.rotor)}).fluidInputs(new FluidStack[]{werkstoff.getMolten(612)}).duration((int)Math.max((double)werkstoff.getStats().getMass() * 4.25, 1.0)).eut(werkstoff.getStats().getMass() > 128L ? 64 : 30).addTo((IRecipeMap)RecipeMaps.fluidSolidifierRecipes);
        }
        if (werkstoff.getGenerationFeatures().hasMultipleMetalSolidifierRecipes() && !werkstoff.hasItemType(OrePrefixes.plateDouble)) {
            return;
        }
        FluidContainerRegistry.FluidContainerData data = new FluidContainerRegistry.FluidContainerData(new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.molten.get((Object)werkstoff)), 144), werkstoff.get(OrePrefixes.cellMolten), Materials.Empty.getCells(1));
        FluidContainerRegistry.registerFluidContainer((FluidStack)werkstoff.getMolten(144), (ItemStack)werkstoff.get(OrePrefixes.cellMolten), (ItemStack)Materials.Empty.getCells(1));
        GT_Utility.addFluidContainerData((FluidContainerRegistry.FluidContainerData)data);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{Materials.Empty.getCells(1)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.cellMolten)}).fluidInputs(new FluidStack[]{new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.molten.get((Object)werkstoff)), 144)}).duration(2).eut(2).addTo((IRecipeMap)RecipeMaps.fluidCannerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.cellMolten)}).itemOutputs(new ItemStack[]{Materials.Empty.getCells(1)}).fluidOutputs(new FluidStack[]{new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.molten.get((Object)werkstoff)), 144)}).duration(2).eut(2).addTo((IRecipeMap)RecipeMaps.fluidCannerRecipes);
        if (!Mods.Forestry.isModLoaded()) {
            return;
        }
        FluidContainerRegistry.FluidContainerData emptyData = new FluidContainerRegistry.FluidContainerData(new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.molten.get((Object)werkstoff)), 144), werkstoff.get(OrePrefixes.capsuleMolten), GT_ModHandler.getModItem((String)Mods.Forestry.ID, (String)"refractoryEmpty", (long)1L));
        FluidContainerRegistry.registerFluidContainer((FluidStack)werkstoff.getMolten(144), (ItemStack)werkstoff.get(OrePrefixes.capsuleMolten), (ItemStack)GT_ModHandler.getModItem((String)Mods.Forestry.ID, (String)"refractoryEmpty", (long)1L));
        GT_Utility.addFluidContainerData((FluidContainerRegistry.FluidContainerData)emptyData);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.capsuleMolten)}).fluidOutputs(new FluidStack[]{new FluidStack(Objects.requireNonNull((Fluid)WerkstoffLoader.molten.get((Object)werkstoff)), 144)}).duration(2).eut(2).addTo((IRecipeMap)RecipeMaps.fluidCannerRecipes);
    }
}

