/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe;

import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_RecipeConstants;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BlockLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (!werkstoff.hasItemType(OrePrefixes.block)) {
            return;
        }
        if (werkstoff.hasItemType(OrePrefixes.ingot)) {
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.block)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.ingot, 9)}).duration(16).eut(90).metadata(GT_RecipeConstants.RECYCLE, (Object)true).addTo(GT_RecipeConstants.UniversalArcFurnace);
        }
        if (werkstoff.hasItemType(OrePrefixes.cellMolten)) {
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.block)}).fluidOutputs(new FluidStack[]{werkstoff.getMolten(1296)}).recipeCategory(RecipeCategories.fluidExtractorRecycling).duration(288).eut(8).addTo((IRecipeMap)RecipeMaps.fluidExtractionRecipes);
        }
        if (werkstoff.hasItemType(OrePrefixes.plate)) {
            GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.block)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.plate, 9)}).duration((int)Math.max(werkstoff.getStats().getMass() * 10L, 1L)).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.cutterRecipes);
        }
    }
}

