/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.lib.command.CmdBase;
import serverutils.lib.command.CmdTreeBase;
import serverutils.lib.command.CmdTreeHelp;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.math.MathUtils;
import serverutils.lib.util.NBTUtils;
import serverutils.lib.util.StringUtils;
import serverutils.net.MessageEditNBT;
import serverutils.net.MessageEditNBTRequest;

public class CmdEditNBT
extends CmdTreeBase {
    public static Map<UUID, NBTTagCompound> EDITING = new HashMap<UUID, NBTTagCompound>();

    public CmdEditNBT() {
        super("nbtedit");
        this.addSubcommand(new CmdBlock());
        this.addSubcommand(new CmdEntity());
        this.addSubcommand(new CmdPlayer());
        this.addSubcommand(new CmdItem());
        this.addSubcommand((ICommand)new CmdTreeHelp(this));
    }

    private static void addInfo(NBTTagList list, IChatComponent key, IChatComponent value) {
        list.func_74742_a((NBTBase)new NBTTagString(IChatComponent.Serializer.func_150696_a((IChatComponent)StringUtils.color(key, EnumChatFormatting.BLUE).func_150258_a(": ").func_150257_a(StringUtils.color(value, EnumChatFormatting.GOLD)))));
    }

    @Override
    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            new MessageEditNBTRequest().sendTo(CmdEditNBT.func_71521_c((ICommandSender)sender));
        } else {
            super.func_71515_b(sender, args);
        }
    }

    private static class CmdBlock
    extends CmdNBT {
        private CmdBlock() {
            super("block");
        }

        @Override
        public NBTTagCompound editNBT(EntityPlayerMP player, NBTTagCompound info, String[] args) throws CommandException {
            this.checkArgs((ICommandSender)player, args, 3);
            int x = CmdBlock.func_71532_a((ICommandSender)player, (String)args[0], (int)-30000000, (int)30000000);
            int y = CmdBlock.func_71532_a((ICommandSender)player, (String)args[1], (int)-30000000, (int)30000000);
            int z = CmdBlock.func_71532_a((ICommandSender)player, (String)args[2], (int)-30000000, (int)30000000);
            TileEntity tile = player.field_70170_p.func_147438_o(x, y, z);
            NBTTagCompound nbt = new NBTTagCompound();
            if (tile == null) {
                player.func_145747_a(ServerUtilities.lang((ICommandSender)player, "commands.nbtedit.tile_not_found", player.field_70170_p.func_147439_a(x, y, z).func_149732_F()));
            } else {
                info.func_74778_a("type", "block");
                info.func_74768_a("x", x);
                info.func_74768_a("y", y);
                info.func_74768_a("z", z);
                tile.func_145841_b(nbt);
                nbt.func_82580_o("x");
                nbt.func_82580_o("y");
                nbt.func_82580_o("z");
                info.func_74778_a("id", nbt.func_74779_i("id"));
                nbt.func_82580_o("id");
                NBTTagList list = new NBTTagList();
                CmdEditNBT.addInfo(list, (IChatComponent)new ChatComponentText("Class"), (IChatComponent)new ChatComponentText(tile.getClass().getName()));
                String key = (String)TileEntity.field_145853_j.get(tile.getClass());
                CmdEditNBT.addInfo(list, (IChatComponent)new ChatComponentText("ID"), (IChatComponent)new ChatComponentText(key == null ? "null" : key.toString()));
                CmdEditNBT.addInfo(list, (IChatComponent)new ChatComponentText("Block"), (IChatComponent)new ChatComponentText(tile.func_145838_q().func_149732_F()));
                CmdEditNBT.addInfo(list, (IChatComponent)new ChatComponentText("Block Class"), (IChatComponent)new ChatComponentText(tile.func_145838_q().getClass().getName()));
                CmdEditNBT.addInfo(list, (IChatComponent)new ChatComponentText("Position"), (IChatComponent)new ChatComponentText("[" + x + ", " + y + ", " + z + "]"));
                ModContainer mod = null;
                for (ModContainer m : Loader.instance().getModList()) {
                    if (!tile.getClass().getName().contains(m.getModId())) continue;
                    mod = m;
                    break;
                }
                CmdEditNBT.addInfo(list, (IChatComponent)new ChatComponentText("Mod"), (IChatComponent)new ChatComponentText(mod == null ? "null" : mod.getName()));
                CmdEditNBT.addInfo(list, (IChatComponent)new ChatComponentText("Ticking"), (IChatComponent)new ChatComponentText(tile instanceof ITickable ? "true" : "false"));
                info.func_74782_a("text", (NBTBase)list);
                ChatComponentText title = new ChatComponentText(tile.getClass().getSimpleName());
                info.func_74778_a("title", IChatComponent.Serializer.func_150696_a((IChatComponent)title));
            }
            return nbt;
        }
    }

    private static class CmdEntity
    extends CmdNBT {
        private CmdEntity() {
            super("entity");
        }

        @Override
        public NBTTagCompound editNBT(EntityPlayerMP player, NBTTagCompound info, String[] args) throws CommandException {
            this.checkArgs((ICommandSender)player, args, 1);
            int id = CmdEntity.func_71526_a((ICommandSender)player, (String)args[0]);
            Entity entity = player.field_70170_p.func_73045_a(id);
            NBTTagCompound nbt = new NBTTagCompound();
            if (entity != null) {
                info.func_74778_a("type", "entity");
                info.func_74768_a("id", id);
                entity.func_70109_d(nbt);
                NBTTagList list = new NBTTagList();
                CmdEditNBT.addInfo(list, (IChatComponent)new ChatComponentText("Class"), (IChatComponent)new ChatComponentText(entity.getClass().getName()));
                String key = EntityList.func_75621_b((Entity)entity);
                CmdEditNBT.addInfo(list, (IChatComponent)new ChatComponentText("ID"), (IChatComponent)new ChatComponentText(key == null ? "null" : key));
                ModContainer mod = null;
                for (ModContainer m : Loader.instance().getModList()) {
                    if (!entity.getClass().getName().contains(m.getModId())) continue;
                    mod = m;
                    break;
                }
                CmdEditNBT.addInfo(list, (IChatComponent)new ChatComponentText("Mod"), (IChatComponent)new ChatComponentText(mod == null ? "null" : mod.getName()));
                info.func_74782_a("text", (NBTBase)list);
                info.func_74778_a("title", IChatComponent.Serializer.func_150696_a((IChatComponent)new ChatComponentText(key)));
            }
            return nbt;
        }
    }

    private static class CmdPlayer
    extends CmdNBT {
        private CmdPlayer() {
            super("player");
        }

        public List<String> func_71514_a() {
            return Collections.singletonList("me");
        }

        public boolean func_82358_a(String[] args, int index) {
            return index == 0;
        }

        @Override
        public NBTTagCompound editNBT(EntityPlayerMP player, NBTTagCompound info, String[] args) throws CommandException {
            ForgePlayer p = CommandUtils.getSelfOrOther((ICommandSender)player, args, 0);
            info.func_74757_a("online", p.isOnline());
            info.func_74778_a("type", "player");
            info.func_74778_a("id", p.getId().toString());
            NBTTagCompound nbt = p.getPlayerNBT();
            nbt.func_82580_o("id");
            NBTTagList list = new NBTTagList();
            CmdEditNBT.addInfo(list, (IChatComponent)new ChatComponentText("Name"), (IChatComponent)new ChatComponentText(player.func_146103_bH().getName()));
            CmdEditNBT.addInfo(list, (IChatComponent)new ChatComponentText("Display Name"), (IChatComponent)new ChatComponentText(player.getDisplayName()));
            CmdEditNBT.addInfo(list, (IChatComponent)new ChatComponentText("UUID"), (IChatComponent)new ChatComponentText(player.func_110124_au().toString()));
            CmdEditNBT.addInfo(list, (IChatComponent)new ChatComponentText("Team"), (IChatComponent)new ChatComponentText(p.team.getId()));
            info.func_74782_a("text", (NBTBase)list);
            info.func_74778_a("title", IChatComponent.Serializer.func_150696_a((IChatComponent)new ChatComponentText(player.getDisplayName())));
            return nbt;
        }
    }

    private static class CmdItem
    extends CmdNBT {
        private CmdItem() {
            super("item");
        }

        @Override
        public NBTTagCompound editNBT(EntityPlayerMP player, NBTTagCompound info, String[] args) {
            info.func_74778_a("type", "item");
            return player.func_70694_bm().func_77955_b(new NBTTagCompound());
        }
    }

    public static class CmdNBT
    extends CmdBase {
        private CmdNBT(String id) {
            super(id, CmdBase.Level.OP);
        }

        public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
            NBTTagCompound info;
            EntityPlayerMP player = CmdNBT.func_71521_c((ICommandSender)sender);
            NBTTagCompound nbt = this.editNBT(player, info = new NBTTagCompound(), args);
            long size = NBTUtils.getSizeInBytes(nbt, false);
            if (size >= 30000L) {
                throw ServerUtilities.error(sender, "commands.nbtedit.too_large", new Object[0]);
            }
            if (info.func_74764_b("type")) {
                info.func_74772_a("random", MathUtils.RAND.nextLong());
                EDITING.put(player.func_146103_bH().getId(), info);
                new MessageEditNBT(info, nbt).sendTo(player);
            }
        }

        public NBTTagCompound editNBT(EntityPlayerMP player, NBTTagCompound info, String[] args) throws CommandException {
            return new NBTTagCompound();
        }
    }
}

