/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.recipe;

import com.gtnewhorizons.modularui.api.math.Pos2d;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.RecipeDisplayInfo;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GodforgePlasmaFrontend
extends RecipeMapFrontend {
    public GodforgePlasmaFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder);
    }

    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        return Collections.singletonList(new Pos2d(52, 33));
    }

    public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
        return Collections.singletonList(new Pos2d(106, 33));
    }

    protected void drawEnergyInfo(RecipeDisplayInfo recipeInfo) {
        String string;
        long eut = recipeInfo.recipe.mEUt;
        long duration = recipeInfo.recipe.mDuration;
        String multistep = "No";
        if (recipeInfo.recipe.mSpecialItems.toString().equals("true")) {
            multistep = "Yes";
        }
        switch (recipeInfo.recipe.mSpecialValue) {
            case 1: {
                string = "T4-T5";
                break;
            }
            case 2: {
                string = "Exotic";
                break;
            }
            default: {
                string = "T1-T3";
            }
        }
        String requiredUpgrade = string;
        recipeInfo.drawText(GT_Utility.trans((String)"152", (String)"Total: ") + GT_Utility.formatNumbers((long)(eut * duration)) + " EU");
        recipeInfo.drawText(GT_Utility.trans((String)"153", (String)"Usage: ") + GT_Utility.formatNumbers((long)eut) + " EU/t");
        recipeInfo.drawText(GT_Utility.trans((String)"158", (String)"Time: ") + GT_Utility.formatNumbers((long)(duration / 20L)) + " secs");
        recipeInfo.drawText(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.plasmamultistep") + ": " + multistep);
        recipeInfo.drawText(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.FOG.plasmarecipetier") + ": " + requiredUpgrade);
    }

    protected void drawDurationInfo(RecipeDisplayInfo recipeInfo) {
    }
}

