/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.api.recipe.ExtremeHeatExchangerBackend;
import goodgenerator.api.recipe.ExtremeHeatExchangerRecipe;
import goodgenerator.api.recipe.GoodGeneratorRecipeMaps;
import goodgenerator.blocks.tileEntity.base.GT_MetaTileEntity_TooltipMultiBlockBase_EM;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.IGT_HatchAdder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ExtremeHeatExchanger
extends GT_MetaTileEntity_TooltipMultiBlockBase_EM
implements IConstructable,
ISurvivalConstructable {
    protected IStructureDefinition<ExtremeHeatExchanger> multiDefinition = null;
    public static double penalty_per_config = 0.015;
    protected int casingAmount = 0;
    protected GT_MetaTileEntity_Hatch_Input mHotFluidHatch;
    protected GT_MetaTileEntity_Hatch_Output mCooledFluidHatch;
    private boolean transformed = false;
    private String hotName;
    private ExtremeHeatExchangerRecipe tRunningRecipe;

    public ExtremeHeatExchanger(String name) {
        super(name);
    }

    public ExtremeHeatExchanger(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public IStructureDefinition<ExtremeHeatExchanger> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{" CCC ", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", " CCC "}, {" CCC ", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", " CCC "}, {" CFC ", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", " CEC "}, {" CCC ", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", " CCC "}, {" CCC ", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", " CCC "}, {" C~C ", "BBBBB", "BBBBB", "BBBBB", "BBBBB", "BBBBB", "BBBBB", "BBBBB", "BBBBB", "BBBBB", " CCC "}})).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(ExtremeHeatExchanger.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.Maintenance}).casingIndex(48).dot(1).build(), StructureUtility.onElementPass(x -> ++x.casingAmount, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)0))})).addElement('T', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(ExtremeHeatExchanger.class).atLeast(new IHatchElement[]{GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance}).casingIndex(48).dot(2).build(), StructureUtility.onElementPass(x -> ++x.casingAmount, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)0))})).addElement('F', EHEHatches.HotInputHatch.newAny(48, 3)).addElement('E', EHEHatches.ColdOutputHatch.newAny(48, 4)).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.buildHatchAdder(ExtremeHeatExchanger.class).atLeast(new IHatchElement[]{GT_HatchElement.Maintenance}).casingIndex(48).dot(5).build(), StructureUtility.onElementPass(x -> ++x.casingAmount, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)0))})).addElement('G', (IStructureElement)Glasses.chainAllGlasses()).addElement('P', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)15)).addElement('W', StructureUtility.ofBlock((Block)Loaders.pressureResistantWalls, (int)0)).build();
        }
        return this.multiDefinition;
    }

    public boolean addHotFluidInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.mHotFluidHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addColdFluidOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.mCooledFluidHatch = (GT_MetaTileEntity_Hatch_Output)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.transformed = aNBT.func_74767_n("transformed");
        if (aNBT.func_150297_b("hotName", 8)) {
            String loadedHotName = aNBT.func_74779_i("hotName");
            Fluid hotFluid = FluidRegistry.getFluid((String)loadedHotName);
            if (hotFluid != null) {
                this.hotName = loadedHotName;
                this.tRunningRecipe = (ExtremeHeatExchangerRecipe)((ExtremeHeatExchangerBackend)GoodGeneratorRecipeMaps.extremeHeatExchangerFuels.getBackend()).findFuel(hotFluid);
            }
        } else {
            this.hotName = null;
            this.tRunningRecipe = null;
        }
        super.loadNBTData(aNBT);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("transformed", this.transformed);
        if (this.hotName != null) {
            aNBT.func_74778_a("hotName", this.hotName);
        }
        super.saveNBTData(aNBT);
    }

    public RecipeMap<?> getRecipeMap() {
        return GoodGeneratorRecipeMaps.extremeHeatExchangerFuels;
    }

    protected void clearHatches_EM() {
        super.clearHatches_EM();
        this.mCooledFluidHatch = null;
        this.mHotFluidHatch = null;
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.casingAmount = 0;
        return this.structureCheck_EM(this.mName, 2, 5, 0) && this.mMaintenanceHatches.size() == 1 && this.casingAmount >= 25;
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Heat Exchanger/Plasma Heat Exchanger").addInfo("Controller block for the Extreme Heat Exchanger.").addInfo("Accept Hot fluid like lava, hot coolant or plasma.").addInfo("Output SC Steam/SH Steam/Steam.").addInfo("Check NEI for more info.").addInfo(DescTextLocalization.BLUE_PRINT_INFO).addSeparator().addController("Front bottom").addOtherStructurePart("Input Hatch", "distilled water", new int[]{1}).addOtherStructurePart("Output Hatch", "SC Steam/SH Steam/Steam", new int[]{2}).addOtherStructurePart("Input Hatch", "Hot fluid or plasma", new int[]{3}).addOtherStructurePart("Output Hatch", "Cold fluid", new int[]{4}).addMaintenanceHatch("Any Casing", new int[]{1, 2, 5}).addCasingInfoMin("Robust Tungstensteel Machine Casings", 25, false).toolTipFinisher("Good Generator");
        return tt;
    }

    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        int circuit_config;
        this.tRunningRecipe = null;
        if (this.mHotFluidHatch.getFluid() == null) {
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        ExtremeHeatExchangerRecipe tRecipe = (ExtremeHeatExchangerRecipe)((ExtremeHeatExchangerBackend)GoodGeneratorRecipeMaps.extremeHeatExchangerFuels.getBackend()).findFuel(this.mHotFluidHatch.getFluid());
        if (tRecipe == null) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.tRunningRecipe = tRecipe;
        this.hotName = this.mHotFluidHatch.getFluid().getFluid().getName();
        int tMaxConsume = tRecipe.getMaxHotFluidConsume();
        int transformed_threshold = tRecipe.mSpecialValue;
        int tRealConsume = Math.min(tMaxConsume, this.mHotFluidHatch.getFluid().amount);
        double penalty = 0.0;
        double efficiency = 1.0;
        int shs_reduction_per_config = 150;
        if (this.mInventory[1] != null && this.mInventory[1].func_77977_a().startsWith("gt.integrated_circuit") && (circuit_config = this.mInventory[1].func_77960_j()) >= 1 && circuit_config <= 25) {
            penalty = (double)(circuit_config - 1) * penalty_per_config;
            transformed_threshold -= shs_reduction_per_config * (circuit_config - 1);
        }
        efficiency -= penalty;
        if (transformed_threshold <= 0) {
            transformed_threshold = 1;
        }
        this.transformed = tRealConsume >= transformed_threshold;
        this.mMaxProgresstime = 20;
        this.mEUt = (int)((double)tRecipe.getEUt() * efficiency * ((double)tRealConsume / (double)tMaxConsume));
        this.mHotFluidHatch.drain(tRealConsume, true);
        this.mCooledFluidHatch.fill(new FluidStack(tRecipe.getCooledFluid(), tRealConsume), true);
        this.mEfficiencyIncrease = 160;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt > 0 && this.tRunningRecipe != null) {
            Fluid tReadySteam = this.transformed ? this.tRunningRecipe.getHeatedSteam() : this.tRunningRecipe.getNormalSteam();
            int waterAmount = (int)((double)this.mEUt / this.getUnitSteamPower(tReadySteam.getName())) / 160;
            if (waterAmount < 0) {
                return false;
            }
            if (this.depleteInput(GT_ModHandler.getDistilledWater((long)waterAmount))) {
                this.addOutput(new FluidStack(tReadySteam, waterAmount * 160));
            } else {
                GT_Log.exp.println(this.mName + " had no more Distilled water!");
                this.mHotFluidHatch.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
                return false;
            }
        }
        return true;
    }

    public double getUnitSteamPower(String steam) {
        switch (steam) {
            case "steam": {
                return 0.5;
            }
            case "ic2superheatedsteam": {
                return 1.0;
            }
            case "supercriticalsteam": {
                return 100.0;
            }
        }
        return -1.0;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(this.mName, 2, 5, 0, stackSize, hintsOnly);
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return DescTextLocalization.addText("ExtremeHeatExchanger.hint", 6);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new ExtremeHeatExchanger(this.mName);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public String[] getInfoData() {
        int tThreshold = this.tRunningRecipe != null ? this.tRunningRecipe.mSpecialValue : 0;
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)(this.mProgresstime / 20)) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)(this.mMaxProgresstime / 20)) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"scanner.info.XHE.0") + " " + (this.transformed ? EnumChatFormatting.RED : EnumChatFormatting.YELLOW) + GT_Utility.formatNumbers((long)this.mEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"scanner.info.XHE.1") + " " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)tThreshold) + EnumChatFormatting.RESET + " L/s"};
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48]};
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 2, 5, 0, elementBudget, env, false, true);
    }

    private static enum EHEHatches implements IHatchElement<ExtremeHeatExchanger>
    {
        HotInputHatch(ExtremeHeatExchanger::addHotFluidInputToMachineList, new Class[]{GT_MetaTileEntity_Hatch_Input.class}){

            public long count(ExtremeHeatExchanger t) {
                if (t.mHotFluidHatch == null) {
                    return 0L;
                }
                return 1L;
            }
        }
        ,
        ColdOutputHatch(ExtremeHeatExchanger::addColdFluidOutputToMachineList, new Class[]{GT_MetaTileEntity_Hatch_Output.class}){

            public long count(ExtremeHeatExchanger t) {
                if (t.mCooledFluidHatch == null) {
                    return 0L;
                }
                return 1L;
            }
        };

        private final List<Class<? extends IMetaTileEntity>> mteClasses;
        private final IGT_HatchAdder<ExtremeHeatExchanger> adder;

        private EHEHatches(IGT_HatchAdder<ExtremeHeatExchanger> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
            this.adder = adder;
        }

        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        public IGT_HatchAdder<? super ExtremeHeatExchanger> adder() {
            return this.adder;
        }
    }
}

