/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.block;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.ExtraUtilsProxy;
import com.rwtema.extrautils.block.BlockColorData;
import com.rwtema.extrautils.helper.XUHelper;
import com.rwtema.extrautils.item.ItemPaintbrush;
import com.rwtema.extrautils.network.packets.PacketTempChat;
import com.rwtema.extrautils.texture.TextureColorBlockBase;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockColor
extends Block {
    public static float[][] initColor = new float[16][3];
    public int curMetadata = 0;
    public boolean specialTexture;
    public String oreName;
    public Block baseBlock;
    public Object[] customRecipe = null;
    public int customRecipeNo = 0;

    public BlockColor(Block b, String orename) {
        this(b, orename, (String)ReflectionHelper.getPrivateValue(Block.class, (Object)b, (String[])new String[]{"textureName", "field_149768_d"}));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return super.func_149635_D();
    }

    public BlockColor(Block b, String orename, String texture) {
        super(b.func_149688_o());
        this.func_149711_c(((Float)ReflectionHelper.getPrivateValue(Block.class, (Object)b, (String[])new String[]{"blockHardness", "field_149782_v"})).floatValue());
        this.func_149752_b(((Float)ReflectionHelper.getPrivateValue(Block.class, (Object)b, (String[])new String[]{"blockResistance", "field_149781_w"})).floatValue());
        this.func_149672_a(b.field_149762_H);
        this.func_149658_d(texture);
        this.func_149663_c("extrautils:color_" + b.func_149739_a().substring(5));
        this.func_149715_a((float)b.func_149750_m() / 15.0f);
        this.func_149713_g(b.func_149717_k());
        this.oreName = orename;
        this.baseBlock = b;
        ExtraUtils.colorblocks.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IIconRegister) {
        if (!(par1IIconRegister instanceof TextureMap)) {
            return;
        }
        String t = this.func_149641_N();
        this.field_149761_L = ((TextureMap)par1IIconRegister).getTextureExtry("extrautils:bw_(" + t + ")");
        if (this.field_149761_L == null) {
            TextureColorBlockBase t2 = new TextureColorBlockBase(t);
            this.field_149761_L = t2;
            ((TextureMap)par1IIconRegister).setTextureEntry("extrautils:bw_(" + t + ")", (TextureAtlasSprite)t2);
        }
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        this.curMetadata = par2;
        return super.func_149691_a(par1, par2);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        if (par1IBlockAccess.func_147439_a(par2, par3, par4) == this) {
            this.curMetadata = par1IBlockAccess.func_72805_g(par2, par3, par4);
        }
        float[] col = BlockColorData.getColorData(par1IBlockAccess, par2, par3, par4, this.curMetadata);
        return (int)(col[0] * 255.0f) << 16 | (int)(col[1] * 255.0f) << 8 | (int)(col[2] * 255.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int p_149741_1_) {
        float[] col = initColor[p_149741_1_];
        return (int)(col[0] * 255.0f) << 16 | (int)(col[1] * 255.0f) << 8 | (int)(col[2] * 255.0f);
    }

    public int func_149645_b() {
        return ExtraUtilsProxy.colorBlockID;
    }

    public int func_149692_a(int par1) {
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < 16; ++j) {
            par3List.add(new ItemStack(par1, 1, j));
        }
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (par5EntityPlayer != null && par5EntityPlayer.func_71045_bC() != null) {
            ItemStack itemstack = par5EntityPlayer.func_71045_bC();
            int metadata = par1World.func_72805_g(par2, par3, par4);
            if (itemstack.func_77973_b() instanceof ItemArmor) {
                ItemArmor itemarmor = (ItemArmor)itemstack.func_77973_b();
                if (itemarmor.func_82816_b_(itemstack)) {
                    int l = itemarmor.func_82814_b(itemstack);
                    float r = (float)(l >> 16 & 0xFF) / 255.0f;
                    float g = (float)(l >> 8 & 0xFF) / 255.0f;
                    float b = (float)(l & 0xFF) / 255.0f;
                    if (BlockColorData.changeColorData(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), r, g, b)) {
                        return true;
                    }
                    PacketTempChat.sendChat(par5EntityPlayer, "Unable to change color at this location");
                }
            } else if (XUHelper.getDyeFromItemStack(itemstack) >= 0) {
                float p = 0.9f;
                float[] col1 = BlockColorData.getColorData((IBlockAccess)par1World, par2, par3, par4);
                float[] col2 = EntitySheep.field_70898_d[BlockColored.func_150032_b((int)XUHelper.getDyeFromItemStack(itemstack))];
                float r = (col1[0] + col2[0]) / 2.0f;
                float g = (col1[1] + col2[1]) / 2.0f;
                float b = (col1[2] + col2[2]) / 2.0f;
                float f = (Math.max(Math.max(col1[0], col1[1]), col1[2]) + Math.max(Math.max(col2[0], col2[1]), col2[2])) / 2.0f;
                float f1 = Math.max(r, Math.max(g, b));
                r = r * f / f1;
                g = g * f / f1;
                b = b * f / f1;
                r = col1[0] * p + col2[0] * (1.0f - p);
                g = col1[1] * p + col2[1] * (1.0f - p);
                b = col1[2] * p + col2[2] * (1.0f - p);
                if (BlockColorData.changeColorData(par1World, par2, par3, par4, metadata, r, g, b)) {
                    return true;
                }
                PacketTempChat.sendChat(par5EntityPlayer, "Unable to change color at this location");
            } else if (itemstack.func_77973_b() == Items.field_151068_bn & (Items.field_151068_bn.func_77832_l(itemstack) == null || Items.field_151068_bn.func_77832_l(itemstack).isEmpty())) {
                float r = initColor[metadata][0];
                float g = initColor[metadata][1];
                float b = initColor[metadata][2];
                if (BlockColorData.changeColorData(par1World, par2, par3, par4, metadata, r, g, b)) {
                    return true;
                }
                PacketTempChat.sendChat(par5EntityPlayer, "Unable to change color at this location");
            } else if (itemstack.func_77973_b() == ExtraUtils.paintBrush) {
                if (!par5EntityPlayer.func_70093_af()) {
                    float r = 1.0f;
                    float g = 1.0f;
                    float b = 1.0f;
                    NBTTagCompound tag = itemstack.func_77978_p();
                    if (tag != null) {
                        if (tag.func_74764_b("r")) {
                            r = (float)tag.func_74762_e("r") / 255.0f;
                        }
                        if (tag.func_74764_b("g")) {
                            g = (float)tag.func_74762_e("g") / 255.0f;
                        }
                        if (tag.func_74764_b("b")) {
                            b = (float)tag.func_74762_e("b") / 255.0f;
                        }
                    }
                    if (BlockColorData.changeColorData(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4), r, g, b)) {
                        return true;
                    }
                    PacketTempChat.sendChat(par5EntityPlayer, "Unable to change color at this location");
                } else {
                    float[] col = BlockColorData.getColorData((IBlockAccess)par1World, par2, par3, par4);
                    ItemPaintbrush.setColor(itemstack, (int)(col[0] * 255.0f), (int)(col[1] * 255.0f), (int)(col[2] * 255.0f), metadata);
                }
            }
        }
        return false;
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        int metadata = world.func_72805_g(x, y, z);
        float p = 0.9f;
        float[] col1 = BlockColorData.getColorData((IBlockAccess)world, x, y, z);
        float[] col2 = initColor[colour];
        float r = col1[0] * p + col2[0] * (1.0f - p);
        float g = col1[1] * p + col2[1] * (1.0f - p);
        float b = col1[2] * p + col2[2] * (1.0f - p);
        return BlockColorData.changeColorData(world, x, y, z, metadata, r, g, b);
    }

    public BlockColor setCustomRecipe(int customRecipeNo, Object ... customRecipe) {
        this.customRecipe = customRecipe;
        this.customRecipeNo = customRecipeNo;
        return this;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return this.baseBlock.func_149668_a(world, x, y, z);
    }

    public void func_149670_a(World p_149670_1_, int p_149670_2_, int p_149670_3_, int p_149670_4_, Entity p_149670_5_) {
        this.baseBlock.func_149670_a(p_149670_1_, p_149670_2_, p_149670_3_, p_149670_4_, p_149670_5_);
    }

    public boolean func_149744_f() {
        return this.baseBlock.func_149744_f();
    }

    public int func_149709_b(IBlockAccess p_149709_1_, int p_149709_2_, int p_149709_3_, int p_149709_4_, int p_149709_5_) {
        return this.baseBlock.func_149709_b(p_149709_1_, p_149709_2_, p_149709_3_, p_149709_4_, p_149709_5_);
    }

    static {
        float saturation = 0.85f;
        for (int i = 0; i < 16; ++i) {
            float r = EntitySheep.field_70898_d[i][0];
            float g = EntitySheep.field_70898_d[i][1];
            float b = EntitySheep.field_70898_d[i][2];
            float m = (r + g + b) / 3.0f * (1.0f - saturation);
            BlockColor.initColor[i][0] = r * saturation + m;
            BlockColor.initColor[i][1] = g * saturation + m;
            BlockColor.initColor[i][2] = b * saturation + m;
        }
    }
}

