/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.longs.utils;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import speiger.src.collections.longs.collections.LongCollection;
import speiger.src.collections.longs.collections.LongIterator;
import speiger.src.collections.longs.collections.LongSplititerator;
import speiger.src.collections.utils.SanityChecks;

public class LongSplititerators {
    public static Spliterator.OfLong createArrayJavaSplititerator(long[] array, int characteristics) {
        return LongSplititerators.createArrayJavaSplititerator(array, 0, array.length, characteristics);
    }

    public static Spliterator.OfLong createArrayJavaSplititerator(long[] array, int size, int characteristics) {
        return LongSplititerators.createArrayJavaSplititerator(array, 0, size, characteristics);
    }

    public static Spliterator.OfLong createArrayJavaSplititerator(long[] array, int offset, int size, int characteristics) {
        SanityChecks.checkArrayCapacity(array.length, offset, size);
        return new ArraySplitIterator(array, offset, size, characteristics);
    }

    public static Spliterator.OfLong createJavaSplititerator(LongCollection collection, int characteristics) {
        return new IteratorSpliterator(collection, characteristics);
    }

    public static Spliterator.OfLong createUnknownJavaSplititerator(LongIterator iterator, int characteristics) {
        return new IteratorSpliterator(iterator, characteristics);
    }

    public static Spliterator.OfLong createSizedJavaSplititerator(LongIterator iterator, long size, int characteristics) {
        return new IteratorSpliterator(iterator, size, characteristics);
    }

    public static LongSplititerator createArraySplititerator(long[] array, int characteristics) {
        return LongSplititerators.createArraySplititerator(array, 0, array.length, characteristics);
    }

    public static LongSplititerator createArraySplititerator(long[] array, int size, int characteristics) {
        return LongSplititerators.createArraySplititerator(array, 0, size, characteristics);
    }

    public static LongSplititerator createArraySplititerator(long[] array, int offset, int size, int characteristics) {
        SanityChecks.checkArrayCapacity(array.length, offset, size);
        return new TypeArraySplitIterator(array, offset, size, characteristics);
    }

    public static LongSplititerator createSplititerator(LongCollection collection, int characteristics) {
        return new TypeIteratorSpliterator(collection, characteristics);
    }

    public static LongSplititerator createUnknownSplititerator(LongIterator iterator, int characteristics) {
        return new TypeIteratorSpliterator(iterator, characteristics);
    }

    public static LongSplititerator createSizedSplititerator(LongIterator iterator, long size, int characteristics) {
        return new TypeIteratorSpliterator(iterator, size, characteristics);
    }

    static final class ArraySplitIterator
    implements Spliterator.OfLong {
        private final long[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public ArraySplitIterator(long[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            ArraySplitIterator arraySplitIterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                arraySplitIterator = null;
            } else {
                this.index = mid;
                ArraySplitIterator arraySplitIterator2 = new ArraySplitIterator(this.array, lo, this.index, this.characteristics);
                arraySplitIterator = arraySplitIterator2;
            }
            return arraySplitIterator;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static class IteratorSpliterator
    implements Spliterator.OfLong {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final LongCollection collection;
        private LongIterator it;
        private final int characteristics;
        private long est;
        private int batch;

        IteratorSpliterator(LongCollection collection, int characteristics) {
            this.collection = collection;
            this.it = null;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        IteratorSpliterator(LongIterator iterator, long size, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        IteratorSpliterator(LongIterator iterator, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        private LongIterator iterator() {
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
            }
            return this.it;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            LongIterator i = this.iterator();
            if (this.est > 1L && i.hasNext()) {
                int n = Math.min(this.batch + 1024, Math.min((int)this.est, 0x2000000));
                long[] a = new long[n];
                int j = 0;
                do {
                    a[j] = i.nextLong();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new ArraySplitIterator(a, 0, j, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            this.iterator().forEachRemaining((long T) -> action.accept(T));
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            LongIterator iter = this.iterator();
            if (iter.hasNext()) {
                action.accept(iter.nextLong());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            this.iterator();
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    static final class TypeArraySplitIterator
    implements LongSplititerator {
        private final long[] array;
        private int index;
        private final int fence;
        private final int characteristics;

        public TypeArraySplitIterator(long[] array, int origin, int fence, int additionalCharacteristics) {
            this.array = array;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public LongSplititerator trySplit() {
            TypeArraySplitIterator typeArraySplitIterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                typeArraySplitIterator = null;
            } else {
                this.index = mid;
                TypeArraySplitIterator typeArraySplitIterator2 = new TypeArraySplitIterator(this.array, lo, this.index, this.characteristics);
                typeArraySplitIterator = typeArraySplitIterator2;
            }
            return typeArraySplitIterator;
        }

        @Override
        public void forEachRemaining(speiger.src.collections.longs.functions.LongConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            long[] a = this.array;
            int hi = this.fence;
            if (this.array.length >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(a[i]);
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(speiger.src.collections.longs.functions.LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept((Long)this.array[this.index++]);
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }

        @Override
        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.index++];
        }

        @Override
        public boolean hasNext() {
            return this.index < this.fence;
        }
    }

    static class TypeIteratorSpliterator
    implements LongSplititerator {
        static final int BATCH_UNIT = 1024;
        static final int MAX_BATCH = 0x2000000;
        private final LongCollection collection;
        private LongIterator it;
        private final int characteristics;
        private long est;
        private int batch;

        TypeIteratorSpliterator(LongCollection collection, int characteristics) {
            this.collection = collection;
            this.it = null;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        TypeIteratorSpliterator(LongIterator iterator, long size, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = size;
            this.characteristics = (characteristics & 0x1000) == 0 ? characteristics | 0x40 | 0x4000 : characteristics;
        }

        TypeIteratorSpliterator(LongIterator iterator, int characteristics) {
            this.collection = null;
            this.it = iterator;
            this.est = Long.MAX_VALUE;
            this.characteristics = characteristics & 0xFFFFBFBF;
        }

        private LongIterator iterator() {
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.est = this.collection.size();
            }
            return this.it;
        }

        @Override
        public LongSplititerator trySplit() {
            LongIterator i = this.iterator();
            if (this.est > 1L && i.hasNext()) {
                int n = Math.min(this.batch + 1024, Math.min((int)this.est, 0x2000000));
                long[] a = new long[n];
                int j = 0;
                do {
                    a[j] = i.nextLong();
                } while (++j < n && i.hasNext());
                this.batch = j;
                if (this.est != Long.MAX_VALUE) {
                    this.est -= (long)j;
                }
                return new TypeArraySplitIterator(a, 0, j, this.characteristics);
            }
            return null;
        }

        @Override
        public void forEachRemaining(speiger.src.collections.longs.functions.LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            this.iterator().forEachRemaining(action);
        }

        @Override
        public boolean tryAdvance(speiger.src.collections.longs.functions.LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            LongIterator iter = this.iterator();
            if (iter.hasNext()) {
                action.accept(iter.nextLong());
                return true;
            }
            return false;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Long> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            LongIterator iter = this.iterator();
            if (iter.hasNext()) {
                action.accept((Long)iter.nextLong());
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            this.iterator();
            return this.est;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }

        @Override
        public long nextLong() {
            return this.iterator().nextLong();
        }

        @Override
        public boolean hasNext() {
            return this.iterator().hasNext();
        }
    }
}

