/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.ints.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntPredicate;
import speiger.src.collections.ints.collections.IntBidirectionalIterator;
import speiger.src.collections.ints.collections.IntCollection;
import speiger.src.collections.ints.collections.IntIterator;
import speiger.src.collections.ints.functions.IntComparator;
import speiger.src.collections.ints.functions.IntConsumer;
import speiger.src.collections.ints.functions.function.IntFunction;
import speiger.src.collections.ints.lists.IntListIterator;
import speiger.src.collections.ints.utils.IntCollections;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.utils.ObjectIterators;

public class IntIterators {
    private static final EmptyIterator EMPTY = new EmptyIterator();

    public static EmptyIterator empty() {
        return EMPTY;
    }

    public static IntBidirectionalIterator invert(IntBidirectionalIterator it) {
        return it instanceof ReverseBiIterator ? ((ReverseBiIterator)it).it : new ReverseBiIterator(it);
    }

    public static IntListIterator invert(IntListIterator it) {
        return it instanceof ReverseListIterator ? ((ReverseListIterator)it).it : new ReverseListIterator(it);
    }

    public static IntIterator unmodifiable(IntIterator iterator) {
        return iterator instanceof UnmodifiableIterator ? iterator : new UnmodifiableIterator(iterator);
    }

    public static IntBidirectionalIterator unmodifiable(IntBidirectionalIterator iterator) {
        return iterator instanceof UnmodifiableBiIterator ? iterator : new UnmodifiableBiIterator(iterator);
    }

    public static IntListIterator unmodifiable(IntListIterator iterator) {
        return iterator instanceof UnmodifiableListIterator ? iterator : new UnmodifiableListIterator(iterator);
    }

    public static <E> ObjectIterator<E> map(Iterator<? extends Integer> iterator, IntFunction<E> mapper) {
        return new MappedIterator<E>(IntIterators.wrap(iterator), mapper);
    }

    public static <E> ObjectIterator<E> map(IntIterator iterator, IntFunction<E> mapper) {
        return new MappedIterator<E>(iterator, mapper);
    }

    public static <E, V extends Iterable<E>> ObjectIterator<E> flatMap(Iterator<? extends Integer> iterator, IntFunction<V> mapper) {
        return new FlatMappedIterator(IntIterators.wrap(iterator), mapper);
    }

    public static <E, V extends Iterable<E>> ObjectIterator<E> flatMap(IntIterator iterator, IntFunction<V> mapper) {
        return new FlatMappedIterator(iterator, mapper);
    }

    public static <E> ObjectIterator<E> arrayFlatMap(Iterator<? extends Integer> iterator, IntFunction<E[]> mapper) {
        return new FlatMappedArrayIterator(IntIterators.wrap(iterator), mapper);
    }

    public static <E> ObjectIterator<E> arrayFlatMap(IntIterator iterator, IntFunction<E[]> mapper) {
        return new FlatMappedArrayIterator(iterator, mapper);
    }

    public static IntIterator filter(Iterator<? extends Integer> iterator, IntPredicate filter) {
        return new FilteredIterator(IntIterators.wrap(iterator), filter);
    }

    public static IntIterator filter(IntIterator iterator, IntPredicate filter) {
        return new FilteredIterator(iterator, filter);
    }

    public static IntIterator distinct(IntIterator iterator) {
        return new DistinctIterator(iterator);
    }

    public static IntIterator distinct(Iterator<? extends Integer> iterator) {
        return new DistinctIterator(IntIterators.wrap(iterator));
    }

    public static IntIterator repeat(IntIterator iterator, int repeats) {
        return new RepeatingIterator(iterator, repeats);
    }

    public static IntIterator repeat(Iterator<? extends Integer> iterator, int repeats) {
        return new RepeatingIterator(IntIterators.wrap(iterator), repeats);
    }

    public static IntIterator limit(IntIterator iterator, long limit) {
        return new LimitedIterator(iterator, limit);
    }

    public static IntIterator limit(Iterator<? extends Integer> iterator, long limit) {
        return new LimitedIterator(IntIterators.wrap(iterator), limit);
    }

    public static IntIterator sorted(IntIterator iterator, IntComparator sorter) {
        return new SortedIterator(iterator, sorter);
    }

    public static IntIterator sorted(Iterator<? extends Integer> iterator, IntComparator sorter) {
        return new SortedIterator(IntIterators.wrap(iterator), sorter);
    }

    public static IntIterator peek(IntIterator iterator, IntConsumer action) {
        return new PeekIterator(iterator, action);
    }

    public static IntIterator peek(Iterator<? extends Integer> iterator, IntConsumer action) {
        return new PeekIterator(IntIterators.wrap(iterator), action);
    }

    public static IntIterator wrap(Iterator<? extends Integer> iterator) {
        return iterator instanceof IntIterator ? (IntIterator)iterator : new IteratorWrapper(iterator);
    }

    public static ArrayIterator wrap(int ... a) {
        return IntIterators.wrap(a, 0, a.length);
    }

    public static ArrayIterator wrap(int[] a, int start, int end) {
        return new ArrayIterator(a, start, end);
    }

    public static int unwrap(int[] a, Iterator<? extends Integer> i) {
        return IntIterators.unwrap(a, i, 0, a.length);
    }

    public static int unwrap(int[] a, Iterator<? extends Integer> i, int offset) {
        return IntIterators.unwrap(a, i, offset, a.length - offset);
    }

    public static int unwrap(int[] a, Iterator<? extends Integer> i, int offset, int max) {
        int index;
        if (max < 0) {
            throw new IllegalStateException("The max size is smaller then 0");
        }
        if (offset + max > a.length) {
            throw new IllegalStateException("largest array index exceeds array size");
        }
        for (index = 0; index < max && i.hasNext(); ++index) {
            a[index + offset] = i.next();
        }
        return index;
    }

    public static int unwrap(int[] a, IntIterator i) {
        return IntIterators.unwrap(a, i, 0, a.length);
    }

    public static int unwrap(int[] a, IntIterator i, int offset) {
        return IntIterators.unwrap(a, i, offset, a.length - offset);
    }

    public static int unwrap(int[] a, IntIterator i, int offset, int max) {
        int index;
        if (max < 0) {
            throw new IllegalStateException("The max size is smaller then 0");
        }
        if (offset + max > a.length) {
            throw new IllegalStateException("largest array index exceeds array size");
        }
        for (index = 0; index < max && i.hasNext(); ++index) {
            a[index + offset] = i.nextInt();
        }
        return index;
    }

    public static int unwrap(Integer[] a, IntIterator i) {
        return IntIterators.unwrap(a, i, 0, a.length);
    }

    public static int unwrap(Integer[] a, IntIterator i, int offset) {
        return IntIterators.unwrap(a, i, offset, a.length - offset);
    }

    public static int unwrap(Integer[] a, IntIterator i, int offset, int max) {
        int index;
        if (max < 0) {
            throw new IllegalStateException("The max size is smaller then 0");
        }
        if (offset + max > a.length) {
            throw new IllegalStateException("largest array index exceeds array size");
        }
        for (index = 0; index < max && i.hasNext(); ++index) {
            a[index + offset] = i.nextInt();
        }
        return index;
    }

    public static int pour(IntIterator iter, IntCollection c) {
        return IntIterators.pour(iter, c, Integer.MAX_VALUE);
    }

    public static int pour(IntIterator iter, IntCollection c, int max) {
        int done;
        if (max < 0) {
            throw new IllegalStateException("Max is negative");
        }
        for (done = 0; done < max && iter.hasNext(); ++done) {
            c.add(iter.nextInt());
        }
        return done;
    }

    public static IntIterator concat(IntIterator ... array) {
        return IntIterators.concat(array, 0, array.length);
    }

    public static IntIterator concat(IntIterator[] array, int offset, int length) {
        return new ConcatIterator(array, offset, length);
    }

    private static class PeekIterator
    implements IntIterator {
        IntIterator iterator;
        IntConsumer action;

        public PeekIterator(IntIterator iterator, IntConsumer action) {
            this.iterator = iterator;
            this.action = action;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int result = this.iterator.nextInt();
            this.action.accept(result);
            return result;
        }
    }

    private static class LimitedIterator
    implements IntIterator {
        IntIterator iterator;
        long limit;

        public LimitedIterator(IntIterator iterator, long limit) {
            this.iterator = iterator;
            this.limit = limit;
        }

        @Override
        public boolean hasNext() {
            return this.limit > 0L && this.iterator.hasNext();
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.limit;
            return this.iterator.nextInt();
        }
    }

    private static class FilteredIterator
    implements IntIterator {
        IntIterator iterator;
        IntPredicate filter;
        int lastFound;
        boolean foundNext = false;

        public FilteredIterator(IntIterator iterator, IntPredicate filter) {
            this.iterator = iterator;
            this.filter = filter;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            while (this.iterator.hasNext()) {
                this.lastFound = this.iterator.nextInt();
                if (!this.filter.test(this.lastFound)) continue;
                this.foundNext = true;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.foundNext;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.foundNext = false;
            return this.lastFound;
        }
    }

    private static class DistinctIterator
    implements IntIterator {
        IntIterator iterator;
        IntCollection filtered = IntCollections.distinctWrapper();
        int lastFound;
        boolean foundNext = false;

        public DistinctIterator(IntIterator iterator) {
            this.iterator = iterator;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            while (this.iterator.hasNext()) {
                this.lastFound = this.iterator.nextInt();
                if (!this.filtered.add(this.lastFound)) continue;
                this.foundNext = true;
                break;
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.foundNext;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.foundNext = false;
            return this.lastFound;
        }
    }

    private static class SortedIterator
    implements IntIterator {
        IntIterator iterator;
        IntComparator sorter;
        IntCollections.CollectionWrapper sortedElements = null;
        int index = 0;

        public SortedIterator(IntIterator iterator, IntComparator sorter) {
            this.iterator = iterator;
            this.sorter = sorter;
        }

        @Override
        public boolean hasNext() {
            if (this.sortedElements == null) {
                boolean hasNext = this.iterator.hasNext();
                if (hasNext) {
                    this.sortedElements = IntCollections.wrapper();
                    IntIterators.pour(this.iterator, this.sortedElements);
                } else {
                    this.sortedElements = IntCollections.wrapper();
                }
                if (hasNext) {
                    this.sortedElements.unstableSort(this.sorter);
                }
            }
            return this.index < this.sortedElements.size();
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.sortedElements.getInt(this.index++);
        }
    }

    private static class RepeatingIterator
    implements IntIterator {
        final int repeats;
        int index = 0;
        IntIterator iter;
        IntCollection repeater = IntCollections.wrapper();

        public RepeatingIterator(IntIterator iter, int repeat) {
            this.iter = iter;
            this.repeats = repeat;
        }

        @Override
        public boolean hasNext() {
            if (this.iter.hasNext()) {
                return true;
            }
            if (this.index < this.repeats) {
                ++this.index;
                this.iter = this.repeater.iterator();
                return this.iter.hasNext();
            }
            return false;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int value = this.iter.nextInt();
            if (this.index == 0) {
                this.repeater.add(value);
            }
            return value;
        }
    }

    private static class FlatMappedArrayIterator<T>
    implements ObjectIterator<T> {
        IntIterator iterator;
        Iterator<T> last = null;
        IntFunction<T[]> mapper;
        boolean foundNext = false;

        FlatMappedArrayIterator(IntIterator iterator, IntFunction<T[]> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            this.foundNext = true;
            while (this.iterator.hasNext()) {
                if (this.last != null && this.last.hasNext()) {
                    return;
                }
                this.last = ObjectIterators.wrap(this.mapper.apply(this.iterator.nextInt()));
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.last != null && this.last.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T result = this.last.next();
            this.foundNext = false;
            return result;
        }
    }

    private static class FlatMappedIterator<T, V extends Iterable<T>>
    implements ObjectIterator<T> {
        IntIterator iterator;
        Iterator<T> last = null;
        IntFunction<V> mapper;
        boolean foundNext = false;

        FlatMappedIterator(IntIterator iterator, IntFunction<V> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
        }

        void compute() {
            if (this.foundNext) {
                return;
            }
            this.foundNext = true;
            while (this.iterator.hasNext()) {
                if (this.last != null && this.last.hasNext()) {
                    return;
                }
                this.last = ((Iterable)this.mapper.apply(this.iterator.nextInt())).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            this.compute();
            return this.last != null && this.last.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T result = this.last.next();
            this.foundNext = false;
            return result;
        }
    }

    private static class MappedIterator<T>
    implements ObjectIterator<T> {
        IntIterator iterator;
        IntFunction<T> mapper;

        MappedIterator(IntIterator iterator, IntFunction<T> mapper) {
            this.iterator = iterator;
            this.mapper = mapper;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.mapper.apply(this.iterator.nextInt());
        }

        @Override
        public int skip(int amount) {
            return this.iterator.skip(amount);
        }
    }

    private static class ArrayIterator
    implements IntIterator {
        int[] a;
        int from;
        int to;

        ArrayIterator(int[] a, int from, int to) {
            this.a = a;
            this.from = from;
            this.to = to;
        }

        @Override
        public boolean hasNext() {
            return this.from < this.to;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.a[this.from++];
        }

        @Override
        public int skip(int amount) {
            if (amount < 0) {
                throw new IllegalStateException("Negative Numbers are not allowed");
            }
            int left = Math.min(amount, this.to - this.from);
            this.from += left;
            return amount - left;
        }
    }

    private static class EmptyIterator
    implements IntListIterator {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public int previousInt() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(int e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int e) {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableIterator
    implements IntIterator {
        IntIterator iterator;

        UnmodifiableIterator(IntIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public int nextInt() {
            return this.iterator.nextInt();
        }
    }

    private static class UnmodifiableBiIterator
    implements IntBidirectionalIterator {
        IntBidirectionalIterator iter;

        UnmodifiableBiIterator(IntBidirectionalIterator iter) {
            this.iter = iter;
        }

        @Override
        public int nextInt() {
            return this.iter.nextInt();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public int previousInt() {
            return this.iter.previousInt();
        }
    }

    private static class UnmodifiableListIterator
    implements IntListIterator {
        IntListIterator iter;

        UnmodifiableListIterator(IntListIterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.iter.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iter.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previousInt() {
            return this.iter.previousInt();
        }

        @Override
        public int nextInt() {
            return this.iter.nextInt();
        }

        @Override
        public void set(int e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int e) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReverseListIterator
    implements IntListIterator {
        IntListIterator it;

        ReverseListIterator(IntListIterator it) {
            this.it = it;
        }

        @Override
        public int nextInt() {
            return this.it.previousInt();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasPrevious();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasNext();
        }

        @Override
        public int previousInt() {
            return this.it.nextInt();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public int nextIndex() {
            return this.it.previousIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.nextIndex();
        }

        @Override
        public void set(int e) {
            this.it.set(e);
        }

        @Override
        public void add(int e) {
            this.it.add(e);
        }
    }

    private static class ReverseBiIterator
    implements IntBidirectionalIterator {
        IntBidirectionalIterator it;

        ReverseBiIterator(IntBidirectionalIterator it) {
            this.it = it;
        }

        @Override
        public int nextInt() {
            return this.it.previousInt();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasPrevious();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasNext();
        }

        @Override
        public int previousInt() {
            return this.it.nextInt();
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    private static class ConcatIterator
    implements IntIterator {
        IntIterator[] iters;
        int offset;
        int lastOffset = -1;
        int length;

        public ConcatIterator(IntIterator[] iters, int offset, int length) {
            this.iters = iters;
            this.offset = offset;
            this.length = length;
            this.find();
        }

        private void find() {
            while (this.length != 0 && !this.iters[this.offset].hasNext()) {
                --this.length;
                ++this.offset;
            }
        }

        @Override
        public boolean hasNext() {
            return this.length > 0;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastOffset = this.offset;
            int result = this.iters[this.lastOffset].nextInt();
            this.find();
            return result;
        }

        @Override
        public void remove() {
            if (this.lastOffset == -1) {
                throw new IllegalStateException();
            }
            this.iters[this.lastOffset].remove();
            this.lastOffset = -1;
        }
    }

    private static class IteratorWrapper
    implements IntIterator {
        Iterator<? extends Integer> iter;

        public IteratorWrapper(Iterator<? extends Integer> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public int nextInt() {
            return this.iter.next();
        }

        @Override
        @Deprecated
        public Integer next() {
            return this.iter.next();
        }
    }
}

