/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_NumericWidget;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_FluidLimiter
extends GT_CoverBehaviorBase<FluidLimiterData> {
    public GT_Cover_FluidLimiter(ITexture coverTexture) {
        super(FluidLimiterData.class, coverTexture);
    }

    @Override
    protected FluidLimiterData onCoverScrewdriverClickImpl(ForgeDirection side, int aCoverID, FluidLimiterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aTileEntity instanceof IFluidHandler) {
            this.adjustThreshold(aCoverVariable, !aPlayer.func_70093_af());
            GT_Utility.sendChatToPlayer(aPlayer, String.format("Threshold: %f", Float.valueOf(aCoverVariable.threshold)));
        }
        return aCoverVariable;
    }

    @Override
    protected boolean letsFluidInImpl(ForgeDirection side, int aCoverID, FluidLimiterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.allowsFluidIn(aCoverVariable, aTileEntity);
    }

    @Override
    protected boolean alwaysLookConnectedImpl(ForgeDirection side, int aCoverID, FluidLimiterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    private boolean allowsFluidIn(FluidLimiterData aCoverVariable, ICoverable c) {
        if (c instanceof IFluidHandler) {
            return aCoverVariable.threshold > this.getFillLevelInputSlots((IFluidHandler)c);
        }
        return false;
    }

    private void adjustThreshold(FluidLimiterData coverVariable, boolean way) {
        if (way) {
            if (coverVariable.threshold + 0.05f > 1.0f) {
                coverVariable.threshold = 0.0f;
                return;
            }
            coverVariable.threshold += 0.05f;
        } else {
            if (Math.abs(coverVariable.threshold) - 0.05f < 0.0f) {
                coverVariable.threshold = 1.0f;
                return;
            }
            coverVariable.threshold -= 0.05f;
        }
    }

    private float getFillLevelInputSlots(IFluidHandler fh) {
        FluidTankInfo[] tankInfo = fh.getTankInfo(ForgeDirection.UNKNOWN);
        if (tankInfo != null) {
            FluidTankInfo inputSlot = tankInfo[0];
            if (inputSlot.fluid != null) {
                long tMax = inputSlot.capacity;
                long tUsed = inputSlot.fluid.amount;
                return (float)tUsed / (float)tMax;
            }
        }
        return 0.0f;
    }

    @Override
    public FluidLimiterData createDataObject(int aLegacyData) {
        return this.createDataObject();
    }

    @Override
    public FluidLimiterData createDataObject() {
        return new FluidLimiterData(1.0f);
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        return new FluidLimiterUIFactory(buildContext).createWindow();
    }

    public static class FluidLimiterData
    implements ISerializableObject {
        private float threshold;

        public FluidLimiterData(float threshold) {
            this.threshold = threshold;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new FluidLimiterData(this.threshold);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74776_a("threshold", this.threshold);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeFloat(this.threshold);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            if (aNBT instanceof NBTTagCompound) {
                NBTTagCompound tag = (NBTTagCompound)aNBT;
                this.threshold = tag.func_74760_g("threshold");
            }
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, @Nullable EntityPlayerMP aPlayer) {
            this.threshold = aBuf.readFloat();
            return this;
        }
    }

    private class FluidLimiterUIFactory
    extends GT_CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public FluidLimiterUIFactory(GT_CoverUIBuildContext buildContext) {
            super(GT_Cover_FluidLimiter.this, buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            ((ModularWindow.Builder)builder.widget((Widget)new CoverDataControllerWidget<FluidLimiterData>(this::getCoverData, this::setCoverData, GT_Cover_FluidLimiter.this).addFollower((Widget)new CoverDataFollower_NumericWidget(), coverData -> Math.round(((FluidLimiterData)coverData).threshold * 100.0f), (coverData, val) -> {
                ((FluidLimiterData)coverData).threshold = val.floatValue() / 100.0f;
                return coverData;
            }, widget -> widget.setBounds(0.0, 100.0).setFocusOnGuiOpen(true).setPos(10, 37).setSize(69, 12)))).widget(new TextWidget("Percent threshold").setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(10, 26));
        }
    }
}

