/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class WallShareablePart
extends MultiBlockPart {
    protected List<ChunkCoordinates> targetPositions = new ArrayList<ChunkCoordinates>();

    @Override
    public void setTarget(IMultiBlockController aTarget, int aAllowedModes) {
        if (this.targetPositions.size() >= 1) {
            this.allowedModes = 0;
            this.setMode(0);
            this.targetPosition = null;
        } else {
            this.allowedModes = aAllowedModes;
        }
        if (aTarget == null) {
            return;
        }
        this.targetPositions.add(aTarget.getCoords());
    }

    @Override
    public UUID getLockedInventory() {
        if (this.targetPositions.size() > 1) {
            return null;
        }
        return super.getLockedInventory();
    }

    @Override
    public IMultiBlockController getTarget(boolean aCheckValidity) {
        if (this.targetPositions.size() != 1) {
            return null;
        }
        this.targetPosition = this.targetPositions.get(0);
        return super.getTarget(aCheckValidity);
    }

    @Override
    public String getTileEntityName() {
        return "gt.multiTileEntity.casing.wallSharable";
    }

    @Override
    public boolean breakBlock() {
        for (ChunkCoordinates coordinates : this.targetPositions) {
            IMultiBlockController target = this.getTarget(coordinates, false);
            if (target == null) continue;
            target.onStructureChange();
        }
        return false;
    }

    @Override
    public void onBlockAdded() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.getTileEntityAtSide(side);
            if (te instanceof MultiBlockPart) {
                MultiBlockPart part = (MultiBlockPart)te;
                IMultiBlockController tController = part.getTarget(false);
                if (tController == null) continue;
                tController.onStructureChange();
                continue;
            }
            if (!(te instanceof IMultiBlockController)) continue;
            IMultiBlockController controller = (IMultiBlockController)te;
            controller.onStructureChange();
        }
    }

    public IMultiBlockController getTarget(ChunkCoordinates coordinates, boolean aCheckValidity) {
        TileEntity te;
        IMultiBlockController target = null;
        if (coordinates == null) {
            return null;
        }
        if (this.field_145850_b.func_72899_e(coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c) && (te = this.field_145850_b.func_147438_o(coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c)) instanceof IMultiBlockController) {
            target = (IMultiBlockController)te;
        }
        if (aCheckValidity) {
            return target != null && target.checkStructure(false) ? target : null;
        }
        return target;
    }
}

