/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.coast;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.surface.SurfaceBase;
import rwg.surface.SurfaceGrassland;
import rwg.util.CellNoise;
import rwg.util.CliffCalculator;
import rwg.util.NoiseGenerator;
import rwg.util.SnowheightCalculator;

public class RealisticBiomeCoastIce
extends RealisticBiomeBase {
    private SurfaceBase surface = new SurfaceGrassland(Blocks.field_150403_cj, Blocks.field_150403_cj, Blocks.field_150403_cj, Blocks.field_150432_aD);

    public RealisticBiomeCoastIce() {
        super(0, RWGBiomes.baseSnowDesert);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, NoiseGenerator perlin, CellNoise cell, float strength, float river) {
    }

    @Override
    public float rNoise(NoiseGenerator perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        river = river > 0.5f ? 1.0f : river * 2.0f;
        float start = perlin.noise2((float)x / 90.0f, (float)y / 90.0f) * 1.0f + perlin.noise2((float)x / 40.0f, (float)y / 40.0f) * 0.15f + perlin.noise2((float)x / 9.0f, (float)y / 9.0f) * 0.07f;
        float h = 0.0f;
        float c = 0.0f;
        if (ocean + start > 1.4f) {
            c = ocean + start > 1.5f ? 0.1f : ocean + start - 1.4f;
            c *= 250.0f + perlin.noise2((float)x / 50.0f, (float)y / 50.0f) * 25.0f;
        }
        if (ocean < 1.3f) {
            float st = (1.3f - ocean) * 20.0f;
            st = st > 1.0f ? 1.0f : st;
            h += perlin.noise2((float)x / 12.0f, (float)y / 12.0f);
            h += perlin.noise2((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        }
        return 55.0f + h + c * river;
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, NoiseGenerator perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        float c = CliffCalculator.calc(x, y, noise);
        boolean cliff = c > 1.4f;
        boolean type = false;
        for (int k = 255; k > -1; --k) {
            Block b = blocks[(y * 16 + x) * 256 + k];
            if (b == Blocks.field_150350_a) {
                depth = -1;
                continue;
            }
            if (b != Blocks.field_150348_b) continue;
            ++depth;
            if (cliff) {
                if (depth == 0) {
                    boolean bl = type = perlin.noise2((float)i / 5.0f, (float)j / 5.0f) > 0.0f;
                }
                if (depth >= 10) continue;
                blocks[(y * 16 + x) * 256 + k] = !type ? Blocks.field_150403_cj : Blocks.field_150432_aD;
                continue;
            }
            if (depth < 5 && k > 61) {
                blocks[(y * 16 + x) * 256 + k] = Blocks.field_150433_aE;
                if (depth != 0 || k <= 61 || k >= 254) continue;
                SnowheightCalculator.calc(x, y, k, blocks, metadata, noise);
                continue;
            }
            if (depth >= 3) continue;
            blocks[(y * 16 + x) * 256 + k] = Blocks.field_150351_n;
        }
    }
}

