/*
 * Decompiled with CFR 0.152.
 */
package tb.common.tile;

import DummyCore.Utils.MiscUtils;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.api.wands.IWandable;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.EntityAspectOrb;

public class TileNodeManipulator
extends TileEntity
implements IWandable {
    private static final int ticksInWorkCycle = 20;
    private int workTime = 0;
    private int maxTimeRequired = 0;
    private final HashMap<Aspect, Integer> previousNodeAspects = new HashMap();
    private NodeType nodeType;
    private INode node;

    private int getColor(int effect) {
        int color;
        switch (effect) {
            case 1: {
                color = 5130070;
                break;
            }
            case 2: {
                color = 0xD2D200;
                break;
            }
            case 3: {
                color = 11500579;
                break;
            }
            case 4: {
                color = 740674;
                break;
            }
            case 5: {
                color = 13420791;
                break;
            }
            case 6: {
                color = 6569051;
                break;
            }
            case 7: {
                color = 0xEAEAEA;
                break;
            }
            case 8: {
                color = 13689080;
                break;
            }
            case 9: {
                color = 7419030;
                break;
            }
            default: {
                color = 0xFFFFFF;
            }
        }
        return color;
    }

    private void stopManipulator() {
        this.workTime = 0;
        this.maxTimeRequired = 0;
        this.node = null;
        this.previousNodeAspects.clear();
    }

    private void applyDestructionEffect() {
        NodeModifier nodeModifier = this.node.getNodeModifier();
        if (this.maxTimeRequired == 0) {
            switch (nodeModifier) {
                case BRIGHT: {
                    this.maxTimeRequired = 1200;
                    break;
                }
                case PALE: {
                    this.maxTimeRequired = 3600;
                    break;
                }
                case FADING: {
                    this.maxTimeRequired = 7200;
                    break;
                }
                default: {
                    this.maxTimeRequired = 2400;
                }
            }
        }
        if (this.workTime >= this.maxTimeRequired) {
            NodeModifier newNodeModifier;
            this.stopManipulator();
            if (nodeModifier == NodeModifier.FADING) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
            switch (nodeModifier) {
                case BRIGHT: {
                    newNodeModifier = null;
                    break;
                }
                case PALE: {
                    newNodeModifier = NodeModifier.FADING;
                    break;
                }
                default: {
                    newNodeModifier = NodeModifier.PALE;
                }
            }
            this.node.setNodeModifier(newNodeModifier);
            return;
        }
        this.increaseWorkTime();
        if (!this.field_145850_b.field_72995_K && this.workTime % 200 == 0) {
            Aspect[] aspects = this.node.getAspects().getAspects();
            Aspect aspect = aspects[this.field_145850_b.field_73012_v.nextInt(aspects.length)];
            EntityAspectOrb aspectOrb = new EntityAspectOrb(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d - 0.5, (double)this.field_145849_e + 0.5, aspect, 1);
            this.field_145850_b.func_72838_d((Entity)aspectOrb);
        }
    }

    private void applyEfficiencyEffect() {
        if (this.workTime == 0) {
            this.workTime = -1;
        }
        if (!this.field_145850_b.field_72995_K) {
            Aspect[] aspects;
            AspectList aspectList = this.node.getAspects();
            for (Aspect aspect : aspects = aspectList.getAspects()) {
                int previousAmount;
                int currentAmount;
                if (this.previousNodeAspects.containsKey(aspect) && (currentAmount = aspectList.getAmount(aspect)) < (previousAmount = this.previousNodeAspects.get(aspect).intValue()) && this.field_145850_b.field_73012_v.nextInt(2) == 1) {
                    this.node.addToContainer(aspect, previousAmount - currentAmount);
                }
                this.previousNodeAspects.put(aspect, this.node.getAspects().getAmount(aspect));
            }
        }
    }

    private void applySpeedEffect() {
        if (this.workTime == 0) {
            this.workTime = -1;
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(5) == 1) {
            Aspect[] aspects;
            boolean isNodeChanged = false;
            AspectList aspectList = this.node.getAspects();
            for (Aspect aspect : aspects = aspectList.getAspects()) {
                int maximum = this.node.getNodeVisBase(aspect);
                int currentAmount = aspectList.getAmount(aspect);
                if (currentAmount >= maximum) continue;
                this.node.addToContainer(aspect, 1);
                isNodeChanged = true;
            }
            if (isNodeChanged) {
                MiscUtils.sendPacketToAllAround((World)this.field_145850_b, (Packet)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e).func_145844_m(), (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (int)this.field_145850_b.field_73011_w.field_76574_g, (double)6.0);
            }
        }
    }

    private void applyStabilityEffect() {
        NodeModifier nodeModifier = this.node.getNodeModifier();
        if (nodeModifier == null) {
            this.changeNodeModifier(null, NodeModifier.BRIGHT, 6000);
            return;
        }
        block0 : switch (nodeModifier) {
            case FADING: {
                this.changeNodeModifier(NodeModifier.FADING, NodeModifier.PALE, 6000);
                break;
            }
            case PALE: {
                this.changeNodeModifier(NodeModifier.PALE, null, 12000);
                break;
            }
            default: {
                switch (this.nodeType) {
                    case DARK: {
                        this.changeNodeType(NodeType.DARK, NodeType.NORMAL, 2400);
                        break block0;
                    }
                    case HUNGRY: {
                        this.changeNodeType(NodeType.HUNGRY, NodeType.NORMAL, 600);
                        break block0;
                    }
                    case UNSTABLE: {
                        this.changeNodeType(NodeType.UNSTABLE, NodeType.NORMAL, 4200);
                        break block0;
                    }
                    case TAINTED: {
                        this.changeNodeType(NodeType.TAINTED, NodeType.NORMAL, 18000);
                        break block0;
                    }
                }
            }
        }
    }

    private void increaseWorkTime() {
        this.workTime += 20;
    }

    private void changeNodeModifier(NodeModifier fromNodeModifier, NodeModifier toModifierNode, int time) {
        if (this.node.getNodeModifier() == fromNodeModifier) {
            if (this.maxTimeRequired == 0) {
                this.maxTimeRequired = time;
            }
            if (this.workTime >= this.maxTimeRequired) {
                this.node.setNodeModifier(toModifierNode);
                this.stopManipulator();
            } else {
                this.increaseWorkTime();
            }
        }
    }

    private void changeNodeType(NodeType fromNodeType, NodeType toTypeNode, int time) {
        if (this.nodeType == fromNodeType) {
            if (this.maxTimeRequired == 0) {
                this.maxTimeRequired = time;
            }
            if (this.workTime >= this.maxTimeRequired) {
                this.node.setNodeType(toTypeNode);
                this.stopManipulator();
            } else {
                this.increaseWorkTime();
            }
        }
    }

    public void func_145845_h() {
        int effect = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) - 1;
        long ticks = this.field_145850_b.func_72820_D() + 7L;
        if (this.field_145850_b.field_72995_K && this.workTime != 0) {
            Thaumcraft.proxy.beam(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, (double)this.field_145851_c + 0.5, (double)this.field_145848_d - 0.5, (double)this.field_145849_e + 0.5, 2, this.getColor(effect), false, 0.5f, 2);
        }
        if (ticks % 2L == 0L) {
            this.node = this.getNode();
            if (this.node == null || this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 0) {
                if (this.workTime != 0) {
                    this.stopManipulator();
                }
                return;
            }
            this.nodeType = this.node.getNodeType();
            if (effect == 2) {
                this.applyEfficiencyEffect();
            }
            if (ticks % 20L == 0L) {
                switch (effect) {
                    case 0: {
                        this.changeNodeModifier(null, NodeModifier.BRIGHT, 24000);
                        break;
                    }
                    case 1: {
                        this.applyDestructionEffect();
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        this.changeNodeType(NodeType.NORMAL, NodeType.HUNGRY, 6000);
                        break;
                    }
                    case 4: {
                        this.changeNodeType(NodeType.NORMAL, NodeType.UNSTABLE, 8400);
                        break;
                    }
                    case 5: {
                        this.changeNodeType(NodeType.NORMAL, NodeType.PURE, 3600);
                        this.changeNodeType(NodeType.TAINTED, NodeType.NORMAL, 39600);
                        break;
                    }
                    case 6: {
                        this.changeNodeType(NodeType.NORMAL, NodeType.DARK, 7200);
                        this.changeNodeType(NodeType.PURE, NodeType.NORMAL, 18000);
                        break;
                    }
                    case 7: {
                        this.applySpeedEffect();
                        break;
                    }
                    case 8: {
                        this.applyStabilityEffect();
                        break;
                    }
                    case 9: {
                        this.changeNodeType(NodeType.NORMAL, NodeType.TAINTED, 7200);
                    }
                }
            }
        }
    }

    public INode getNode() {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) instanceof INode) {
            return (INode)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.workTime = tag.func_74762_e("workTime");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("workTime", this.workTime);
    }

    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        return 0;
    }

    public ItemStack onWandRightClick(World world, ItemStack wandstack, EntityPlayer player) {
        return wandstack;
    }

    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }
}

