/*
 * Decompiled with CFR 0.152.
 */
package net.moecraft.nechar;

import codechicken.nei.api.ItemFilter;
import codechicken.nei.api.ItemInfo;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import net.moecraft.nechar.NotEnoughCharacters;

public class NecharSearchFilter
implements ItemFilter {
    protected boolean invalid = false;
    protected String mod = null;
    protected String id = null;
    protected String dict = null;
    protected List<String> keywords = new LinkedList<String>();

    public NecharSearchFilter(String searchText) {
        String[] pieces;
        block5: for (String piece : pieces = searchText.split("\\s+")) {
            if (piece.isEmpty()) continue;
            switch (piece.charAt(0)) {
                case '@': {
                    if (this.mod == null) {
                        this.mod = piece.substring(1).toLowerCase();
                        continue block5;
                    }
                    this.invalid = true;
                    return;
                }
                case '&': {
                    if (this.id == null) {
                        this.id = piece.substring(1).toLowerCase();
                        continue block5;
                    }
                    this.invalid = true;
                    return;
                }
                case '$': {
                    if (this.dict == null) {
                        this.dict = piece.substring(1).toLowerCase();
                        continue block5;
                    }
                    this.invalid = true;
                    return;
                }
                default: {
                    this.keywords.add(piece);
                }
            }
        }
    }

    public boolean matches(ItemStack itemStack) {
        return !this.invalid && this.matchesMod(itemStack) && this.matchesId(itemStack) && this.matchesDict(itemStack) && this.matchesKeywords(itemStack);
    }

    protected boolean matchesMod(ItemStack itemStack) {
        if (this.mod == null || this.mod.isEmpty()) {
            return true;
        }
        GameRegistry.UniqueIdentifier itemId = GameRegistry.findUniqueIdentifierFor((Item)itemStack.func_77973_b());
        return itemId != null && itemId.modId.toLowerCase().contains(this.mod);
    }

    protected boolean matchesId(ItemStack itemStack) {
        if (this.id == null || this.id.isEmpty()) {
            return true;
        }
        String itemId = Item.field_150901_e.func_148750_c((Object)itemStack.func_77973_b());
        return itemId.toLowerCase().contains(this.id);
    }

    protected boolean matchesDict(ItemStack itemStack) {
        int[] oreIds;
        if (this.dict == null || this.dict.isEmpty()) {
            return true;
        }
        for (int id : oreIds = OreDictionary.getOreIDs((ItemStack)itemStack)) {
            if (!OreDictionary.getOreName((int)id).toLowerCase().contains(this.dict)) continue;
            return true;
        }
        return false;
    }

    protected boolean matchesKeywords(ItemStack itemStack) {
        if (this.keywords == null || this.keywords.isEmpty()) {
            return true;
        }
        String name = ItemInfo.getSearchName((ItemStack)itemStack);
        for (String keyword : this.keywords) {
            if (NotEnoughCharacters.CONTEXT.contains(name, keyword)) continue;
            return false;
        }
        return true;
    }
}

