/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.thaumcraft.objects;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.data.FileUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.thaumcraft.commands.CommandDumpAspects;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

public class ThreadAspectScanner
extends Thread {
    public static boolean mDoWeScan = false;
    private static final Map<String, AutoMap<ItemStack>> mAllGameContent = new HashMap<String, AutoMap<ItemStack>>();
    public final File mAspectCacheFile = FileUtils.getFile("config/GTplusplus", "AspectInfo", "txt");

    public ThreadAspectScanner() {
        mDoWeScan = true;
    }

    private void tryCacheObject(ItemStack aStack) {
        String nameKey;
        if (aStack == null) {
            return;
        }
        try {
            nameKey = ItemUtils.getUnlocalizedItemName(aStack);
        }
        catch (NullPointerException n) {
            try {
                nameKey = Utils.sanitizeString(aStack.func_82833_r().toLowerCase());
            }
            catch (NullPointerException n2) {
                try {
                    nameKey = aStack.func_77973_b().func_77658_a();
                }
                catch (NullPointerException n3) {
                    nameKey = "BadItemsGalore";
                }
            }
        }
        AutoMap<ItemStack> m = new AutoMap<ItemStack>();
        if (mAllGameContent.containsKey(nameKey)) {
            m = mAllGameContent.get(nameKey);
        }
        m.put(aStack);
        mAllGameContent.put(nameKey, m);
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public void run() {
        if (mDoWeScan) {
            Logger.INFO("Finding Blocks and Items to scan for Aspect data.");
            long mBlocksCounter = 0L;
            long mItemsCounter = 0L;
            for (String s : Block.field_149771_c.func_148742_b()) {
                Block block = (Block)Block.field_149771_c.func_82594_a(s);
                if (block == null) continue;
                this.tryCacheObject(ItemUtils.getSimpleStack(block));
                ++mBlocksCounter;
            }
            Logger.INFO("Completed Block Scan. Counted " + mBlocksCounter);
            for (String s : Item.field_150901_e.func_148742_b()) {
                Item item = (Item)Item.field_150901_e.func_82594_a(s);
                if (item == null) continue;
                if (item.func_77614_k()) {
                    ArrayList q1 = new ArrayList();
                    item.func_150895_a(item, item.func_77640_w(), q1);
                    if (q1 != null && q1.size() > 0) {
                        for (int e = 0; e < q1.size(); ++e) {
                            ItemStack check = ItemUtils.simpleMetaStack(item, e, 1);
                            if (check == null) continue;
                            this.tryCacheObject(check);
                            ++mItemsCounter;
                        }
                        continue;
                    }
                    this.tryCacheObject(ItemUtils.getSimpleStack(item));
                    ++mItemsCounter;
                    continue;
                }
                this.tryCacheObject(ItemUtils.getSimpleStack(item));
                ++mItemsCounter;
            }
            Logger.INFO("Completed Item Scan. Counted " + mItemsCounter);
            Set<String> y = mAllGameContent.keySet();
            Logger.INFO("Beginning iteration of " + y.size() + " itemstacks for aspect information.");
            for (String key : y) {
                AutoMap<ItemStack> group;
                if (!mAllGameContent.containsKey(key) || (group = mAllGameContent.get(key)) == null || group.size() <= 0) continue;
                for (ItemStack stack : group) {
                    AspectList a = ThaumcraftCraftingManager.getObjectTags((ItemStack)stack);
                    if (a == null) continue;
                    AutoMap<Pair<String, Integer>> aspectPairs = new AutoMap<Pair<String, Integer>>();
                    for (Aspect c : a.getAspectsSortedAmount()) {
                        if (c == null) continue;
                        aspectPairs.put(new Pair<String, Integer>(c.getName(), a.getAmount(c)));
                    }
                    try {
                        ArrayList<String> mList = new ArrayList<String>();
                        mList.add(stack.func_82833_r() + " | Meta: " + stack.func_77960_j() + " | Unlocal: " + stack.func_77977_a());
                        for (Pair r : aspectPairs) {
                            if (r == null) continue;
                            mList.add((String)r.getKey() + " x" + r.getValue());
                        }
                        mList.add("");
                        if (this.mAspectCacheFile == null || mList.size() < 3) continue;
                        FileUtils.appendListToFile(this.mAspectCacheFile, mList);
                    }
                    catch (Throwable t) {
                        Logger.INFO("Error while iterating one item. " + t);
                    }
                }
            }
            Logger.INFO("Completed Aspect Iteration. AspectInfo.txt is now available to process in the GTplusplus configuration folder.");
            CommandDumpAspects.mLastScanTime = System.currentTimeMillis();
        }
    }
}

