/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gtPlusPlus.api.interfaces.RunnableWithInfo;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeCategories;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.ALLOY;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.material.nuclear.FLUORIDES;
import gtPlusPlus.core.material.nuclear.NUCLIDE;
import gtPlusPlus.core.material.state.MaterialState;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_Base;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeGen_BlastSmelter
extends RecipeGen_Base {
    public static final Set<RunnableWithInfo<Material>> mRecipeGenMap = new HashSet<RunnableWithInfo<Material>>();

    public RecipeGen_BlastSmelter(Material M) {
        this.toGenerate = M;
        mRecipeGenMap.add(this);
    }

    @Override
    public void run() {
        this.generateARecipe(this.toGenerate);
    }

    private void generateARecipe(Material M) {
        ItemStack tStack = M.getDust(1);
        if (null != tStack) {
            boolean hasMoreInputThanACircuit;
            Material[] badMaterials;
            for (Material R : badMaterials = new Material[]{FLUORIDES.THORIUM_HEXAFLUORIDE, FLUORIDES.THORIUM_TETRAFLUORIDE, ALLOY.BLOODSTEEL, NUCLIDE.LiFBeF2ThF4UF4, NUCLIDE.LiFBeF2ZrF4UF4, NUCLIDE.LiFBeF2ZrF4U235}) {
                if (M != R) continue;
                return;
            }
            ArrayList<Object> tMaterial = new ArrayList();
            int inputStackCount = 0;
            int fluidAmount = 0;
            boolean doTest = true;
            tMaterial = M.getComposites();
            long aVoltage = MaterialUtils.getVoltageForTier(M.vTier);
            int duration = 120 * M.vTier * 10;
            if (M.vTier <= 4) {
                duration = 20 * M.vTier * 10;
            }
            int mMaterialListSize = 0;
            int mTotalPartsCounter = M.smallestStackSizeWhenProcessing;
            if (M.getComposites() != null) {
                for (MaterialStack ternkfsdf : M.getComposites()) {
                    if (ternkfsdf == null) continue;
                    ++mMaterialListSize;
                }
            } else {
                mMaterialListSize = 1;
            }
            if (duration <= 0) {
                int second = 20;
                duration = 280 * mMaterialListSize * 8;
            }
            Logger.WARNING("[BAS] Size: " + mMaterialListSize);
            ItemStack circuitGT = ItemUtils.getGregtechCircuit(1);
            ItemStack[] tItemStackTest = new ItemStack[]{circuitGT, tStack};
            inputStackCount = 1;
            fluidAmount = 144 * inputStackCount;
            Logger.WARNING("[BAS] Adding an Alloy Blast Smelter Recipe for " + M.getLocalizedName() + ". Gives " + fluidAmount + "L of molten metal.");
            for (int das = 0; das < tItemStackTest.length; ++das) {
                if (tItemStackTest[das] == null) continue;
                Logger.WARNING("[BAS] tMaterial[" + das + "]: " + tItemStackTest[das].func_82833_r() + " Meta: " + tItemStackTest[das].func_77960_j() + ", Amount: " + tItemStackTest[das].field_77994_a);
            }
            boolean bl = hasMoreInputThanACircuit = tItemStackTest.length > 1;
            if (hasMoreInputThanACircuit) {
                if (M.requiresBlastFurnace()) {
                    GT_Values.RA.stdBuilder().itemInputs(tItemStackTest).fluidOutputs(new FluidStack[]{M.getFluidStack(fluidAmount)}).duration(duration / (mTotalPartsCounter > 0 ? mTotalPartsCounter : 1)).eut(aVoltage).recipeCategory(GTPPRecipeCategories.absNonAlloyRecipes).addTo(GTPPRecipeMaps.alloyBlastSmelterRecipes);
                } else {
                    Logger.WARNING("[BAS] Failed.");
                }
            } else if (CORE.RA.addBlastSmelterRecipe(tItemStackTest, M.getFluidStack(fluidAmount), 100, duration / (mTotalPartsCounter > 0 ? mTotalPartsCounter : 1) / 2, (int)aVoltage)) {
                Logger.WARNING("[BAS] Success.");
                if (GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Ingot.get(0L, new Object[0]), M.getFluidStack(144), M.getIngot(1), duration / 2, 60)) {
                    Logger.WARNING("[BAS] Success, Also added a Fluid solidifier recipe.");
                }
            } else {
                Logger.WARNING("[BAS] Failed.");
            }
            if (tMaterial != null) {
                inputStackCount = 0;
                if (mMaterialListSize > 1) {
                    MaterialStack[] tempStack = new MaterialStack[mMaterialListSize];
                    circuitGT = ItemUtils.getGregtechCircuit(mMaterialListSize);
                    if (tempStack.length > 1) {
                        int ooo = 0;
                        for (MaterialStack xMaterial : M.getComposites()) {
                            if (xMaterial != null) {
                                if (xMaterial.getStackMaterial() != null) {
                                    Logger.WARNING("[BAS] FOUND: " + xMaterial.getStackMaterial().getLocalizedName());
                                    Logger.WARNING("[BAS] ADDING: " + xMaterial.getStackMaterial().getLocalizedName());
                                }
                                tempStack[ooo] = xMaterial;
                            }
                            ++ooo;
                        }
                        ItemStack[] components = new ItemStack[9];
                        inputStackCount = 0;
                        FluidStack componentsFluid = null;
                        for (int irc = 0; irc < M.getComposites().size(); ++irc) {
                            if (M.getComposites().get(irc) == null) continue;
                            int r = (int)M.vSmallestRatio[irc];
                            inputStackCount += r;
                            if (M.getComposites().get(irc).getStackMaterial().getState() != MaterialState.SOLID || !ItemUtils.checkForInvalidItems(M.getComposites().get(irc).getDustStack(r))) {
                                int xr = r;
                                if (xr <= 0 || xr > 100) continue;
                                int mathmatics = r * 1000;
                                componentsFluid = FluidUtils.getFluidStack(M.getComposites().get(irc).getStackMaterial().getFluidStack(mathmatics), mathmatics);
                                continue;
                            }
                            components[irc] = M.getComposites().get(irc).getUnificatedDustStack(r);
                        }
                        if (mMaterialListSize < 9 && mMaterialListSize != 0) {
                            ItemStack[] components_NoCircuit = components;
                            components = new ItemStack[components_NoCircuit.length + 1];
                            for (int fr = 0; fr < components.length; ++fr) {
                                if (fr == 0) {
                                    components[0] = circuitGT;
                                    continue;
                                }
                                components[fr] = components_NoCircuit[fr - 1];
                            }
                            Logger.WARNING("[BAS] Should have added a circuit. mMaterialListSize: " + mMaterialListSize + " | circuit: " + components[0].func_82833_r());
                        } else {
                            Logger.WARNING("[BAS] Did not add a circuit. mMaterialListSize: " + mMaterialListSize);
                        }
                        fluidAmount = 144 * inputStackCount;
                        Logger.WARNING("[BAS] Adding an Alloy Blast Smelter Recipe for " + M.getLocalizedName() + " using it's compound dusts. This material has " + inputStackCount + " parts. Gives " + fluidAmount + "L of molten metal.");
                        Logger.WARNING("[BAS] tMaterial.length: " + components.length + ".");
                        for (int das = 0; das < components.length; ++das) {
                            if (components[das] == null) continue;
                            Logger.WARNING("[BAS] tMaterial[" + das + "]: " + components[das].func_82833_r() + " Meta: " + components[das].func_77960_j() + ", Amount: " + components[das].field_77994_a);
                        }
                        if (M.requiresBlastFurnace()) {
                            if (CORE.RA.addBlastSmelterRecipe(components, componentsFluid, M.getFluidStack(fluidAmount), 100, duration, (int)aVoltage)) {
                                Logger.WARNING("[BAS] Success.");
                            } else {
                                Logger.WARNING("[BAS] Failed.");
                            }
                        } else if (CORE.RA.addBlastSmelterRecipe(components, componentsFluid, M.getFluidStack(fluidAmount), 100, duration, (int)aVoltage / 2)) {
                            Logger.WARNING("[BAS] Success.");
                        } else {
                            Logger.WARNING("[BAS] Failed.");
                        }
                    }
                }
            } else {
                Logger.WARNING("[BAS] doTest: true | tMaterial != null: " + (tMaterial != null));
            }
        }
    }

    static {
        MaterialGenerator.mRecipeMapsToGenerate.put(mRecipeGenMap);
    }
}

