/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo;

import com.github.lunatrius.ingameinfo.Alignment;
import com.github.lunatrius.ingameinfo.client.gui.Info;
import com.github.lunatrius.ingameinfo.client.gui.InfoText;
import com.github.lunatrius.ingameinfo.handler.ConfigurationHandler;
import com.github.lunatrius.ingameinfo.parser.IParser;
import com.github.lunatrius.ingameinfo.parser.json.JsonParser;
import com.github.lunatrius.ingameinfo.parser.text.TextParser;
import com.github.lunatrius.ingameinfo.parser.xml.XmlParser;
import com.github.lunatrius.ingameinfo.printer.IPrinter;
import com.github.lunatrius.ingameinfo.printer.json.JsonPrinter;
import com.github.lunatrius.ingameinfo.printer.text.TextPrinter;
import com.github.lunatrius.ingameinfo.printer.xml.XmlPrinter;
import com.github.lunatrius.ingameinfo.reference.Reference;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.value.Value;
import com.github.lunatrius.ingameinfo.value.ValueComplex;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.IResource;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class InGameInfoCore {
    private static final Pattern PATTERN = Pattern.compile("\\{ICON\\|( *)\\}", 2);
    private static final Matcher MATCHER = PATTERN.matcher("");
    public static final InGameInfoCore INSTANCE = new InGameInfoCore();
    private IParser parser;
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private final Profiler profiler;
    private File configDirectory;
    private File configFile;
    private String baseConfigFileName;
    private final Map<Alignment, List<List<Value>>> format;
    private final List<Info> info;
    private final List<Info> infoItemQueue;
    private ScaledResolution scaledResolution;

    private InGameInfoCore() {
        this.profiler = this.minecraft.field_71424_I;
        this.configDirectory = null;
        this.configFile = null;
        this.format = new HashMap<Alignment, List<List<Value>>>();
        this.info = new ArrayList<Info>();
        this.infoItemQueue = new ArrayList<Info>();
        this.scaledResolution = new ScaledResolution(this.minecraft, this.minecraft.field_71443_c, this.minecraft.field_71440_d);
        Tag.setInfo(this.infoItemQueue);
        Value.setInfo(this.infoItemQueue);
    }

    public boolean setConfigDirectory(File directory) {
        this.configDirectory = directory;
        return true;
    }

    public File getConfigDirectory() {
        return this.configDirectory;
    }

    public void setConfigFileWithLocale() {
        if (this.baseConfigFileName != null) {
            this.setConfigFileWithLocale(this.baseConfigFileName);
        }
    }

    public void setConfigFileWithLocale(String filename) {
        String userLang = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        String baseName = filename.split("\\.")[0];
        String extension = filename.split("\\.").length > 1 ? filename.split("\\.")[1] : "";
        String localeAwareFileName = baseName + "_" + userLang + "." + extension;
        if (new File(this.configDirectory, localeAwareFileName).isFile()) {
            this.setConfigFile(localeAwareFileName, filename);
        } else {
            this.setConfigFile(filename);
        }
    }

    public boolean setConfigFile(String filename) {
        return this.setConfigFile(filename, filename);
    }

    public boolean setConfigFile(String filename, String baseConfigFileName) {
        File file = new File(this.configDirectory, filename);
        if (file.exists()) {
            if (filename.endsWith(".xml")) {
                this.configFile = file;
                this.parser = new XmlParser();
                this.baseConfigFileName = baseConfigFileName;
                return true;
            }
            if (filename.endsWith(".json")) {
                this.configFile = file;
                this.parser = new JsonParser();
                this.baseConfigFileName = baseConfigFileName;
                return true;
            }
            if (filename.endsWith(".txt")) {
                this.configFile = file;
                this.parser = new TextParser();
                this.baseConfigFileName = baseConfigFileName;
                return true;
            }
        }
        this.configFile = null;
        this.parser = new XmlParser();
        this.baseConfigFileName = null;
        return false;
    }

    public void onTickClient() {
        float scale = ConfigurationHandler.Scale / 10.0f;
        int scaledWidth = (int)((float)this.scaledResolution.func_78326_a() / scale);
        int scaledHeight = (int)((float)this.scaledResolution.func_78328_b() / scale);
        WorldClient world = this.minecraft.field_71441_e;
        if (world == null) {
            return;
        }
        Tag.setWorld((World)world);
        EntityClientPlayerMP player = this.minecraft.field_71439_g;
        if (player == null) {
            return;
        }
        Tag.setPlayer(player);
        this.info.clear();
        this.profiler.func_76320_a("alignment");
        this.profiler.func_76320_a("none");
        for (Alignment alignment : Alignment.values()) {
            this.profiler.func_76318_c(alignment.toString().toLowerCase());
            List<List<Value>> lines = this.format.get((Object)alignment);
            if (lines == null) continue;
            FontRenderer fontRenderer = this.minecraft.field_71466_p;
            ArrayList<InfoText> queue = new ArrayList<InfoText>();
            for (List<Value> list : lines) {
                StringBuilder str = new StringBuilder();
                this.infoItemQueue.clear();
                this.profiler.func_76320_a("taggathering");
                for (Value value : list) {
                    str.append(this.getValue(value));
                }
                this.profiler.func_76319_b();
                if (str.length() <= 0) continue;
                String processed = str.toString().replaceAll("\\{ICON\\|( *)\\}", "$1");
                int x = alignment.getX(scaledWidth, fontRenderer.func_78256_a(processed));
                InfoText text = new InfoText(fontRenderer, processed, x, 0);
                if (this.infoItemQueue.size() > 0) {
                    MATCHER.reset(str.toString());
                    for (int i = 0; i < this.infoItemQueue.size() && MATCHER.find(); ++i) {
                        Info item = this.infoItemQueue.get(i);
                        item.x = fontRenderer.func_78256_a(str.substring(0, MATCHER.start()));
                        text.children.add(item);
                        str = new StringBuilder(str.toString().replaceFirst(Pattern.quote(MATCHER.group(0)), MATCHER.group(1)));
                        MATCHER.reset(str.toString());
                    }
                }
                queue.add(text);
            }
            int y = alignment.getY(scaledHeight, queue.size() * (fontRenderer.field_78288_b + 1));
            for (Info info : queue) {
                info.y = y;
                this.info.add(info);
                y += fontRenderer.field_78288_b + 1;
            }
            this.info.addAll(queue);
        }
        this.profiler.func_76319_b();
        this.profiler.func_76319_b();
        Tag.releaseResources();
        ValueComplex.ValueFile.tick();
    }

    public void onTickRender(ScaledResolution resolution) {
        this.scaledResolution = resolution;
        GL11.glPushMatrix();
        float scale = ConfigurationHandler.Scale / 10.0f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        for (Info info : this.info) {
            info.draw();
        }
        GL11.glPopMatrix();
    }

    public boolean loadConfig(String filename) {
        return this.setConfigFile(filename) && this.reloadConfig();
    }

    public boolean reloadConfig() {
        this.info.clear();
        this.infoItemQueue.clear();
        this.format.clear();
        if (this.parser == null) {
            return false;
        }
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            return false;
        }
        if (this.parser.load(inputStream) && this.parser.parse(this.format)) {
            return true;
        }
        this.format.clear();
        return false;
    }

    private InputStream getInputStream() {
        InputStream inputStream = null;
        try {
            if (this.configFile != null && this.configFile.exists()) {
                Reference.logger.debug("Loading file config...");
                inputStream = new FileInputStream(this.configFile);
            } else {
                Reference.logger.debug("Loading default config...");
                ResourceLocation resourceLocation = new ResourceLocation("ingameinfo", "InGameInfo.xml");
                IResource resource = this.minecraft.func_110442_L().func_110536_a(resourceLocation);
                inputStream = resource.func_110527_b();
            }
        }
        catch (Exception e) {
            Reference.logger.error("", (Throwable)e);
        }
        return inputStream;
    }

    public boolean saveConfig(String filename) {
        IPrinter printer = null;
        File file = new File(this.configDirectory, filename);
        if (filename.endsWith(".xml")) {
            printer = new XmlPrinter();
        } else if (filename.endsWith(".json")) {
            printer = new JsonPrinter();
        } else if (filename.endsWith(".txt")) {
            printer = new TextPrinter();
        }
        return printer != null && printer.print(file, this.format);
    }

    public void moveConfig(File directory, String fileName) {
        File originalFile = new File(directory, fileName);
        if (!originalFile.isFile()) {
            return;
        }
        Path source = originalFile.toPath();
        Path subdirectory = directory.toPath().resolve("InGameInfoXML");
        Path destination = subdirectory.resolve(fileName).normalize();
        if (!destination.startsWith(directory.toPath())) {
            throw new RuntimeException("Failed to move file: " + destination);
        }
        try {
            if (!subdirectory.toFile().isDirectory()) {
                Files.createDirectory(subdirectory, new FileAttribute[0]);
            }
            destination.toFile().createNewFile();
            Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getValue(Value value) {
        try {
            if (value.isValidSize()) {
                return value.getReplacedValue();
            }
        }
        catch (Exception e) {
            Reference.logger.debug("Failed to get value!", (Throwable)e);
            return "null";
        }
        return "";
    }
}

