/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.renderers.tile;

import java.util.Random;
import makeo.gadomancy.client.effect.EffectHandler;
import makeo.gadomancy.client.effect.fx.Orbital;
import makeo.gadomancy.common.blocks.tiles.TileAIShutdown;
import makeo.gadomancy.common.utils.Vector3;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXWisp;

public class RenderTileAIShutdown
extends TileEntitySpecialRenderer {
    private static final Random rand = new Random();

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float parTicks) {
        if (tileEntity == null || !(tileEntity instanceof TileAIShutdown)) {
            return;
        }
        TileAIShutdown ta = (TileAIShutdown)tileEntity;
        if (ta.getStoredEssentia() > 0) {
            this.handleOrbital(ta);
        }
    }

    private void handleOrbital(TileAIShutdown ta) {
        if (ta.orbital == null && ta.func_145831_w() != null) {
            ta.orbital = new Orbital(new Vector3((double)ta.field_145851_c + 0.5, (double)ta.field_145848_d + 0.2, (double)ta.field_145849_e + 0.5), ta.func_145831_w());
        }
        if (ta.orbital != null && !ta.orbital.registered) {
            EffectHandler.getInstance().registerOrbital(ta.orbital);
        }
        if (ta.orbital != null) {
            ta.orbital.lastRenderCall = System.currentTimeMillis();
        }
        if (ta.getStoredEssentia() > 0) {
            if (ta.orbital != null && ta.orbital.orbitalsSize() == 0) {
                this.fillOrbital(ta.orbital);
            }
        } else if (ta.orbital != null && ta.orbital.orbitalsSize() > 0) {
            ta.orbital.clearOrbitals();
        }
    }

    private void fillOrbital(Orbital orbital) {
        Orbital.OrbitalRenderProperties prop = new Orbital.OrbitalRenderProperties(Orbital.Axis.Y_AXIS, 1.5);
        prop.setTicksForFullCircle(50).setOffsetTicks(0);
        prop.setParticleSize(0.0f);
        prop.setRenderRunnable(new Orbital.OrbitalRenderRunnable(){

            @Override
            public void onRender(World world, Vector3 pos, Orbital.OrbitalRenderProperties properties, int orbitalExisted, float partialTicks) {
                if (rand.nextInt(3) == 0) {
                    FXWisp ef = new FXWisp(world, pos.getX() + (double)RenderTileAIShutdown.randomOffset(), pos.getY() + (double)RenderTileAIShutdown.randomOffset(), pos.getZ() + (double)RenderTileAIShutdown.randomOffset(), 0.2f, 3);
                    ef.setGravity(-0.08f);
                    ParticleEngine.instance.addEffect(world, (EntityFX)ef);
                }
            }
        });
        orbital.addOrbitalPoint(prop);
        prop = new Orbital.OrbitalRenderProperties(Orbital.Axis.Y_AXIS, 1.5);
        prop.setTicksForFullCircle(50).setOffsetTicks(25);
        prop.setParticleSize(0.0f);
        prop.setRenderRunnable(new Orbital.OrbitalRenderRunnable(){

            @Override
            public void onRender(World world, Vector3 pos, Orbital.OrbitalRenderProperties properties, int orbitalExisted, float partialTicks) {
                if (rand.nextInt(3) == 0) {
                    FXWisp ef = new FXWisp(world, pos.getX() + (double)RenderTileAIShutdown.randomOffset(), pos.getY() + (double)RenderTileAIShutdown.randomOffset(), pos.getZ() + (double)RenderTileAIShutdown.randomOffset(), 0.2f, 3);
                    ef.setGravity(-0.08f);
                    ParticleEngine.instance.addEffect(world, (EntityFX)ef);
                }
            }
        });
        orbital.addOrbitalPoint(prop);
        prop = new Orbital.OrbitalRenderProperties(Orbital.Axis.Y_AXIS, 3.0);
        prop.setTicksForFullCircle(90).setOffsetTicks(0);
        prop.setParticleSize(0.0f);
        prop.setRenderRunnable(new Orbital.OrbitalRenderRunnable(){

            @Override
            public void onRender(World world, Vector3 pos, Orbital.OrbitalRenderProperties properties, int orbitalExisted, float partialTicks) {
                if (rand.nextBoolean()) {
                    FXWisp ef = new FXWisp(world, pos.getX() + (double)RenderTileAIShutdown.randomOffset(), pos.getY() + (double)RenderTileAIShutdown.randomOffset(), pos.getZ() + (double)RenderTileAIShutdown.randomOffset(), 0.15f, 5);
                    ef.setGravity(-0.08f);
                    ParticleEngine.instance.addEffect(world, (EntityFX)ef);
                }
            }
        });
        orbital.addOrbitalPoint(prop);
        prop = new Orbital.OrbitalRenderProperties(Orbital.Axis.Y_AXIS, 3.0);
        prop.setTicksForFullCircle(90).setOffsetTicks(30);
        prop.setParticleSize(0.0f);
        prop.setRenderRunnable(new Orbital.OrbitalRenderRunnable(){

            @Override
            public void onRender(World world, Vector3 pos, Orbital.OrbitalRenderProperties properties, int orbitalExisted, float partialTicks) {
                if (rand.nextBoolean()) {
                    FXWisp ef = new FXWisp(world, pos.getX() + (double)RenderTileAIShutdown.randomOffset(), pos.getY() + (double)RenderTileAIShutdown.randomOffset(), pos.getZ() + (double)RenderTileAIShutdown.randomOffset(), 0.15f, 5);
                    ef.setGravity(-0.08f);
                    ParticleEngine.instance.addEffect(world, (EntityFX)ef);
                }
            }
        });
        orbital.addOrbitalPoint(prop);
        prop = new Orbital.OrbitalRenderProperties(Orbital.Axis.Y_AXIS, 3.0);
        prop.setTicksForFullCircle(90).setOffsetTicks(60);
        prop.setParticleSize(0.0f);
        prop.setRenderRunnable(new Orbital.OrbitalRenderRunnable(){

            @Override
            public void onRender(World world, Vector3 pos, Orbital.OrbitalRenderProperties properties, int orbitalExisted, float partialTicks) {
                if (rand.nextBoolean()) {
                    FXWisp ef = new FXWisp(world, pos.getX() + (double)RenderTileAIShutdown.randomOffset(), pos.getY() + (double)RenderTileAIShutdown.randomOffset(), pos.getZ() + (double)RenderTileAIShutdown.randomOffset(), 0.15f, 5);
                    ef.setGravity(-0.08f);
                    ParticleEngine.instance.addEffect(world, (EntityFX)ef);
                }
            }
        });
        orbital.addOrbitalPoint(prop);
    }

    private static float randomOffset() {
        return rand.nextFloat() * 0.2f;
    }
}

