/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib;

import com.gtnewhorizon.structurelib.CommonProxy;
import com.gtnewhorizon.structurelib.ConfigurationHandler;
import com.gtnewhorizon.structurelib.IStructureCompat;
import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.entity.fx.WeightlessParticleFX;
import com.gtnewhorizon.structurelib.net.SetChannelDataMessage;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.Frustrum;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

public class ClientProxy
extends CommonProxy {
    private static final short[] RGBA_NO_TINT = new short[]{255, 255, 255, 255};
    private static final short[] RGBA_RED_TINT = new short[]{255, 128, 128, 0};
    private static final Map<HintParticleInfo, HintGroup> allHints = new HashMap<HintParticleInfo, HintGroup>();
    private static final List<HintGroup> allGroups = new ArrayList<HintGroup>();
    private static HintGroup currentHints;
    private static final List<HintParticleInfo> allHintsForRender;
    private static final Vec3 lastPlayerPos;
    private static boolean allHintsDirty;
    private static int renderThrough;
    private static final Map<Object, Long> localThrottleMap;

    @Override
    public void hintParticleTinted(World w, int x, int y, int z, IIcon[] icons, short[] RGBa) {
        HintGroup dupe;
        this.ensureHinting();
        HintParticleInfo info = new HintParticleInfo(w, x, y, z, icons, RGBa);
        if (ConfigurationHandler.INSTANCE.isRemoveCollidingHologram() && (dupe = allHints.get(info)) != null && dupe != currentHints) {
            allGroups.remove(dupe);
            ClientProxy.removeGroup(dupe);
        }
        allHints.put(info, currentHints);
        currentHints.getHints().add(info);
        allHintsDirty = true;
        WeightlessParticleFX particle = new WeightlessParticleFX(w, (float)x + StructureLib.RANDOM.nextFloat() * 0.5f, (float)y + StructureLib.RANDOM.nextFloat() * 0.5f, (float)z + StructureLib.RANDOM.nextFloat() * 0.5f, 0.0, 0.0, 0.0);
        particle.func_70538_b(0.0f, 0.6f * StructureLib.RANDOM.nextFloat(), 0.8f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
    }

    @Override
    public void hintParticleTinted(World w, int x, int y, int z, Block block, int meta, short[] RGBa) {
        this.hintParticleTinted(w, x, y, z, ClientProxy.createIIconFromBlock(block, meta), RGBa);
    }

    @Override
    public void hintParticle(World w, int x, int y, int z, IIcon[] icons) {
        this.hintParticleTinted(w, x, y, z, icons, RGBA_NO_TINT);
    }

    @Override
    public void hintParticle(World w, int x, int y, int z, Block block, int meta) {
        this.hintParticleTinted(w, x, y, z, ClientProxy.createIIconFromBlock(block, meta), RGBA_NO_TINT);
    }

    @Override
    public boolean updateHintParticleTint(EntityPlayer player, World w, int x, int y, int z, short[] rgBa) {
        if (player instanceof EntityPlayerMP) {
            return super.updateHintParticleTint(player, w, x, y, z, rgBa);
        }
        if (player != this.getCurrentPlayer()) {
            return false;
        }
        HintParticleInfo hint = ClientProxy.getHintParticleInfo(w, x, y, z);
        if (hint == null) {
            return false;
        }
        hint.setTint(rgBa);
        return true;
    }

    private static HintParticleInfo getHintParticleInfo(World w, int x, int y, int z) {
        HintParticleInfo info = new HintParticleInfo(w, x, y, z, null, null);
        HintGroup existing = allHints.get(info);
        if (existing != null) {
            for (HintParticleInfo hint : existing.getHints()) {
                if (!hint.equals(info)) continue;
                return hint;
            }
        }
        return null;
    }

    @Override
    public boolean markHintParticleError(EntityPlayer player, World w, int x, int y, int z) {
        if (player instanceof EntityPlayerMP) {
            return super.markHintParticleError(player, w, x, y, z);
        }
        if (player != this.getCurrentPlayer()) {
            return false;
        }
        HintParticleInfo hint = ClientProxy.getHintParticleInfo(w, x, y, z);
        if (hint == null) {
            return false;
        }
        hint.setTint(RGBA_RED_TINT);
        hint.setRenderThrough();
        return true;
    }

    @Override
    public void addThrottledChat(Object throttleKey, EntityPlayer player, IChatComponent text, short intervalRequired, boolean forceUpdateLastSend) {
        if (player instanceof EntityPlayerMP) {
            super.addThrottledChat(throttleKey, player, text, intervalRequired, forceUpdateLastSend);
        } else if (player != null) {
            ClientProxy.addThrottledChat(throttleKey, player, text, intervalRequired, forceUpdateLastSend, localThrottleMap);
        }
    }

    static void removeGroup(HintGroup group) {
        for (HintParticleInfo hintParticleInfo : group.getHints()) {
            allHints.remove(hintParticleInfo);
            if (!hintParticleInfo.renderThrough) continue;
            --renderThrough;
        }
        allHintsDirty = true;
    }

    private static IIcon[] createIIconFromBlock(Block block, int meta) {
        IIcon[] ret = new IIcon[6];
        for (int i = 0; i < 6; ++i) {
            ret[i] = block.func_149691_a(i, meta);
        }
        return ret;
    }

    @Override
    public void addClientSideChatMessages(String ... messages) {
        GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        for (String s : messages) {
            chat.func_146227_a((IChatComponent)new ChatComponentText(s));
        }
    }

    @Override
    public EntityPlayer getCurrentPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public boolean isCurrentPlayer(EntityPlayer player) {
        return player == Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void startHinting(World w) {
        if (!w.field_72995_K) {
            return;
        }
        if (currentHints != null) {
            this.endHinting(w);
        }
        currentHints = new HintGroup();
    }

    private void ensureHinting() {
        if (currentHints == null) {
            currentHints = new HintGroup();
        }
    }

    @Override
    public void endHinting(World w) {
        if (!w.field_72995_K || currentHints == null) {
            return;
        }
        while (!allGroups.isEmpty() && allGroups.size() >= ConfigurationHandler.INSTANCE.getMaxCoexistingHologram()) {
            allGroups.remove(0);
        }
        if (!currentHints.getHints().isEmpty()) {
            allGroups.add(currentHints);
        }
        currentHints.setCreationTime(this.getCurrentPlayer().field_70173_aa);
        currentHints = null;
    }

    @Override
    public long getOverworldTime() {
        return Minecraft.func_71410_x().field_71441_e.func_82737_E();
    }

    @Override
    public void uploadChannels(ItemStack trigger) {
        StructureLib.net.sendToServer((IMessage)new SetChannelDataMessage(trigger));
    }

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        FMLCommonHandler.instance().bus().register((Object)new FMLEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandler());
    }

    static void markTextureUsed(IIcon icon) {
        if (StructureLib.COMPAT instanceof IStructureCompat) {
            ((IStructureCompat)StructureLib.COMPAT).markTextureUsed(icon);
        }
    }

    static {
        allHintsForRender = new ArrayList<HintParticleInfo>(10000);
        lastPlayerPos = Vec3.func_72443_a((double)0.0, (double)-1.0E30, (double)0.0);
        allHintsDirty = false;
        localThrottleMap = new HashMap<Object, Long>();
    }

    public static class ForgeEventHandler {
        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load e) {
            if (e.world.field_72995_K) {
                allHintsForRender.clear();
                allGroups.clear();
                lastPlayerPos.field_72448_b = -1.0E30;
                renderThrough = 0;
                localThrottleMap.clear();
            }
        }

        @SubscribeEvent
        public void onRenderWorldLast(RenderWorldLastEvent e) {
            if (allHintsForRender.isEmpty()) {
                return;
            }
            Profiler p = Minecraft.func_71410_x().field_71424_I;
            p.func_76320_a("HintParticle");
            p.func_76320_a("Prepare");
            Frustrum frustrum = new Frustrum();
            EntityLivingBase entitylivingbase = Minecraft.func_71410_x().field_71451_h;
            double d0 = entitylivingbase.field_70142_S + (entitylivingbase.field_70165_t - entitylivingbase.field_70142_S) * (double)e.partialTicks;
            double d1 = entitylivingbase.field_70137_T + (entitylivingbase.field_70163_u - entitylivingbase.field_70137_T) * (double)e.partialTicks;
            double d2 = entitylivingbase.field_70136_U + (entitylivingbase.field_70161_v - entitylivingbase.field_70136_U) * (double)e.partialTicks;
            int i0 = (int)d0;
            int i1 = (int)d1;
            int i2 = (int)d2;
            frustrum.func_78547_a(d0, d1, d2);
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)24576);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)771, (int)770);
            boolean renderThrough = false;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glTranslated((double)(-d0 + (double)i0), (double)(-d1 + (double)i1), (double)(-d2 + (double)i2));
            Tessellator tes = Tessellator.field_78398_a;
            tes.func_78371_b(4);
            int i = 0;
            int allHintsForRenderSize = allHintsForRender.size();
            int cubeDrawn = 0;
            while (i < allHintsForRenderSize) {
                HintParticleInfo hint = (HintParticleInfo)allHintsForRender.get(i);
                if (hint.isInFrustrum(frustrum)) {
                    if (renderThrough != hint.renderThrough) {
                        if (i > 0) {
                            p.func_76318_c("Draw");
                            tes.func_78381_a();
                            tes.func_78371_b(4);
                            cubeDrawn = 0;
                            p.func_76318_c("Prepare");
                        }
                        if (hint.renderThrough) {
                            GL11.glDisable((int)2929);
                        } else {
                            GL11.glEnable((int)2929);
                        }
                        renderThrough = hint.renderThrough;
                    }
                    if (cubeDrawn + 1 >= 113) {
                        tes.func_78381_a();
                        tes.func_78371_b(4);
                    }
                    hint.draw(tes, d0, d1, d2, i0, i1, i2);
                }
                ++i;
                ++cubeDrawn;
            }
            p.func_76318_c("Draw");
            tes.func_78381_a();
            p.func_76319_b();
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            p.func_76319_b();
        }
    }

    public static class FMLEventHandler {
        private void resetPlayerLocation() {
            lastPlayerPos.field_72450_a = Minecraft.func_71410_x().field_71439_g.field_70165_t;
            lastPlayerPos.field_72448_b = Minecraft.func_71410_x().field_71439_g.field_70163_u;
            lastPlayerPos.field_72449_c = Minecraft.func_71410_x().field_71439_g.field_70161_v;
        }

        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent e) {
            if (e.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71439_g != null) {
                int i;
                Vec3 playerPos = Minecraft.func_71410_x().field_71439_g.func_70666_h(1.0f);
                boolean sortRequired = false;
                int deadline = Minecraft.func_71410_x().field_71439_g.field_70173_aa - ConfigurationHandler.INSTANCE.getHintLifespan();
                for (i = 0; i < allGroups.size() && ((HintGroup)allGroups.get(i)).getCreationTime() <= deadline; ++i) {
                }
                if (i != 0) {
                    sortRequired = true;
                    List toRemove = allGroups.subList(0, i);
                    toRemove.forEach(ClientProxy::removeGroup);
                    toRemove.clear();
                }
                if (allHintsDirty) {
                    allHintsForRender.clear();
                    for (HintGroup c : allGroups) {
                        allHintsForRender.addAll(c.getHints());
                    }
                    sortRequired = true;
                }
                if (sortRequired || playerPos.func_72436_e(lastPlayerPos) > 0.01) {
                    allHintsForRender.sort(Comparator.comparingDouble(info -> -info.getSquareDistanceTo(playerPos)));
                    this.resetPlayerLocation();
                }
            }
        }
    }

    private static class HintParticleInfo {
        private final World w;
        private final int x;
        private final int y;
        private final int z;
        private final IIcon[] icons;
        private short[] tint;
        private boolean renderThrough;
        private final long creationTime = System.currentTimeMillis();

        public HintParticleInfo(World w, int x, int y, int z, IIcon[] icons, short[] tint) {
            this.w = w;
            this.x = x;
            this.y = y;
            this.z = z;
            this.icons = icons;
            this.tint = tint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HintParticleInfo)) {
                return false;
            }
            HintParticleInfo that = (HintParticleInfo)o;
            return this.x == that.x && this.y == that.y && this.z == that.z;
        }

        public void setTint(short[] tint) {
            this.tint = tint;
        }

        public void setRenderThrough() {
            if (!this.renderThrough) {
                renderThrough = renderThrough + 1;
                allHintsDirty = true;
            }
            this.renderThrough = true;
        }

        public int hashCode() {
            int result = this.x;
            result = 31 * result + this.y;
            result = 31 * result + this.z;
            return result;
        }

        public boolean isInFrustrum(Frustrum frustrum) {
            return frustrum.func_78548_b((double)this.x + 0.25, (double)this.y + 0.25, (double)this.z + 0.25, (double)this.x + 0.75, (double)this.y + 0.75, (double)this.z + 0.75);
        }

        public void draw(Tessellator tes, double eyeX, double eyeY, double eyeZ, int eyeXint, int eyeYint, int eyeZint) {
            double size = 0.5;
            int brightness = this.w.func_72899_e(this.x, 0, this.z) ? this.w.func_72802_i(this.x, this.y, this.z, 0) : 0;
            tes.func_78380_c(brightness);
            tes.func_78370_a((int)((float)this.tint[0] * 0.9f), (int)((float)this.tint[1] * 0.95f), (int)((float)this.tint[2] * 1.0f), ConfigurationHandler.INSTANCE.getHintTransparency());
            double X = (double)(this.x - eyeXint) + 0.25;
            double Y = (double)(this.y - eyeYint) + 0.25;
            double Z = (double)(this.z - eyeZint) + 0.25;
            double worldX = (double)this.x + 0.25;
            double worldY = (double)this.y + 0.25;
            double worldZ = (double)this.z + 0.25;
            for (int j = 0; j < 2; ++j) {
                boolean unobstructedPass = j == 1;
                block9: for (int i = 0; i < 6; ++i) {
                    if (this.icons[i] == null) continue;
                    ClientProxy.markTextureUsed(this.icons[i]);
                    double u = this.icons[i].func_94209_e();
                    double U = this.icons[i].func_94212_f();
                    double v = this.icons[i].func_94206_g();
                    double V = this.icons[i].func_94210_h();
                    switch (i) {
                        case 0: {
                            if (worldY >= eyeY != unobstructedPass) continue block9;
                            tes.func_78375_b(0.0f, -1.0f, 0.0f);
                            tes.func_78374_a(X, Y, Z + size, u, V);
                            tes.func_78374_a(X, Y, Z, u, v);
                            tes.func_78374_a(X + size, Y, Z, U, v);
                            tes.func_78374_a(X + size, Y, Z, U, v);
                            tes.func_78374_a(X + size, Y, Z + size, U, V);
                            tes.func_78374_a(X, Y, Z + size, u, V);
                            continue block9;
                        }
                        case 1: {
                            if (worldY + size <= eyeY != unobstructedPass) continue block9;
                            tes.func_78375_b(0.0f, 1.0f, 0.0f);
                            tes.func_78374_a(X, Y + size, Z, u, v);
                            tes.func_78374_a(X, Y + size, Z + size, u, V);
                            tes.func_78374_a(X + size, Y + size, Z + size, U, V);
                            tes.func_78374_a(X + size, Y + size, Z + size, U, V);
                            tes.func_78374_a(X + size, Y + size, Z, U, v);
                            tes.func_78374_a(X, Y + size, Z, u, v);
                            continue block9;
                        }
                        case 2: {
                            if (worldZ >= eyeZ != unobstructedPass) continue block9;
                            tes.func_78375_b(0.0f, 0.0f, -1.0f);
                            tes.func_78374_a(X, Y, Z, U, V);
                            tes.func_78374_a(X, Y + size, Z, U, v);
                            tes.func_78374_a(X + size, Y + size, Z, u, v);
                            tes.func_78374_a(X + size, Y + size, Z, u, v);
                            tes.func_78374_a(X + size, Y, Z, u, V);
                            tes.func_78374_a(X, Y, Z, U, V);
                            continue block9;
                        }
                        case 3: {
                            if (worldZ + size <= eyeZ != unobstructedPass) continue block9;
                            tes.func_78375_b(0.0f, 0.0f, 1.0f);
                            tes.func_78374_a(X + size, Y, Z + size, U, V);
                            tes.func_78374_a(X + size, Y + size, Z + size, U, v);
                            tes.func_78374_a(X, Y + size, Z + size, u, v);
                            tes.func_78374_a(X, Y + size, Z + size, u, v);
                            tes.func_78374_a(X, Y, Z + size, u, V);
                            tes.func_78374_a(X + size, Y, Z + size, U, V);
                            continue block9;
                        }
                        case 4: {
                            if (worldX >= eyeX != unobstructedPass) continue block9;
                            tes.func_78375_b(-1.0f, 0.0f, 0.0f);
                            tes.func_78374_a(X, Y, Z + size, U, V);
                            tes.func_78374_a(X, Y + size, Z + size, U, v);
                            tes.func_78374_a(X, Y + size, Z, u, v);
                            tes.func_78374_a(X, Y + size, Z, u, v);
                            tes.func_78374_a(X, Y, Z, u, V);
                            tes.func_78374_a(X, Y, Z + size, U, V);
                            continue block9;
                        }
                        case 5: {
                            if (worldX + size <= eyeX != unobstructedPass) continue block9;
                            tes.func_78375_b(1.0f, 0.0f, 0.0f);
                            tes.func_78374_a(X + size, Y, Z, U, V);
                            tes.func_78374_a(X + size, Y + size, Z, U, v);
                            tes.func_78374_a(X + size, Y + size, Z + size, u, v);
                            tes.func_78374_a(X + size, Y + size, Z + size, u, v);
                            tes.func_78374_a(X + size, Y, Z + size, u, V);
                            tes.func_78374_a(X + size, Y, Z, U, V);
                        }
                    }
                }
            }
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public double getSquareDistanceTo(Vec3 point) {
            return point.func_72445_d((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
        }
    }

    private static class HintGroup {
        private final List<HintParticleInfo> hints = new LinkedList<HintParticleInfo>();
        private int creationTime = -1;

        private HintGroup() {
        }

        public List<HintParticleInfo> getHints() {
            return this.hints;
        }

        public void setCreationTime(int creationTime) {
            this.creationTime = creationTime;
        }

        public int getCreationTime() {
            return this.creationTime;
        }
    }
}

