/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.registration.gregtech;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Fluid;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.ALLOY;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechOrePrefixes;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GregtechMetaPipeEntityFluid;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GregtechMetaPipeEntity_Cable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class GregtechConduits {
    private static int BaseWireID = 30600;
    private static int BasePipeID = 30700;
    private static int BasePipeHexadecupleID = 30100;

    public static void run() {
        Logger.INFO("Gregtech5u Content | Registering Custom Cables/Wires/Pipes.");
        if (CORE.ConfigSwitches.enableCustom_Cables) {
            GregtechConduits.run1();
        }
        if (CORE.ConfigSwitches.enableCustom_Pipes) {
            GregtechConduits.run2();
            GregtechConduits.run3();
        }
    }

    private static void run3() {
        try {
            Class<GT_MetaPipeEntity_Fluid> aPipeEntity = GT_MetaPipeEntity_Fluid.class;
            Constructor<GT_MetaPipeEntity_Fluid> constructor = aPipeEntity.getConstructor(Integer.TYPE, String.class, String.class, Float.TYPE, Materials.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE);
            if (constructor != null) {
                Logger.INFO("Generating Hexadecuple pipes.");
                GregtechConduits.generateFluidMultiPipes(constructor, Materials.Copper, MaterialUtils.getMaterialName(Materials.Copper), "Copper", BasePipeHexadecupleID++, 60, 1000, true);
                GregtechConduits.generateFluidMultiPipes(constructor, Materials.Bronze, MaterialUtils.getMaterialName(Materials.Bronze), "Bronze", BasePipeHexadecupleID++, 120, 2000, true);
                GregtechConduits.generateFluidMultiPipes(constructor, Materials.Steel, MaterialUtils.getMaterialName(Materials.Steel), "Steel", BasePipeHexadecupleID++, 240, 2500, true);
                GregtechConduits.generateFluidMultiPipes(constructor, Materials.StainlessSteel, MaterialUtils.getMaterialName(Materials.StainlessSteel), "Stainless Steel", BasePipeHexadecupleID++, 360, 3000, true);
                GregtechConduits.generateFluidMultiPipes(constructor, Materials.Titanium, MaterialUtils.getMaterialName(Materials.Titanium), "Titanium", BasePipeHexadecupleID++, 480, 5000, true);
                GregtechConduits.generateFluidMultiPipes(constructor, Materials.TungstenSteel, MaterialUtils.getMaterialName(Materials.TungstenSteel), "Tungsten Steel", BasePipeHexadecupleID++, 600, 7500, true);
                GregtechConduits.generateFluidMultiPipes(constructor, Materials.Plastic, MaterialUtils.getMaterialName(Materials.Plastic), "Plastic", BasePipeHexadecupleID++, 360, 350, true);
                Materials aPTFE = Materials.get((String)"Polytetrafluoroethylene");
                if (aPTFE != null) {
                    GregtechConduits.generateFluidMultiPipes(constructor, aPTFE, MaterialUtils.getMaterialName(aPTFE), "PTFE", BasePipeHexadecupleID++, 480, 600, true);
                }
            } else {
                Logger.INFO("Failed during Hexadecuple pipe generation.");
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            Logger.INFO("Failed during Hexadecuple pipe generation. [Ecx]");
            e.printStackTrace();
        }
    }

    private static void generateFluidMultiPipes(Constructor<GT_MetaPipeEntity_Fluid> aClazz, Materials aMaterial, String name, String displayName, int startID, int transferRatePerSec, int heatCapacity, boolean gasProof) {
        int transferRatePerTick = transferRatePerSec / 20;
        try {
            GT_MetaPipeEntity_Fluid aPipe = aClazz.newInstance(startID, "GT_Pipe_" + name + "_Hexadecuple", "Hexadecuple " + displayName + " Fluid Pipe", Float.valueOf(1.0f), aMaterial, transferRatePerTick, heatCapacity, gasProof, 16);
            if (aPipe == null) {
                Logger.INFO("Failed to Generate " + aMaterial + " Hexadecuple pipes.");
            } else {
                Logger.INFO("Generated " + aMaterial + " Hexadecuple pipes.");
                GT_OreDictUnificator.registerOre((Object)("pipeHexadecuple" + aMaterial), (ItemStack)aPipe.getStackForm(1L));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            Logger.INFO("Failed to Generate " + aMaterial + " Hexadecuple pipes. [Ecx]");
            e.printStackTrace();
        }
    }

    private static void run1() {
        GregtechConduits.wireFactory("RedstoneAlloy", 32, BaseWireID + 45, 0L, 2L, 1L, new short[]{178, 34, 34, 0});
        GregtechConduits.makeCustomWires(ELEMENT.STANDALONE.HYPOGEN, BaseWireID - 15, 0L, 0L, 8L, GT_Values.V[11], false, true);
    }

    private static void run2() {
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.Staballoy, ALLOY.STABALLOY, BasePipeID, 12500, 7500, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.Tantalloy60, ALLOY.TANTALLOY_60, BasePipeID + 5, 10000, 4250, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.Tantalloy61, ALLOY.TANTALLOY_61, BasePipeID + 10, 12000, 5800, true);
        if (Mods.Thaumcraft.isModLoaded()) {
            GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.Void, null, BasePipeID + 15, 1600, 25000, true);
        }
        GregtechConduits.generateGTFluidPipes(Materials.Europium, BasePipeID + 20, 12000, 7500, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.Potin, ALLOY.POTIN, BasePipeID + 25, 500, 2000, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.MaragingSteel300, ALLOY.MARAGING300, BasePipeID + 30, 14000, 2500, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.MaragingSteel350, ALLOY.MARAGING350, BasePipeID + 35, 16000, 2500, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.Inconel690, ALLOY.INCONEL_690, BasePipeID + 40, 15000, 4800, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.Inconel792, ALLOY.INCONEL_792, BasePipeID + 45, 16000, 5500, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.HastelloyX, ALLOY.HASTELLOY_X, BasePipeID + 50, 20000, 4200, true);
        GregtechConduits.generateGTFluidPipes(Materials.Tungsten, BasePipeID + 55, 4320, 7200, true);
        if (Mods.EnderIO.isModLoaded()) {
            GregtechConduits.generateGTFluidPipes(Materials.DarkSteel, BasePipeID + 60, 2320, 2750, true);
        }
        GregtechConduits.generateGTFluidPipes(Materials.Clay, BasePipeID + 65, 100, 500, false);
        GregtechConduits.generateGTFluidPipes(Materials.Lead, BasePipeID + 70, 350, 1200, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.TriniumNaquadahCarbonite, ALLOY.TRINIUM_NAQUADAH_CARBON, 30500, 20, 250000, true);
    }

    private static void wireFactory(String Material2, int Voltage, int ID, long insulatedLoss, long uninsulatedLoss, long Amps, short[] rgb) {
        Materials T = Materials.get((String)Material2);
        byte V = GT_Utility.getTier((long)Voltage);
        if (V == -1) {
            Logger.ERROR("Failed to set voltage on " + Material2 + ". Invalid voltage of " + Voltage + "V set.");
            Logger.ERROR(Material2 + " has defaulted to 8v.");
            V = 0;
        }
        GregtechConduits.makeWires(T, ID, insulatedLoss, uninsulatedLoss, Amps, GT_Values.V[V], true, false, rgb);
    }

    private static void makeWires(Materials aMaterial, int aStartID, long aLossInsulated, long aLoss, long aAmperage, long aVoltage, boolean aInsulatable, boolean aAutoInsulated, short[] aRGB) {
        Logger.WARNING("Gregtech5u Content | Registered " + aMaterial.mName + " as a new material for Wire & Cable.");
        GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt01, (Object)aMaterial, (ItemStack)new GregtechMetaPipeEntity_Cable(aStartID + 0, "wire." + aMaterial.mName.toLowerCase() + ".01", "1x " + aMaterial.mDefaultLocalName + " Wire", 0.125f, aMaterial, aLoss, 1L * aAmperage, aVoltage, false, !aAutoInsulated, aRGB).getStackForm(1L));
        GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt02, (Object)aMaterial, (ItemStack)new GregtechMetaPipeEntity_Cable(aStartID + 1, "wire." + aMaterial.mName.toLowerCase() + ".02", "2x " + aMaterial.mDefaultLocalName + " Wire", 0.25f, aMaterial, aLoss, 2L * aAmperage, aVoltage, false, !aAutoInsulated, aRGB).getStackForm(1L));
        GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt04, (Object)aMaterial, (ItemStack)new GregtechMetaPipeEntity_Cable(aStartID + 2, "wire." + aMaterial.mName.toLowerCase() + ".04", "4x " + aMaterial.mDefaultLocalName + " Wire", 0.375f, aMaterial, aLoss, 4L * aAmperage, aVoltage, false, !aAutoInsulated, aRGB).getStackForm(1L));
        GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt08, (Object)aMaterial, (ItemStack)new GregtechMetaPipeEntity_Cable(aStartID + 3, "wire." + aMaterial.mName.toLowerCase() + ".08", "8x " + aMaterial.mDefaultLocalName + " Wire", 0.5f, aMaterial, aLoss, 8L * aAmperage, aVoltage, false, !aAutoInsulated, aRGB).getStackForm(1L));
        GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt12, (Object)aMaterial, (ItemStack)new GregtechMetaPipeEntity_Cable(aStartID + 4, "wire." + aMaterial.mName.toLowerCase() + ".12", "12x " + aMaterial.mDefaultLocalName + " Wire", 0.625f, aMaterial, aLoss, 12L * aAmperage, aVoltage, false, !aAutoInsulated, aRGB).getStackForm(1L));
        GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.wireGt16, (Object)aMaterial, (ItemStack)new GregtechMetaPipeEntity_Cable(aStartID + 5, "wire." + aMaterial.mName.toLowerCase() + ".16", "16x " + aMaterial.mDefaultLocalName + " Wire", 0.75f, aMaterial, aLoss, 16L * aAmperage, aVoltage, false, !aAutoInsulated, aRGB).getStackForm(1L));
        if (aInsulatable) {
            GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt01, (Object)aMaterial, (ItemStack)new GregtechMetaPipeEntity_Cable(aStartID + 6, "cable." + aMaterial.mName.toLowerCase() + ".01", "1x " + aMaterial.mDefaultLocalName + " Cable", 0.25f, aMaterial, aLossInsulated, 1L * aAmperage, aVoltage, true, false, aRGB).getStackForm(1L));
            GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt02, (Object)aMaterial, (ItemStack)new GregtechMetaPipeEntity_Cable(aStartID + 7, "cable." + aMaterial.mName.toLowerCase() + ".02", "2x " + aMaterial.mDefaultLocalName + " Cable", 0.375f, aMaterial, aLossInsulated, 2L * aAmperage, aVoltage, true, false, aRGB).getStackForm(1L));
            GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt04, (Object)aMaterial, (ItemStack)new GregtechMetaPipeEntity_Cable(aStartID + 8, "cable." + aMaterial.mName.toLowerCase() + ".04", "4x " + aMaterial.mDefaultLocalName + " Cable", 0.5f, aMaterial, aLossInsulated, 4L * aAmperage, aVoltage, true, false, aRGB).getStackForm(1L));
            GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt08, (Object)aMaterial, (ItemStack)new GregtechMetaPipeEntity_Cable(aStartID + 9, "cable." + aMaterial.mName.toLowerCase() + ".08", "8x " + aMaterial.mDefaultLocalName + " Cable", 0.625f, aMaterial, aLossInsulated, 8L * aAmperage, aVoltage, true, false, aRGB).getStackForm(1L));
            GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt12, (Object)aMaterial, (ItemStack)new GregtechMetaPipeEntity_Cable(aStartID + 10, "cable." + aMaterial.mName.toLowerCase() + ".12", "12x " + aMaterial.mDefaultLocalName + " Cable", 0.75f, aMaterial, aLossInsulated, 12L * aAmperage, aVoltage, true, false, aRGB).getStackForm(1L));
            GT_OreDictUnificator.registerOre((OrePrefixes)OrePrefixes.cableGt16, (Object)aMaterial, (ItemStack)new GregtechMetaPipeEntity_Cable(aStartID + 11, "cable." + aMaterial.mName.toLowerCase() + ".16", "16x " + aMaterial.mDefaultLocalName + " Cable", 0.875f, aMaterial, aLossInsulated, 16L * aAmperage, aVoltage, true, false, aRGB).getStackForm(1L));
        }
    }

    private static void customWireFactory(Material Material2, int Voltage, int ID, long insulatedLoss, long uninsulatedLoss, long Amps) {
        byte V = GT_Utility.getTier((long)Voltage);
        if (V == -1) {
            Logger.ERROR("Failed to set voltage on " + Material2 + ". Invalid voltage of " + Voltage + "V set.");
            Logger.ERROR(Material2 + " has defaulted to 8v.");
            V = 0;
        }
        GregtechConduits.makeCustomWires(Material2, ID, insulatedLoss, uninsulatedLoss, Amps, GT_Values.V[V], true, false);
    }

    private static void makeCustomWires(Material aMaterial, int aStartID, long aLossInsulated, long aLoss, long aAmperage, long aVoltage, boolean aInsulatable, boolean aAutoInsulated) {
        Logger.WARNING("Gregtech5u Content | Registered " + aMaterial.getLocalizedName() + " as a new material for Wire & Cable.");
        GregtechConduits.registerOre(OrePrefixes.wireGt01, aMaterial, new GregtechMetaPipeEntity_Cable(aStartID + 0, "wire." + aMaterial.getLocalizedName().toLowerCase() + ".01", "1x " + aMaterial.getLocalizedName() + " Wire", 0.125f, aLoss, 1L * aAmperage, aVoltage, false, !aAutoInsulated, aMaterial.getRGBA()).getStackForm(1L));
        GregtechConduits.registerOre(OrePrefixes.wireGt02, aMaterial, new GregtechMetaPipeEntity_Cable(aStartID + 1, "wire." + aMaterial.getLocalizedName().toLowerCase() + ".02", "2x " + aMaterial.getLocalizedName() + " Wire", 0.25f, aLoss, 2L * aAmperage, aVoltage, false, !aAutoInsulated, aMaterial.getRGBA()).getStackForm(1L));
        GregtechConduits.registerOre(OrePrefixes.wireGt04, aMaterial, new GregtechMetaPipeEntity_Cable(aStartID + 2, "wire." + aMaterial.getLocalizedName().toLowerCase() + ".04", "4x " + aMaterial.getLocalizedName() + " Wire", 0.375f, aLoss, 4L * aAmperage, aVoltage, false, !aAutoInsulated, aMaterial.getRGBA()).getStackForm(1L));
        GregtechConduits.registerOre(OrePrefixes.wireGt08, aMaterial, new GregtechMetaPipeEntity_Cable(aStartID + 3, "wire." + aMaterial.getLocalizedName().toLowerCase() + ".08", "8x " + aMaterial.getLocalizedName() + " Wire", 0.5f, aLoss, 8L * aAmperage, aVoltage, false, !aAutoInsulated, aMaterial.getRGBA()).getStackForm(1L));
        GregtechConduits.registerOre(OrePrefixes.wireGt12, aMaterial, new GregtechMetaPipeEntity_Cable(aStartID + 4, "wire." + aMaterial.getLocalizedName().toLowerCase() + ".12", "12x " + aMaterial.getLocalizedName() + " Wire", 0.625f, aLoss, 12L * aAmperage, aVoltage, false, !aAutoInsulated, aMaterial.getRGBA()).getStackForm(1L));
        GregtechConduits.registerOre(OrePrefixes.wireGt16, aMaterial, new GregtechMetaPipeEntity_Cable(aStartID + 5, "wire." + aMaterial.getLocalizedName().toLowerCase() + ".16", "16x " + aMaterial.getLocalizedName() + " Wire", 0.75f, aLoss, 16L * aAmperage, aVoltage, false, !aAutoInsulated, aMaterial.getRGBA()).getStackForm(1L));
        if (aInsulatable) {
            GregtechConduits.registerOre(OrePrefixes.cableGt01, aMaterial, new GregtechMetaPipeEntity_Cable(aStartID + 6, "cable." + aMaterial.getLocalizedName().toLowerCase() + ".01", "1x " + aMaterial.getLocalizedName() + " Cable", 0.25f, aLossInsulated, 1L * aAmperage, aVoltage, true, false, aMaterial.getRGBA()).getStackForm(1L));
            GregtechConduits.registerOre(OrePrefixes.cableGt02, aMaterial, new GregtechMetaPipeEntity_Cable(aStartID + 7, "cable." + aMaterial.getLocalizedName().toLowerCase() + ".02", "2x " + aMaterial.getLocalizedName() + " Cable", 0.375f, aLossInsulated, 2L * aAmperage, aVoltage, true, false, aMaterial.getRGBA()).getStackForm(1L));
            GregtechConduits.registerOre(OrePrefixes.cableGt04, aMaterial, new GregtechMetaPipeEntity_Cable(aStartID + 8, "cable." + aMaterial.getLocalizedName().toLowerCase() + ".04", "4x " + aMaterial.getLocalizedName() + " Cable", 0.5f, aLossInsulated, 4L * aAmperage, aVoltage, true, false, aMaterial.getRGBA()).getStackForm(1L));
            GregtechConduits.registerOre(OrePrefixes.cableGt08, aMaterial, new GregtechMetaPipeEntity_Cable(aStartID + 9, "cable." + aMaterial.getLocalizedName().toLowerCase() + ".08", "8x " + aMaterial.getLocalizedName() + " Cable", 0.625f, aLossInsulated, 8L * aAmperage, aVoltage, true, false, aMaterial.getRGBA()).getStackForm(1L));
            GregtechConduits.registerOre(OrePrefixes.cableGt12, aMaterial, new GregtechMetaPipeEntity_Cable(aStartID + 10, "cable." + aMaterial.getLocalizedName().toLowerCase() + ".12", "12x " + aMaterial.getLocalizedName() + " Cable", 0.75f, aLossInsulated, 12L * aAmperage, aVoltage, true, false, aMaterial.getRGBA()).getStackForm(1L));
            GregtechConduits.registerOre(OrePrefixes.cableGt16, aMaterial, new GregtechMetaPipeEntity_Cable(aStartID + 11, "cable." + aMaterial.getLocalizedName().toLowerCase() + ".16", "16x " + aMaterial.getLocalizedName() + " Cable", 0.875f, aLossInsulated, 16L * aAmperage, aVoltage, true, false, aMaterial.getRGBA()).getStackForm(1L));
        }
    }

    private static void superConductorFactory(GregtechOrePrefixes.GT_Materials Material2, int Voltage, int ID, long insulatedLoss, long uninsulatedLoss, long Amps) {
        GregtechOrePrefixes.GT_Materials T = Material2;
        int V = 0;
        if (Voltage == 8) {
            V = 0;
        } else if (Voltage == 32) {
            V = 1;
        } else if (Voltage == 128) {
            V = 2;
        } else if (Voltage == 512) {
            V = 3;
        } else if (Voltage == 2048) {
            V = 4;
        } else if (Voltage == 8196) {
            V = 5;
        } else if (Voltage == 32768) {
            V = 6;
        } else if (Voltage == 131072) {
            V = 7;
        } else if (Voltage == 524288) {
            V = 8;
        } else if (Voltage == Integer.MAX_VALUE) {
            V = 9;
        } else {
            Logger.ERROR("Failed to set voltage on " + Material2.name() + ". Invalid voltage of " + Voltage + "V set.");
            Logger.ERROR(Material2.name() + " has defaulted to 8v.");
            V = 0;
        }
    }

    private static void generateGTFluidPipes(Materials material, int startID, int transferRatePerSec, int heatResistance, boolean isGasProof) {
        int transferRatePerTick = transferRatePerSec / 20;
        long mass = material.getMass();
        long voltage = material.mMeltingPoint >= 2800 ? 64L : 16L;
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeTiny.get((Object)material), (ItemStack)new GT_MetaPipeEntity_Fluid(startID, "GT_Pipe_" + material.mDefaultLocalName + "_Tiny", "Tiny " + material.mDefaultLocalName + " Fluid Pipe", 0.25f, material, transferRatePerTick * 2, heatResistance, isGasProof).getStackForm(1L));
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeSmall.get((Object)material), (ItemStack)new GT_MetaPipeEntity_Fluid(startID + 1, "GT_Pipe_" + material.mDefaultLocalName + "_Small", "Small " + material.mDefaultLocalName + " Fluid Pipe", 0.375f, material, transferRatePerTick * 4, heatResistance, isGasProof).getStackForm(1L));
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeMedium.get((Object)material), (ItemStack)new GT_MetaPipeEntity_Fluid(startID + 2, "GT_Pipe_" + material.mDefaultLocalName + "", "" + material.mDefaultLocalName + " Fluid Pipe", 0.5f, material, transferRatePerTick * 12, heatResistance, isGasProof).getStackForm(1L));
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeLarge.get((Object)material), (ItemStack)new GT_MetaPipeEntity_Fluid(startID + 3, "GT_Pipe_" + material.mDefaultLocalName + "_Large", "Large " + material.mDefaultLocalName + " Fluid Pipe", 0.75f, material, transferRatePerTick * 24, heatResistance, isGasProof).getStackForm(1L));
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeHuge.get((Object)material), (ItemStack)new GT_MetaPipeEntity_Fluid(startID + 4, "GT_Pipe_" + material.mDefaultLocalName + "_Huge", "Huge " + material.mDefaultLocalName + " Fluid Pipe", 0.875f, material, transferRatePerTick * 48, heatResistance, isGasProof).getStackForm(1L));
    }

    private static void generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials material, Material myMaterial, int startID, int transferRatePerSec, int heatResistance, boolean isGasProof) {
        int transferRatePerTick = transferRatePerSec / 20;
        if (myMaterial != null) {
            long mass = myMaterial.getMass();
        } else {
            long mass = ELEMENT.getInstance().IRON.getMass();
        }
        int tVoltageMultiplier = material.mBlastFurnaceTemp >= 2800 ? 64 : 16;
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeTiny.get((Object)material), (ItemStack)new GregtechMetaPipeEntityFluid(startID, "GT_Pipe_" + material.mDefaultLocalName + "_Tiny", "Tiny " + material.mDefaultLocalName + " Fluid Pipe", 0.25f, material, transferRatePerTick * 2, heatResistance, isGasProof).getStackForm(1L));
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeSmall.get((Object)material), (ItemStack)new GregtechMetaPipeEntityFluid(startID + 1, "GT_Pipe_" + material.mDefaultLocalName + "_Small", "Small " + material.mDefaultLocalName + " Fluid Pipe", 0.375f, material, transferRatePerTick * 4, heatResistance, isGasProof).getStackForm(1L));
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeMedium.get((Object)material), (ItemStack)new GregtechMetaPipeEntityFluid(startID + 2, "GT_Pipe_" + material.mDefaultLocalName + "", "" + material.mDefaultLocalName + " Fluid Pipe", 0.5f, material, transferRatePerTick * 12, heatResistance, isGasProof).getStackForm(1L));
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeLarge.get((Object)material), (ItemStack)new GregtechMetaPipeEntityFluid(startID + 3, "GT_Pipe_" + material.mDefaultLocalName + "_Large", "Large " + material.mDefaultLocalName + " Fluid Pipe", 0.75f, material, transferRatePerTick * 24, heatResistance, isGasProof).getStackForm(1L));
        GT_OreDictUnificator.registerOre((Object)OrePrefixes.pipeHuge.get((Object)material), (ItemStack)new GregtechMetaPipeEntityFluid(startID + 4, "GT_Pipe_" + material.mDefaultLocalName + "_Huge", "Huge " + material.mDefaultLocalName + " Fluid Pipe", 0.875f, material, transferRatePerTick * 48, heatResistance, isGasProof).getStackForm(1L));
    }

    public static void generatePipeRecipes(String materialName, long Mass, long vMulti) {
        String output = materialName.substring(0, 1).toUpperCase() + materialName.substring(1);
        if ((output = Utils.sanitizeString(output)).equals("VoidMetal")) {
            output = "Void";
        }
        Logger.INFO("Generating " + output + " pipes & respective recipes.");
        ItemStack pipeIngot = ItemUtils.getItemStackOfAmountFromOreDict("ingot" + output, 1);
        ItemStack pipePlate = ItemUtils.getItemStackOfAmountFromOreDict("plate" + output, 1);
        if (pipeIngot == null && pipePlate != null) {
            pipeIngot = pipePlate;
        }
        Logger.WARNING("Generated pipeTiny from " + materialName + "? " + (ItemUtils.getItemStackOfAmountFromOreDict("pipeTiny" + output, 1) != null));
        Logger.WARNING("Generated pipeSmall from " + materialName + "? " + (ItemUtils.getItemStackOfAmountFromOreDict("pipeSmall" + output, 1) != null));
        Logger.WARNING("Generated pipeNormal from " + materialName + "? " + (ItemUtils.getItemStackOfAmountFromOreDict("pipeMedium" + output, 1) != null));
        Logger.WARNING("Generated pipeLarge from " + materialName + "? " + (ItemUtils.getItemStackOfAmountFromOreDict("pipeLarge" + output, 1) != null));
        Logger.WARNING("Generated pipeHuge from " + materialName + "? " + (ItemUtils.getItemStackOfAmountFromOreDict("pipeHuge" + output, 1) != null));
        int eut = 120;
        eut = (int)(8L * vMulti);
        RecipeUtils.addShapedRecipe(pipePlate, "craftingToolWrench", pipePlate, pipePlate, null, pipePlate, pipePlate, "craftingToolHardHammer", pipePlate, ItemUtils.getItemStackOfAmountFromOreDict("pipeSmall" + output, 6));
        RecipeUtils.addShapedRecipe(pipePlate, pipePlate, pipePlate, "craftingToolWrench", null, "craftingToolHardHammer", pipePlate, pipePlate, pipePlate, ItemUtils.getItemStackOfAmountFromOreDict("pipeMedium" + output, 2));
        RecipeUtils.addShapedRecipe(pipePlate, "craftingToolHardHammer", pipePlate, pipePlate, null, pipePlate, pipePlate, "craftingToolWrench", pipePlate, ItemUtils.getItemStackOfAmountFromOreDict("pipeLarge" + output, 1));
        if (pipeIngot != null && ItemUtils.checkForInvalidItems(pipeIngot)) {
            int inputMultiplier = materialName.equals("Clay") ? 2 : 1;
            GT_Values.RA.addExtruderRecipe(ItemUtils.getSimpleStack(pipeIngot, 1 * inputMultiplier), ItemList.Shape_Extruder_Pipe_Tiny.get(0L, new Object[0]), ItemUtils.getItemStackOfAmountFromOreDictNoBroken("pipeTiny" + output, 2), 5, eut);
            GT_Values.RA.addExtruderRecipe(ItemUtils.getSimpleStack(pipeIngot, 1 * inputMultiplier), ItemList.Shape_Extruder_Pipe_Small.get(0L, new Object[0]), ItemUtils.getItemStackOfAmountFromOreDict("pipeSmall" + output, 1), 10, eut);
            GT_Values.RA.addExtruderRecipe(ItemUtils.getSimpleStack(pipeIngot, 3 * inputMultiplier), ItemList.Shape_Extruder_Pipe_Medium.get(0L, new Object[0]), ItemUtils.getItemStackOfAmountFromOreDict("pipeMedium" + output, 1), 20, eut);
            GT_Values.RA.addExtruderRecipe(ItemUtils.getSimpleStack(pipeIngot, 6 * inputMultiplier), ItemList.Shape_Extruder_Pipe_Large.get(0L, new Object[0]), ItemUtils.getItemStackOfAmountFromOreDict("pipeLarge" + output, 1), 40, eut);
            GT_Values.RA.addExtruderRecipe(ItemUtils.getSimpleStack(pipeIngot, 12 * inputMultiplier), ItemList.Shape_Extruder_Pipe_Huge.get(0L, new Object[0]), ItemUtils.getItemStackOfAmountFromOreDict("pipeHuge" + output, 1), 80, eut);
        }
        if (eut < 512 && !output.equals("Void")) {
            try {
                ItemStack pipePlateDouble = ItemUtils.getItemStackOfAmountFromOreDict("plateDouble" + output, 1).func_77946_l();
                if (pipePlateDouble != null) {
                    RecipeUtils.addShapedRecipe(pipePlateDouble, "craftingToolHardHammer", pipePlateDouble, pipePlateDouble, null, pipePlateDouble, pipePlateDouble, "craftingToolWrench", pipePlateDouble, ItemUtils.getItemStackOfAmountFromOreDict("pipeHuge" + output, 1));
                } else {
                    Logger.INFO("Failed to add a recipe for " + materialName + " Huge pipes. Double plates probably do not exist.");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static boolean registerOre(OrePrefixes aPrefix, Material aMaterial, ItemStack aStack) {
        return GregtechConduits.registerOre(aPrefix.get((Object)Utils.sanitizeString(aMaterial.getLocalizedName())), aStack);
    }

    public static boolean registerOre(Object aName, ItemStack aStack) {
        if (aName == null || GT_Utility.isStackInvalid((Object)aStack)) {
            return false;
        }
        String tName = aName.toString();
        if (GT_Utility.isStringInvalid((Object)tName)) {
            return false;
        }
        ArrayList tList = GT_OreDictUnificator.getOres((Object)tName);
        for (int i = 0; i < tList.size(); ++i) {
            if (!GT_Utility.areStacksEqual((ItemStack)((ItemStack)tList.get(i)), (ItemStack)aStack, (boolean)true)) continue;
            return false;
        }
        OreDictionary.registerOre((String)tName, (ItemStack)GT_Utility.copyAmount((long)1L, (Object[])new Object[]{aStack}));
        return true;
    }

    public static boolean generateWireRecipes(Material aMaterial) {
        ItemStack aPlate = aMaterial.getPlate(1);
        ItemStack aIngot = aMaterial.getIngot(1);
        ItemStack aRod = aMaterial.getRod(1);
        ItemStack aWire01 = aMaterial.getWire01(1);
        ItemStack aWire02 = aMaterial.getWire02(1);
        ItemStack aWire04 = aMaterial.getWire04(1);
        ItemStack aWire08 = aMaterial.getWire08(1);
        ItemStack aWire12 = aMaterial.getWire12(1);
        ItemStack aWire16 = aMaterial.getWire16(1);
        ItemStack aCable01 = aMaterial.getCable01(1);
        ItemStack aCable02 = aMaterial.getCable02(1);
        ItemStack aCable04 = aMaterial.getCable04(1);
        ItemStack aCable08 = aMaterial.getCable08(1);
        ItemStack aCable12 = aMaterial.getCable12(1);
        ItemStack aCable16 = aMaterial.getCable16(1);
        ItemStack aFineWire = aMaterial.getFineWire(1);
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aPlate, aWire01})) {
            RecipeUtils.addShapedRecipe(aPlate, CI.craftingToolWireCutter, null, null, null, null, null, null, null, aWire01);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aIngot, aWire01, aWire02, aWire04, aWire08, aWire12, aWire16})) {
            GT_Values.RA.addWiremillRecipe(aMaterial.getIngot(1), GT_Utility.getIntegratedCircuit((int)1), aMaterial.getWire01(2), 100, 4);
            GT_Values.RA.addWiremillRecipe(aMaterial.getIngot(1), GT_Utility.getIntegratedCircuit((int)2), aMaterial.getWire02(1), 150, 4);
            GT_Values.RA.addWiremillRecipe(aMaterial.getIngot(2), GT_Utility.getIntegratedCircuit((int)4), aMaterial.getWire04(1), 200, 4);
            GT_Values.RA.addWiremillRecipe(aMaterial.getIngot(4), GT_Utility.getIntegratedCircuit((int)8), aMaterial.getWire08(1), 250, 4);
            GT_Values.RA.addWiremillRecipe(aMaterial.getIngot(6), GT_Utility.getIntegratedCircuit((int)12), aMaterial.getWire12(1), 300, 4);
            GT_Values.RA.addWiremillRecipe(aMaterial.getIngot(8), GT_Utility.getIntegratedCircuit((int)16), aMaterial.getWire16(1), 350, 4);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aRod, aWire01, aWire02, aWire04, aWire08, aWire12, aWire16})) {
            GT_Values.RA.addWiremillRecipe(aMaterial.getRod(1), GT_Utility.getIntegratedCircuit((int)1), aMaterial.getWire01(1), 50, 4);
            GT_Values.RA.addWiremillRecipe(aMaterial.getRod(2), GT_Utility.getIntegratedCircuit((int)2), aMaterial.getWire02(1), 100, 4);
            GT_Values.RA.addWiremillRecipe(aMaterial.getRod(4), GT_Utility.getIntegratedCircuit((int)4), aMaterial.getWire04(1), 150, 4);
            GT_Values.RA.addWiremillRecipe(aMaterial.getRod(8), GT_Utility.getIntegratedCircuit((int)8), aMaterial.getWire08(1), 200, 4);
            GT_Values.RA.addWiremillRecipe(aMaterial.getRod(12), GT_Utility.getIntegratedCircuit((int)12), aMaterial.getWire12(1), 250, 4);
            GT_Values.RA.addWiremillRecipe(aMaterial.getRod(16), GT_Utility.getIntegratedCircuit((int)16), aMaterial.getWire16(1), 300, 4);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aIngot, aFineWire})) {
            GT_Values.RA.addWiremillRecipe(aMaterial.getIngot(1), GT_Utility.getIntegratedCircuit((int)3), aMaterial.getFineWire(8), 100, 4);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aRod, aFineWire})) {
            GT_Values.RA.addWiremillRecipe(aMaterial.getRod(1), GT_Utility.getIntegratedCircuit((int)3), aMaterial.getFineWire(4), 50, 4);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aFineWire})) {
            GT_Values.RA.addWiremillRecipe(aMaterial.getWire01(1), GT_Utility.getIntegratedCircuit((int)1), aMaterial.getFineWire(4), 200, 8);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aIngot, aWire01})) {
            GT_Values.RA.addExtruderRecipe(aIngot, ItemList.Shape_Extruder_Wire.get(0L, new Object[0]), aMaterial.getWire01(2), 196, 96);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aCable01, aWire01})) {
            GT_Values.RA.addUnboxingRecipe(aCable01, aWire01, null, 100, 8);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire02})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire02}, aMaterial.getWire01(2));
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire04})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire04}, aMaterial.getWire01(4));
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire08})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire08}, aMaterial.getWire01(8));
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire12})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire12}, aMaterial.getWire01(12));
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire16})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire16}, aMaterial.getWire01(16));
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire02})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire01, aWire01}, aWire02);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire02, aWire04})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire02, aWire02}, aWire04);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire04, aWire08})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire04, aWire04}, aWire08);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire04, aWire08, aWire12})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire04, aWire08}, aWire12);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire04, aWire12, aWire16})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire04, aWire12}, aWire16);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire08, aWire16})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire08, aWire08}, aWire16);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire04})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire01, aWire01, aWire01, aWire01}, aWire04);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire08})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire01, aWire01, aWire01, aWire01, aWire01, aWire01, aWire01, aWire01}, aWire08);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aCable01})) {
            GT_Values.RA.addAssemblerRecipe(aWire01, CI.getNumberedCircuit(24), FluidUtils.getFluidStack("molten.rubber", 144), aCable01, 100, 8);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire02, aCable02})) {
            GT_Values.RA.addAssemblerRecipe(aWire02, CI.getNumberedCircuit(24), FluidUtils.getFluidStack("molten.rubber", 144), aCable02, 100, 8);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire04, aCable04})) {
            GT_Values.RA.addAssemblerRecipe(aWire04, CI.getNumberedCircuit(24), FluidUtils.getFluidStack("molten.rubber", 288), aCable04, 100, 8);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire08, aCable08})) {
            GT_Values.RA.addAssemblerRecipe(aWire08, CI.getNumberedCircuit(24), FluidUtils.getFluidStack("molten.rubber", 432), aCable08, 100, 8);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire12, aCable12})) {
            GT_Values.RA.addAssemblerRecipe(aWire12, CI.getNumberedCircuit(24), FluidUtils.getFluidStack("molten.rubber", 576), aCable12, 100, 8);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire16, aCable16})) {
            GT_Values.RA.addAssemblerRecipe(aWire16, CI.getNumberedCircuit(24), FluidUtils.getFluidStack("molten.rubber", 720), aCable16, 100, 8);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire02})) {
            GT_Values.RA.addAssemblerRecipe(aMaterial.getWire01(2), CI.getNumberedCircuit(2), null, aWire02, 100, 8);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire02})) {
            GT_Values.RA.addAssemblerRecipe(aMaterial.getWire01(4), CI.getNumberedCircuit(4), null, aWire04, 100, 8);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire02})) {
            GT_Values.RA.addAssemblerRecipe(aMaterial.getWire01(8), CI.getNumberedCircuit(8), null, aWire08, 100, 8);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire02})) {
            GT_Values.RA.addAssemblerRecipe(aMaterial.getWire01(12), CI.getNumberedCircuit(12), null, aWire12, 100, 8);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire02})) {
            GT_Values.RA.addAssemblerRecipe(aMaterial.getWire01(16), CI.getNumberedCircuit(16), null, aWire16, 100, 8);
        }
        return true;
    }
}

