/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.forestry.bees.registry;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeMutationCustom;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutationCondition;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeVariation;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.common.items.CombType;
import gregtech.loaders.misc.GT_Bees;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.forestry.bees.handler.GTPP_CombType;
import gtPlusPlus.xmod.forestry.bees.registry.GTPP_AlleleBeeSpecies;
import gtPlusPlus.xmod.forestry.bees.registry.GTPP_Bee_Mutation;
import gtPlusPlus.xmod.forestry.bees.registry.GTPP_Bees;
import gtPlusPlus.xmod.forestry.bees.registry.GTPP_BranchDefinition;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.text.WordUtils;

public enum GTPP_BeeDefinition implements IBeeDefinition
{
    DRAGONBLOOD(GTPP_BranchDefinition.LEGENDARY, "Dragon Blood", ELEMENT.STANDALONE.DRAGON_METAL, true, Utils.rgbtoHexValue(220, 20, 20), Utils.rgbtoHexValue(20, 20, 20), beeSpecies -> {
        beeSpecies.addProduct(GT_ModHandler.getModItem((String)Mods.Forestry.ID, (String)"beeCombs", (long)1L, (int)8), Float.valueOf(0.3f));
        beeSpecies.addSpecialty(GTPP_Bees.combs.getStackForType(GTPP_CombType.DRAGONBLOOD), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.ARID);
        beeSpecies.setTemperature(EnumTemperature.NORMAL);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectAggressive);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_3);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_3);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation("DRAGONESSENCE", "NEUTRONIUM", 2);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        tMutation.requireResource(ELEMENT.STANDALONE.DRAGON_METAL.getBlock(), 1);
        tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
    }),
    FORCE(GTPP_BranchDefinition.LEGENDARY, "Force", ELEMENT.STANDALONE.FORCE, true, Utils.rgbtoHexValue(250, 250, 20), Utils.rgbtoHexValue(200, 200, 5), beeSpecies -> {
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
        beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SALT), Float.valueOf(0.15f));
        beeSpecies.addSpecialty(GTPP_Bees.combs.getStackForType(GTPP_CombType.FORCE), Float.valueOf(0.1f));
        beeSpecies.setHumidity(EnumHumidity.NORMAL);
        beeSpecies.setTemperature(EnumTemperature.HOT);
        beeSpecies.setHasEffect();
    }, template -> {
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectAggressive);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
    }, dis -> {
        IBeeMutationCustom tMutation = dis.registerMutation("STEEL", "GOLD", 10);
        tMutation.restrictHumidity(EnumHumidity.ARID);
        tMutation.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT});
    });

    private final GTPP_BranchDefinition branch;
    private final GTPP_AlleleBeeSpecies species;
    private final Consumer<GTPP_AlleleBeeSpecies> mSpeciesProperties;
    private final Consumer<IAllele[]> mAlleles;
    private final Consumer<GTPP_BeeDefinition> mMutations;
    private IAllele[] template;
    private IBeeGenome genome;
    private static final Class sGtBees;

    private GTPP_BeeDefinition(GTPP_BranchDefinition branch, String binomial, Materials aMat, boolean dominant, int primary, int secondary, Consumer<GTPP_AlleleBeeSpecies> aSpeciesProperties, Consumer<IAllele[]> aAlleles, Consumer<GTPP_BeeDefinition> aMutations) {
        this(branch, binomial, MaterialUtils.generateMaterialFromGtENUM(aMat), dominant, primary, secondary, aSpeciesProperties, aAlleles, aMutations);
    }

    private GTPP_BeeDefinition(GTPP_BranchDefinition branch, String binomial, Material aMat, boolean dominant, int primary, int secondary, Consumer<GTPP_AlleleBeeSpecies> aSpeciesProperties, Consumer<IAllele[]> aAlleles, Consumer<GTPP_BeeDefinition> aMutations) {
        this.mAlleles = aAlleles;
        this.mMutations = aMutations;
        this.mSpeciesProperties = aSpeciesProperties;
        String lowercaseName = this.toString().toLowerCase(Locale.ENGLISH);
        String species = WordUtils.capitalize((String)binomial);
        String uid = "gtpp.bee.species" + species;
        String description = "for.description." + species;
        String name = "for.bees.species." + lowercaseName;
        GT_LanguageManager.addStringLocalization((String)("for.bees.species." + lowercaseName), (String)species, (boolean)true);
        GTPP_Bees.sMaterialMappings.put(binomial.toLowerCase().replaceAll(" ", ""), aMat);
        this.branch = branch;
        this.species = new GTPP_AlleleBeeSpecies(uid, dominant, name, "GT++", description, branch.getBranch(), binomial, primary, secondary);
    }

    public static void initBees() {
        for (GTPP_BeeDefinition bee : GTPP_BeeDefinition.values()) {
            bee.init();
        }
        for (GTPP_BeeDefinition bee : GTPP_BeeDefinition.values()) {
            bee.registerMutations();
        }
    }

    protected static IAlleleBeeEffect getEffect(byte modid, String name) {
        String s;
        switch (modid) {
            case 1: {
                s = "extrabees.effect." + name;
                break;
            }
            case 2: {
                s = "gendustry.effect." + name;
                break;
            }
            case 3: {
                s = "magicbees.effect" + name;
                break;
            }
            case 4: {
                s = "gregtech.effect" + name;
                break;
            }
            default: {
                s = "forestry.effect" + name;
            }
        }
        return (IAlleleBeeEffect)AlleleManager.alleleRegistry.getAllele(s);
    }

    protected static IAlleleFlowers getFlowers(byte modid, String name) {
        String s;
        switch (modid) {
            case 1: {
                s = "extrabees.flower." + name;
                break;
            }
            case 2: {
                s = "gendustry.flower." + name;
                break;
            }
            case 3: {
                s = "magicbees.flower" + name;
                break;
            }
            case 4: {
                s = "gregtech.flower" + name;
                break;
            }
            default: {
                s = "forestry.flowers" + name;
            }
        }
        return (IAlleleFlowers)AlleleManager.alleleRegistry.getAllele(s);
    }

    protected static IAlleleBeeSpecies getSpecies(byte modid, String name) {
        String s;
        switch (modid) {
            case 1: {
                s = "extrabees.species." + name;
                break;
            }
            case 2: {
                s = "gendustry.bee." + name;
                break;
            }
            case 3: {
                s = "magicbees.species" + name;
                break;
            }
            case 4: {
                s = "gregtech.species" + name;
                break;
            }
            default: {
                s = "forestry.species" + name;
            }
        }
        IAlleleBeeSpecies ret = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(s);
        return ret;
    }

    protected final void setSpeciesProperties(GTPP_AlleleBeeSpecies species2) {
        this.mSpeciesProperties.accept(species2);
    }

    protected final void setAlleles(IAllele[] template) {
        this.mAlleles.accept(template);
    }

    protected final void registerMutations() {
        this.mMutations.accept(this);
    }

    private void init() {
        this.setSpeciesProperties(this.species);
        this.template = this.branch.getTemplate();
        AlleleHelper.instance.set(this.template, (Enum)EnumBeeChromosome.SPECIES, (IAllele)this.species);
        this.setAlleles(this.template);
        this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
        BeeManager.beeRoot.registerTemplate(this.template);
    }

    protected final IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, IAlleleBeeSpecies parent2, int chance) {
        return this.registerMutation(parent1, parent2, chance, 1.0f);
    }

    protected final IBeeMutationCustom registerMutation(GTPP_BeeDefinition parent1, IAlleleBeeSpecies parent2, int chance) {
        return this.registerMutation(parent1, parent2, chance, 1.0f);
    }

    protected final IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, GTPP_BeeDefinition parent2, int chance) {
        return this.registerMutation(parent1, parent2, chance, 1.0f);
    }

    protected final IBeeMutationCustom registerMutation(GTPP_BeeDefinition parent1, GTPP_BeeDefinition parent2, int chance) {
        return this.registerMutation(parent1, parent2, chance, 1.0f);
    }

    protected final IBeeMutationCustom registerMutation(String parent1, String parent2, int chance) {
        return this.registerMutation(GTPP_BeeDefinition.getGregtechBeeType(parent1), GTPP_BeeDefinition.getGregtechBeeType(parent2), chance, 1.0f);
    }

    protected final IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, IAlleleBeeSpecies parent2, int chance, float chancedivider) {
        return new GTPP_Bee_Mutation(parent1, parent2, this.getTemplate(), chance, chancedivider);
    }

    protected final IBeeMutationCustom registerMutation(GTPP_BeeDefinition parent1, IAlleleBeeSpecies parent2, int chance, float chancedivider) {
        return this.registerMutation((IAlleleBeeSpecies)parent1.species, parent2, chance, chancedivider);
    }

    protected final IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, GTPP_BeeDefinition parent2, int chance, float chancedivider) {
        return this.registerMutation(parent1, (IAlleleBeeSpecies)parent2.species, chance, chancedivider);
    }

    protected final IBeeMutationCustom registerMutation(GTPP_BeeDefinition parent1, GTPP_BeeDefinition parent2, int chance, float chancedivider) {
        return this.registerMutation((IAlleleBeeSpecies)parent1.species, parent2, chance, chancedivider);
    }

    protected final IBeeMutationCustom registerMutation(String parent1, String parent2, int chance, float chancedivider) {
        return this.registerMutation(GTPP_BeeDefinition.getGregtechBeeType(parent1), GTPP_BeeDefinition.getGregtechBeeType(parent2), chance, chancedivider);
    }

    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    public final IBeeGenome getGenome() {
        return this.genome;
    }

    public final IBee getIndividual() {
        return new Bee(this.genome);
    }

    public final ItemStack getMemberStack(EnumBeeType beeType) {
        return BeeManager.beeRoot.getMemberStack((IIndividual)this.getIndividual(), beeType.ordinal());
    }

    public final IBeeDefinition getRainResist() {
        return new BeeVariation.RainResist((IBeeDefinition)this);
    }

    public static IAlleleBeeSpecies getGregtechBeeType(String name) {
        try {
            Enum aBeeObject = ReflectionUtils.getEnum(sGtBees, name);
            Field gtBeesField = ReflectionUtils.getField(sGtBees, "species");
            IAlleleBeeSpecies beeType = (IAlleleBeeSpecies)ReflectionUtils.getFieldValue(gtBeesField, aBeeObject);
            return beeType != null ? beeType : null;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    static {
        sGtBees = ReflectionUtils.getClass("gregtech.loaders.misc.GT_BeeDefinition");
    }
}

