/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import cpw.mods.fml.common.registry.EntityRegistry;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.AABB;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.handler.events.EntityDeathHandler;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import ic2.core.IC2Potion;
import ic2.core.item.armor.ItemArmorHazmat;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class EntityUtils {
    private static volatile Method dealFireDamage = null;

    public static void setEntityOnFire(Entity aEntity, int length) {
        if (!EntityUtils.isEntityImmuneToFire(aEntity)) {
            aEntity.func_70015_d(length);
        }
    }

    public static boolean isEntityOnFire(Entity aEntity) {
        Field aIsOnFire = ReflectionUtils.getField(Entity.class, "fire");
        if (aIsOnFire != null) {
            int aFireTime = (Integer)ReflectionUtils.getFieldValue(aIsOnFire, aEntity);
            return aFireTime > 0;
        }
        return false;
    }

    public static boolean isEntityImmuneToFire(Entity aEntity) {
        return aEntity.func_70045_F();
    }

    public static int getFacingDirection(Entity entity) {
        int d = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        return d;
    }

    public static Block findBlockUnderEntity(Entity parEntity) {
        int blockX = MathHelper.func_76128_c((double)parEntity.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)parEntity.field_70121_D.field_72338_b) - 1;
        int blockZ = MathHelper.func_76128_c((double)parEntity.field_70161_v);
        return parEntity.field_70170_p.func_147439_a(blockX, blockY, blockZ);
    }

    public static BlockPos findBlockPosUnderEntity(Entity parEntity) {
        int blockX = MathHelper.func_76128_c((double)parEntity.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)parEntity.field_70121_D.field_72338_b) - 1;
        int blockZ = MathHelper.func_76128_c((double)parEntity.field_70161_v);
        return new BlockPos(blockX, blockY, blockZ, parEntity.field_70170_p);
    }

    public static BlockPos findBlockPosOfEntity(Entity parEntity) {
        int blockX = MathHelper.func_76128_c((double)parEntity.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)parEntity.field_70121_D.field_72338_b);
        int blockZ = MathHelper.func_76128_c((double)parEntity.field_70161_v);
        return new BlockPos(blockX, blockY, blockZ, parEntity.field_70170_p);
    }

    public static void registerEntityToBiomeSpawns(Class<EntityLiving> classy, EnumCreatureType EntityType, BiomeGenBase baseBiomeGen) {
        EntityRegistry.addSpawn(classy, (int)6, (int)1, (int)5, (EnumCreatureType)EntityType, (BiomeGenBase[])new BiomeGenBase[]{baseBiomeGen});
    }

    public static boolean applyRadiationDamageToEntity(int stackSize, int radiationLevel, World world, Entity entityHolding) {
        if (!world.field_72995_K) {
            if (radiationLevel > 0 && entityHolding instanceof EntityLivingBase) {
                EntityLivingBase entityLiving = (EntityLivingBase)entityHolding;
                if (!(((EntityPlayer)entityHolding).field_71075_bZ.field_75098_d || ItemArmorHazmat.hasCompleteHazmat((EntityLivingBase)entityLiving) || GT_Utility.isWearingFullRadioHazmat((EntityLivingBase)entityLiving))) {
                    if (entityLiving.func_70660_b((Potion)IC2Potion.radiation) != null) {
                        int duration = radiationLevel * 5 + entityLiving.func_70660_b((Potion)IC2Potion.radiation).func_76459_b();
                    } else {
                        int duration = radiationLevel * 30;
                    }
                    EntityUtils.applyRadioactivity(entityLiving, radiationLevel, stackSize);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean applyRadioactivity(EntityLivingBase aEntity, int aLevel, int aAmountOfItems) {
        if (aLevel > 0 && aEntity != null && aEntity.func_70668_bt() != EnumCreatureAttribute.UNDEAD && aEntity.func_70668_bt() != EnumCreatureAttribute.ARTHROPOD && !ItemArmorHazmat.hasCompleteHazmat((EntityLivingBase)aEntity)) {
            PotionEffect tEffect = null;
            tEffect = aEntity.func_70660_b(Potion.field_76421_d);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, aLevel * 140 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76419_f);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, aLevel * 150 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76431_k);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76437_t);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, aLevel * 150 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76438_s);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76425_a[24]);
            aEntity.func_70690_d(new PotionEffect(IC2Potion.radiation.field_76415_H, aLevel * 180 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            return true;
        }
        return false;
    }

    public static boolean applyHeatDamageToEntity(int heatLevel, World world, Entity entityHolding) {
        if (!world.field_72995_K && heatLevel > 0 && entityHolding instanceof EntityLivingBase) {
            EntityLivingBase entityLiving = (EntityLivingBase)entityHolding;
            if (!((EntityPlayer)entityHolding).field_71075_bZ.field_75098_d && !GT_Utility.isWearingFullHeatHazmat((EntityLivingBase)entityLiving)) {
                return GT_Utility.applyHeatDamage((EntityLivingBase)entityLiving, (float)heatLevel);
            }
        }
        return false;
    }

    public static synchronized boolean doFireDamage(Entity entity, int amount) {
        if (dealFireDamage == null) {
            dealFireDamage = ReflectionUtils.getMethod(Entity.class, "dealFireDamage", Integer.TYPE);
        } else {
            try {
                dealFireDamage.invoke((Object)entity, amount);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static void doDamage(Entity entity, DamageSource dmg, int i) {
        entity.func_70097_a(dmg, (float)i);
    }

    public static boolean isTileEntityRegistered(Class aTileClass, String aTileName) {
        block4: {
            Field aRegistry = ReflectionUtils.getField(ReflectionUtils.getClass("net.minecraft.tileentity.TileEntity"), "nameToClassMap");
            Field aRegistry2 = ReflectionUtils.getField(ReflectionUtils.getClass("net.minecraft.tileentity.TileEntity"), "classToNameMap");
            try {
                Object o = aRegistry.get(null);
                if (o == null) break block4;
                Map nameToClassMap = (Map)o;
                if (!nameToClassMap.containsKey(aTileName)) {
                    o = aRegistry2.get(null);
                    if (o != null) {
                        Map classToNameMap = (Map)o;
                        return classToNameMap.containsKey(aTileClass);
                    }
                    break block4;
                }
                return true;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static double getDistance(Entity p1, Entity p2) {
        return Math.sqrt(Math.pow(p1.field_70165_t - p2.field_70165_t, 2.0) + Math.pow(p1.field_70163_u - p2.field_70163_u, 2.0) + Math.pow(p1.field_70161_v - p2.field_70161_v, 2.0));
    }

    public static AutoMap<Entity> getEntitiesWithinBoundingBoxExcluding(Entity aExclusion, AABB aBoundingBox) {
        if (aExclusion == null) {
            return new AutoMap<Entity>();
        }
        List aEntities = aBoundingBox.world().func_72839_b(aExclusion, aBoundingBox.get());
        return new AutoMap<Entity>(aEntities);
    }

    public static AutoMap<Entity> getEntitiesWithinBoundingBox(Class aEntityType, AABB aBoundingBox) {
        if (aEntityType == null) {
            return new AutoMap<Entity>();
        }
        List aEntities = aBoundingBox.world().func_72872_a(aEntityType, aBoundingBox.get());
        return new AutoMap<Entity>(aEntities);
    }

    public static void registerDropsForMob(Class aMobClass, ItemStack aStack, int aChance) {
        EntityUtils.registerDropsForMob(aMobClass, aStack, 1, aChance);
    }

    public static void registerDropsForMob(Class aMobClass, ItemStack aStack, int aMaxAmount, int aChance) {
        EntityDeathHandler.registerDropsForMob(aMobClass, aStack, aMaxAmount, aChance);
    }
}

