/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import gtPlusPlus.api.objects.Logger;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class EnchantingUtils {
    public static final int XP_PER_BOTTLE = 8;
    public static final int RATIO = 20;
    public static final int LIQUID_PER_XP_BOTTLE = 160;
    public static final double RATIO_MOB_ESSENCE_TO_LIQUID_XP = 13.32;

    public static int liquidToXpRatio(int liquid) {
        return liquid / 20;
    }

    public static int xpToLiquidRatio(int xp) {
        return xp * 20;
    }

    public static FluidStack getEssenceFromLiquidXp(int xpAmount) {
        if (xpAmount <= 0) {
            return null;
        }
        return EnchantingUtils.getMobEssence((int)((double)xpAmount * 13.32));
    }

    public static FluidStack getLiquidXpFromEssence(int essenceAmount) {
        if (essenceAmount <= 0) {
            return null;
        }
        return EnchantingUtils.getLiquidXP((int)((double)essenceAmount / 13.32));
    }

    public static int getLiquidForLevel(int level) {
        int xp = EnchantingUtils.getExperienceForLevel(level);
        return EnchantingUtils.xpToLiquidRatio(xp);
    }

    public static int getLevelForLiquid(int liquid) {
        int xp = EnchantingUtils.liquidToXpRatio(liquid);
        return EnchantingUtils.getLevelForExperience(xp);
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * 17;
        }
        if (level > 15 && level < 31) {
            return (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = EnchantingUtils.getLevelForExperience(level);
        int nextXP = EnchantingUtils.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (EnchantingUtils.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static FluidStack getMobEssence(int amount) {
        Logger.WARNING("Trying to get a fluid stack of Mob Essence.");
        try {
            return FluidRegistry.getFluidStack((String)"mobessence", (int)amount).copy();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static FluidStack getLiquidXP(int amount) {
        Logger.WARNING("Trying to get a fluid stack of Liquid XP.");
        try {
            return FluidRegistry.getFluidStack((String)"xpjuice", (int)amount).copy();
        }
        catch (Throwable e) {
            return null;
        }
    }
}

