/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util;

import cpw.mods.fml.common.FMLCommonHandler;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TC_Aspects;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.GTplusplus;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import ic2.core.Ic2Items;
import ic2.core.init.InternalName;
import ic2.core.item.resources.ItemCell;
import java.awt.Color;
import java.awt.Graphics;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.EnumUtils;

public class Utils {
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;
    private static short cellID = (short)15;

    public static final boolean isServer() {
        return FMLCommonHandler.instance().getEffectiveSide().isServer();
    }

    public static final boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public static TC_Aspects.TC_AspectStack getTcAspectStack(TC_Aspects aspect, long size) {
        return Utils.getTcAspectStack(aspect.name(), (int)size);
    }

    public static TC_Aspects.TC_AspectStack getTcAspectStack(String aspect, long size) {
        return Utils.getTcAspectStack(aspect, (int)size);
    }

    public static TC_Aspects.TC_AspectStack getTcAspectStack(TC_Aspects aspect, int size) {
        return Utils.getTcAspectStack(aspect.name(), size);
    }

    public static TC_Aspects.TC_AspectStack getTcAspectStack(String aspect, int size) {
        TC_Aspects.TC_AspectStack returnValue;
        block15: {
            returnValue = null;
            if (aspect.toUpperCase().equals("COGNITIO")) {
                try {
                    if (EnumUtils.isValidEnum(TC_Aspects.class, (String)"COGNITIO")) {
                        Logger.WARNING("TC Aspect found - " + aspect);
                        returnValue = new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)"COGNITIO"), (long)size);
                        break block15;
                    }
                    Logger.INFO("Fallback TC Aspect found - " + aspect + " - PLEASE UPDATE GREGTECH TO A NEWER VERSION TO REMOVE THIS MESSAGE - THIS IS NOT AN ERROR");
                    returnValue = new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)"COGNITO"), (long)size);
                }
                catch (NoSuchFieldError r) {
                    Logger.INFO("Invalid Thaumcraft Aspects - Report this issue to Alkalus");
                }
            } else if (aspect.toUpperCase().equals("EXANIMUS")) {
                try {
                    if (EnumUtils.isValidEnum(TC_Aspects.class, (String)"EXANIMUS")) {
                        Logger.WARNING("TC Aspect found - " + aspect);
                        returnValue = new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)"EXANIMUS"), (long)size);
                        break block15;
                    }
                    Logger.INFO("Fallback TC Aspect found - " + aspect + " - PLEASE UPDATE GREGTECH TO A NEWER VERSION TO REMOVE THIS MESSAGE - THIS IS NOT AN ERROR");
                    returnValue = new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)"EXAMINIS"), (long)size);
                }
                catch (NoSuchFieldError r) {
                    Logger.INFO("Invalid Thaumcraft Aspects - Report this issue to Alkalus");
                }
            } else if (aspect.toUpperCase().equals("PRAECANTATIO")) {
                try {
                    if (EnumUtils.isValidEnum(TC_Aspects.class, (String)"PRAECANTATIO")) {
                        Logger.WARNING("TC Aspect found - " + aspect);
                        returnValue = new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)"PRAECANTATIO"), (long)size);
                        break block15;
                    }
                    Logger.INFO("Fallback TC Aspect found - " + aspect + " - PLEASE UPDATE GREGTECH TO A NEWER VERSION TO REMOVE THIS MESSAGE - THIS IS NOT AN ERROR");
                    returnValue = new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)"PRAECANTIO"), (long)size);
                }
                catch (NoSuchFieldError r) {
                    Logger.INFO("Invalid Thaumcraft Aspects - Report this issue to Alkalus");
                }
            } else {
                Logger.WARNING("TC Aspect found - " + aspect);
                returnValue = new TC_Aspects.TC_AspectStack(TC_Aspects.valueOf((String)aspect), (long)size);
            }
        }
        return returnValue;
    }

    public static boolean containsMatch(boolean strict, ItemStack[] inputs, ItemStack ... targets) {
        for (ItemStack input : inputs) {
            for (ItemStack target : targets) {
                if (!Utils.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean itemMatches(ItemStack target, ItemStack input, boolean strict) {
        if (input == null || target == null) {
            return false;
        }
        return target.func_77973_b() == input.func_77973_b() && (target.func_77960_j() == Short.MAX_VALUE && !strict || target.func_77960_j() == input.func_77960_j());
    }

    public static void registerEvent(Object o) {
        MinecraftForge.EVENT_BUS.register(o);
        FMLCommonHandler.instance().bus().register(o);
    }

    public static void paintBox(Graphics g, int MinA, int MinB, int MaxA, int MaxB) {
        g.drawRect(MinA, MinB, MaxA, MaxB);
    }

    public static void sendServerMessage(String translationKey) {
        Utils.sendServerMessage((IChatComponent)new ChatComponentText(translationKey));
    }

    public static void sendServerMessage(IChatComponent chatComponent) {
        MinecraftServer.func_71276_C().func_71203_ab().func_148539_a(chatComponent);
    }

    public static boolean isIC2Steam(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        return aFluid.isFluidEqual(Utils.getIC2Steam(1L));
    }

    public static FluidStack getIC2Steam(long aAmount) {
        return FluidRegistry.getFluidStack((String)"ic2steam", (int)((int)aAmount));
    }

    public static String checkCorrectMiningToolForBlock(Block currentBlock, World currentWorld) {
        String correctTool = "";
        if (!currentWorld.field_72995_K) {
            try {
                correctTool = currentBlock.getHarvestTool(0);
                Logger.WARNING(correctTool);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return correctTool;
    }

    public static String hex2RgbFormatted(String hexString) {
        Color c = new Color(Integer.valueOf(hexString.substring(1, 3), 16), Integer.valueOf(hexString.substring(3, 5), 16), Integer.valueOf(hexString.substring(5, 7), 16));
        StringBuffer sb = new StringBuffer();
        sb.append("rgb(");
        sb.append(c.getRed());
        sb.append(",");
        sb.append(c.getGreen());
        sb.append(",");
        sb.append(c.getBlue());
        sb.append(")");
        return sb.toString();
    }

    public static Color hex2Rgb(String colorStr) {
        return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    public static Color hex2Rgb(int colourInt) {
        return Color.decode(String.valueOf(colourInt));
    }

    public static short[] hex2RgbShort(int colourInt) {
        Color rgb = Color.decode(String.valueOf(colourInt));
        short[] rgba = new short[]{(short)rgb.getRed(), (short)rgb.getGreen(), (short)rgb.getBlue(), (short)rgb.getAlpha()};
        return rgba;
    }

    public static Timer ShortTimer(int seconds) {
        Timer timer = new Timer();
        timer.schedule((TimerTask)new ShortTimerTask(), seconds * 1000);
        return timer;
    }

    public static String byteToHex(byte b) {
        int i = b & 0xFF;
        return Integer.toHexString(i);
    }

    public static Object[] convertListToArray(List<Object> sourceList) {
        Object[] targetArray = sourceList.toArray(new Object[sourceList.size()]);
        return targetArray;
    }

    public static List<Object> convertArrayToFixedSizeList(Object[] sourceArray) {
        List<Object> targetList = Arrays.asList(sourceArray);
        return targetList;
    }

    public static List<Object> convertArrayToList(Object[] sourceArray) {
        ArrayList<Object> targetList = new ArrayList<Object>(Arrays.asList(sourceArray));
        return targetList;
    }

    public static List<Object> convertArrayListToList(ArrayList<Object> sourceArray) {
        ArrayList<Object> targetList = new ArrayList<Object>(Arrays.asList(sourceArray));
        return targetList;
    }

    public static void spawnCustomParticle(Entity entity) {
        GTplusplus.proxy.generateMysteriousParticles(entity);
    }

    public static void spawnFX(World world, int x, int y, int z, String particleName, Object particleName2) {
        if (!world.field_72995_K) {
            if (particleName2 == null || particleName2.equals("")) {
                particleName2 = particleName;
            }
            int l = MathUtils.randInt(0, 4);
            double d0 = (float)x + 0.5f;
            double d1 = (float)y + 0.7f;
            double d2 = (float)z + 0.5f;
            double d3 = 0.22f;
            double d4 = 0.27f;
            if (l == 1) {
                world.func_72869_a(particleName, d0 - (double)0.27f, d1 + (double)0.22f, d2, 0.0, 0.0, 0.0);
            } else if (l == 2) {
                world.func_72869_a((String)particleName2, d0 + (double)0.27f, d1 + (double)0.22f, d2, 0.0, 0.0, 0.0);
            } else if (l == 3) {
                world.func_72869_a(particleName, d0, d1 + (double)0.22f, d2 - (double)0.27f, 0.0, 0.0, 0.0);
            } else if (l == 4) {
                world.func_72869_a((String)particleName2, d0, d1 + (double)0.22f, d2 + (double)0.27f, 0.0, 0.0, 0.0);
            } else {
                world.func_72869_a(particleName, d0, d1, d2, 0.0, 0.0, 0.0);
                if (particleName2 != null) {
                    world.func_72869_a((String)particleName2, d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static int rgbtoHexValue(int r, int g, int b) {
        if (r > 255 || g > 255 || b > 255 || r < 0 || g < 0 || b < 0) {
            return 0;
        }
        Color c = new Color(r, g, b);
        String temp = Integer.toHexString(c.getRGB() & 0xFFFFFF).toUpperCase();
        temp = Utils.appenedHexNotationToString(String.valueOf(temp));
        return Integer.decode(temp);
    }

    public static String padWithZerosLefts(String originalString, int length) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() + originalString.length() < length) {
            sb.append('0');
        }
        sb.append(originalString);
        String paddedString = sb.toString();
        return paddedString;
    }

    public static String padWithZerosRight(int value, int length) {
        String originalString = String.valueOf(value);
        StringBuilder sb = new StringBuilder();
        while (sb.length() + originalString.length() < length) {
            sb.append('0');
        }
        if (sb.length() > 0) {
            originalString = originalString + sb.toString();
        }
        String paddedString = sb.toString();
        return originalString;
    }

    public static Map<Integer, String> hexColourGenerator(int colorCount) {
        int maxColorValue = 0xFFFFFF;
        int devidedvalue = 0xFFFFFF / colorCount;
        int countValue = 0;
        HashMap<Integer, String> hexColorMap = new HashMap<Integer, String>();
        for (int a = 0; a < colorCount && 0xFFFFFF >= countValue; ++a) {
            if (a != 0) {
                hexColorMap.put(a, Integer.toHexString(0x10000 | (countValue += devidedvalue)).substring(1).toUpperCase());
                continue;
            }
            hexColorMap.put(a, Integer.toHexString(0x10000 | countValue).substring(1).toUpperCase());
        }
        return hexColorMap;
    }

    public static Map<Integer, String> hexColourGeneratorRandom(int colorCount) {
        HashMap<Integer, String> hexColorMap = new HashMap<Integer, String>();
        for (int a = 0; a < colorCount; ++a) {
            String code = "" + (int)(Math.random() * 256.0);
            code = code + code + code;
            int i = Integer.parseInt(code);
            hexColorMap.put(a, Integer.toHexString(0x1000000 | i).substring(1).toUpperCase());
            Logger.WARNING("" + Integer.toHexString(0x1000000 | i).substring(1).toUpperCase());
        }
        return hexColorMap;
    }

    public static String appenedHexNotationToString(Object hexAsStringOrInt) {
        String hexChar = "0x";
        if (hexAsStringOrInt.getClass() == String.class) {
            if (((String)hexAsStringOrInt).length() != 6) {
                String temp;
                String string = temp = Utils.padWithZerosLefts((String)hexAsStringOrInt, 6);
            }
            String result = "0x" + hexAsStringOrInt;
            return result;
        }
        if (hexAsStringOrInt.getClass() == Integer.class || hexAsStringOrInt.getClass() == Integer.TYPE) {
            String temp;
            String aa = String.valueOf(hexAsStringOrInt);
            String result = aa.length() != 6 ? (temp = Utils.padWithZerosLefts(aa, 6)) : "0x" + String.valueOf(hexAsStringOrInt);
            return result;
        }
        return null;
    }

    public static Integer appenedHexNotationToInteger(int hexAsStringOrInt) {
        String hexChar = "0x";
        Logger.WARNING(String.valueOf(hexAsStringOrInt));
        String result = "0x" + String.valueOf(hexAsStringOrInt);
        return Integer.getInteger(result);
    }

    public static boolean doesEntryExistAlreadyInOreDictionary(String OreDictName) {
        return OreDictionary.getOres((String)OreDictName).size() != 0;
    }

    public static boolean invertBoolean(boolean booleans) {
        return !booleans;
    }

    public static File getMcDir() {
        if (Utils.isClient() && Minecraft.func_71410_x() != null) {
            return Minecraft.func_71410_x().field_71412_D;
        }
        return new File(".");
    }

    public static ItemStack createInternalNameAndFluidCell(String s) {
        Logger.WARNING("1");
        InternalName yourName = (InternalName)EnumHelper.addEnum(InternalName.class, (String)s, (Class[])new Class[0], (Object[])new Object[0]);
        Logger.WARNING("2 " + yourName.name());
        ItemCell item = (ItemCell)Ic2Items.cell.func_77973_b();
        Logger.WARNING("3 " + item.func_77658_a());
        try {
            Logger.WARNING("4");
            Class<?> clz = item.getClass();
            Logger.WARNING("5 " + clz.getSimpleName());
            Method methode = clz.getDeclaredMethod("addCell", Integer.TYPE, InternalName.class, Block[].class);
            Logger.WARNING("6 " + methode.getName());
            methode.setAccessible(true);
            Logger.WARNING("7 " + methode.isAccessible());
            Object[] objectArray = new Object[3];
            short s2 = cellID;
            cellID = (short)(s2 + 1);
            objectArray[0] = s2;
            objectArray[1] = yourName;
            objectArray[2] = new Block[0];
            ItemStack temp = (ItemStack)methode.invoke((Object)item, objectArray);
            Logger.WARNING("Successfully created " + temp.func_82833_r() + "s.");
            FluidContainerRegistry.registerFluidContainer((FluidStack)FluidUtils.getFluidStack(s.toLowerCase(), 1000), (ItemStack)temp.func_77946_l(), (ItemStack)Ic2Items.cell.func_77946_l());
            ItemUtils.addItemToOreDictionary(temp.func_77946_l(), "cell" + s);
            return temp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String sanitizeString(String input, char[] aDontRemove) {
        AutoMap<String> aToRemoveMap = new AutoMap<String>();
        aToRemoveMap.put(" ");
        aToRemoveMap.put("-");
        aToRemoveMap.put("_");
        aToRemoveMap.put("~");
        aToRemoveMap.put("?");
        aToRemoveMap.put("!");
        aToRemoveMap.put("@");
        aToRemoveMap.put("#");
        aToRemoveMap.put("$");
        aToRemoveMap.put("%");
        aToRemoveMap.put("^");
        aToRemoveMap.put("&");
        aToRemoveMap.put("*");
        aToRemoveMap.put("(");
        aToRemoveMap.put(")");
        aToRemoveMap.put("{");
        aToRemoveMap.put("}");
        aToRemoveMap.put("[");
        aToRemoveMap.put("]");
        aToRemoveMap.put(" ");
        for (String s : aToRemoveMap) {
            for (char e : aDontRemove) {
                if (s.charAt(0) != e) continue;
                aToRemoveMap.remove("s");
            }
        }
        String output = input;
        for (String A : aToRemoveMap) {
            output = output.replace(A, "");
        }
        return output;
    }

    public static String sanitizeString(String input) {
        String temp = input.replace(" ", "");
        temp = temp.replace("-", "");
        temp = temp.replace("_", "");
        temp = temp.replace("?", "");
        temp = temp.replace("!", "");
        temp = temp.replace("@", "");
        temp = temp.replace("#", "");
        temp = temp.replace("(", "");
        temp = temp.replace(")", "");
        temp = temp.replace("{", "");
        temp = temp.replace("}", "");
        temp = temp.replace("[", "");
        temp = temp.replace("]", "");
        String output = temp = temp.replace(" ", "");
        return output;
    }

    public static String sanitizeStringKeepBrackets(String input) {
        String temp = input.replace(" ", "");
        temp = temp.replace("-", "");
        temp = temp.replace("_", "");
        temp = temp.replace("?", "");
        temp = temp.replace("!", "");
        temp = temp.replace("@", "");
        temp = temp.replace("#", "");
        String output = temp = temp.replace(" ", "");
        return output;
    }

    public static String[] parseVersion(String version) {
        return Utils.parseVersion(version, "//.");
    }

    public static String[] parseVersion(String version, String delimiter) {
        String[] versionArray = version.split(delimiter);
        return versionArray;
    }

    public static Versioning compareModVersion(String currentVersion, String expectedVersion) {
        return Utils.compareModVersion(currentVersion, expectedVersion, "//.");
    }

    public static Versioning compareModVersion(String currentVersion, String expectedVersion, String delimiter) {
        int r;
        int r2;
        String[] a = Utils.parseVersion(currentVersion, delimiter);
        String[] b = Utils.parseVersion(expectedVersion, delimiter);
        int[] c = new int[a.length];
        int[] d = new int[b.length];
        for (r2 = 0; r2 < a.length; ++r2) {
            c[r2] = Integer.parseInt(a[r2]);
        }
        for (r2 = 0; r2 < b.length; ++r2) {
            d[r2] = Integer.parseInt(b[r2]);
        }
        Versioning[] e = new Versioning[MathUtils.returnLargestNumber(c.length, d.length)];
        for (r = 0; r < e.length; ++r) {
            if (c[r] > d[r]) {
                e[r] = Versioning.NEWER;
                continue;
            }
            if (c[r] < d[r]) {
                e[r] = Versioning.OLDER;
                continue;
            }
            if (c[r] != d[r]) continue;
            e[r] = Versioning.EQUAL;
        }
        r = 0;
        if (r < e.length) {
            if (e[0] == Versioning.NEWER) {
                return Versioning.NEWER;
            }
            if (e[0] == Versioning.OLDER) {
                return Versioning.OLDER;
            }
            if (e[r] == Versioning.OLDER) {
                // empty if block
            }
            return Versioning.NEWER;
        }
        return null;
    }

    public static Item.ToolMaterial generateToolMaterialFromGT(Materials gtMaterial) {
        String name = Utils.sanitizeString(gtMaterial.mDefaultLocalName);
        byte harvestLevel = gtMaterial.mToolQuality;
        int durability = gtMaterial.mDurability;
        float damage = gtMaterial.mToolQuality;
        int efficiency = (int)gtMaterial.mToolSpeed;
        byte enchantability = gtMaterial.mEnchantmentToolsLevel;
        Item.ToolMaterial temp = EnumHelper.addToolMaterial((String)name, (int)harvestLevel, (int)durability, (float)efficiency, (float)damage, (int)enchantability);
        return temp;
    }

    public static String addBookTitleLocalization(String aTitle) {
        return GT_LanguageManager.addStringLocalization((String)("Book." + aTitle + ".Name"), (String)aTitle, (!GregTech_API.sPostloadFinished ? 1 : 0) != 0);
    }

    public static String[] addBookPagesLocalization(String aTitle, String[] aPages) {
        String[] aLocalizationPages = new String[aPages.length];
        for (byte i = 0; i < aPages.length; i = (byte)(i + 1)) {
            aLocalizationPages[i] = GT_LanguageManager.addStringLocalization((String)("Book." + aTitle + ".Page" + (i < 10 ? "0" + i : Byte.valueOf(i))), (String)aPages[i], (!GregTech_API.sPostloadFinished ? 1 : 0) != 0);
        }
        return aLocalizationPages;
    }

    public static ItemStack getWrittenBook(ItemStack aBook, int aID, String aMapping, String aTitle, String aAuthor, String[] aPages) {
        if (GT_Utility.isStringInvalid((Object)aMapping)) {
            return null;
        }
        ItemStack rStack = CORE.sBookList.get(aMapping);
        if (rStack != null) {
            return GT_Utility.copyAmount((long)1L, (Object[])new Object[]{rStack});
        }
        if (GT_Utility.isStringInvalid((Object)aTitle) || GT_Utility.isStringInvalid((Object)aAuthor) || aPages.length <= 0) {
            return null;
        }
        int vMeta = aID;
        rStack = aBook == null ? new ItemStack(ModItems.itemCustomBook, 1, vMeta) : aBook;
        NBTTagCompound tNBT = new NBTTagCompound();
        String localizationTitle = Utils.addBookTitleLocalization(aTitle);
        tNBT.func_74778_a("title", localizationTitle);
        tNBT.func_74778_a("author", aAuthor);
        NBTTagList tNBTList = new NBTTagList();
        String[] aLocalizationPages = Utils.addBookPagesLocalization(aTitle, aPages);
        for (int i = 0; i < aPages.length; i = (int)((byte)(i + 1))) {
            aPages[i] = aLocalizationPages[i].replaceAll("<BR>", "\n");
            if (i < 48) {
                if (aPages[i].length() < 256) {
                    tNBTList.func_74742_a((NBTBase)new NBTTagString(aPages[i]));
                    continue;
                }
                Logger.INFO("WARNING: String for written Book too long! -> " + aPages[i]);
                GT_Log.err.println(new StringBuilder().append("WARNING: String for written Book too long! -> ").append(aPages[i]));
                continue;
            }
            Logger.INFO("WARNING: Too much Pages for written Book! -> " + aTitle);
            GT_Log.err.println(new StringBuilder().append("WARNING: Too much Pages for written Book! -> ").append(aTitle));
            break;
        }
        tNBTList.func_74742_a((NBTBase)new NBTTagString("Credits to " + aAuthor + " for writing this Book. This was Book Nr. " + aID + " at its creation. Gotta get 'em all!"));
        tNBT.func_74782_a("pages", (NBTBase)tNBTList);
        rStack.func_77982_d(tNBT);
        GT_Log.out.println(new StringBuilder().append("GT++_Mod: Added Book to Book++ List  -  Mapping: '").append(aMapping).append("'  -  Name: '").append(aTitle).append("'  -  Author: '").append(aAuthor).append("'"));
        NBTUtils.createIntegerTagCompound(rStack, "stats", "mMeta", vMeta);
        CORE.sBookList.put(aMapping, rStack);
        Logger.INFO("Creating book: " + aTitle + " by " + aAuthor + ". Using Meta " + vMeta + ".");
        return GT_Utility.copy((Object[])new Object[]{rStack});
    }

    public static long getMillisSince(long aStartTime, long aCurrentTime) {
        return aCurrentTime - aStartTime;
    }

    public static byte getTier(long l) {
        byte i = -1;
        do {
            if ((i = (byte)((byte)(i + 1))) < GT_Values.V.length) continue;
            return i;
        } while (l > GT_Values.V[i]);
        i = (byte)MathUtils.getValueWithinRange(i, 0, 15);
        return i;
    }

    static class ShortTimerTask
    extends TimerTask {
        ShortTimerTask() {
        }

        @Override
        public void run() {
            Logger.WARNING("Timer expired.");
        }
    }

    public static enum Versioning {
        EQUAL(0),
        NEWER(1),
        OLDER(-1);

        private final int versioningInfo;

        private Versioning(int versionStatus) {
            this.versioningInfo = versionStatus;
        }

        public int getTexture() {
            return this.versioningInfo;
        }
    }
}

