/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base.ingots;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IGT_RecipeMap;
import gregtech.api.util.GT_Recipe;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.item.base.BaseItemComponent;
import gtPlusPlus.core.item.base.ingots.BaseItemIngot;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BaseItemIngotHot
extends BaseItemIngot {
    private final ItemStack outputIngot;
    private int tickCounter = 0;
    private final int tickCounterMax = 200;
    private final int mTier;
    private IIcon base;
    private IIcon overlay;

    public BaseItemIngotHot(Material material) {
        super(material, BaseItemComponent.ComponentTypes.HOTINGOT);
        this.func_111206_d(Mods.GTPlusPlus.ID + ":itemIngotHot");
        this.outputIngot = material.getIngot(1);
        this.mTier = material.vTier;
        this.generateRecipe();
    }

    @Override
    public String func_77653_i(ItemStack p_77653_1_) {
        return super.func_77653_i(p_77653_1_);
    }

    @Override
    public int func_82790_a(ItemStack stack, int HEX_OxFFFFFF) {
        return Utils.rgbtoHexValue(225, 225, 225);
    }

    private void generateRecipe() {
        Logger.WARNING("Adding Vacuum Freezer recipe for a Hot Ingot of " + this.materialName + ".");
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{ItemUtils.getSimpleStack(this)}).itemOutputs(new ItemStack[]{this.outputIngot.func_77946_l()}).duration(Math.max(this.componentMaterial.getMass() * 3L, 1L) * 1L).eut(this.componentMaterial.vVoltageMultiplier).addTo((IGT_RecipeMap)GT_Recipe.GT_Recipe_Map.sVacuumRecipes);
    }

    @Override
    public void func_77663_a(ItemStack iStack, World world, Entity entityHolding, int p_77663_4_, boolean p_77663_5_) {
        if (this.componentMaterial != null && entityHolding != null && entityHolding instanceof EntityPlayer && !((EntityPlayer)entityHolding).field_71075_bZ.field_75098_d) {
            EntityUtils.applyHeatDamageToEntity(1, world, entityHolding);
        }
        super.func_77663_a(iStack, world, entityHolding, p_77663_4_, p_77663_5_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return CORE.ConfigSwitches.useGregtechTextures;
    }

    @Override
    public void func_94581_a(IIconRegister i) {
        if (CORE.ConfigSwitches.useGregtechTextures) {
            this.base = i.func_94245_a(Mods.GregTech.ID + ":materialicons/METALLIC/ingotHot");
            this.overlay = i.func_94245_a(Mods.GregTech.ID + ":materialicons/METALLIC/ingotHot_OVERLAY");
        } else {
            this.base = i.func_94245_a(Mods.GTPlusPlus.ID + ":item" + BaseItemComponent.ComponentTypes.HOTINGOT.getComponent());
        }
    }

    @Override
    public IIcon func_77618_c(int damage, int pass) {
        if (pass == 0 && CORE.ConfigSwitches.useGregtechTextures) {
            return this.base;
        }
        if (pass == 1 && CORE.ConfigSwitches.useGregtechTextures) {
            return this.overlay;
        }
        return this.overlay;
    }
}

